<?php
session_start();
define('BASE_PATH', dirname(__FILE__));
include BASE_PATH . '/includes/db.php';
include BASE_PATH . '/includes/header.php';
include BASE_PATH . '/includes/document_helper.php'; // NUEVO HELPER

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require BASE_PATH . '/vendor/autoload.php';

// Verificar si la recuperación de contraseña está habilitada
$password_reset_enabled = false;
$sql_config = "SELECT setting_value FROM app_settings WHERE setting_key = 'password_reset_enabled'";
$result_config = $conn->query($sql_config);
if ($result_config && $result_config->num_rows > 0) {
    $config = $result_config->fetch_assoc();
    $password_reset_enabled = ($config['setting_value'] == '1');
}

if (!$password_reset_enabled) {
    echo '<div class="container mt-5">
            <div class="alert alert-warning text-center">
                <h4>Función No Disponible</h4>
                <p>La recuperación de contraseña se encuentra deshabilitada temporalmente.</p>
                <a href="login.php" class="btn btn-primary">Volver al Login</a>
            </div>
          </div>';
    include BASE_PATH . '/includes/footer.php';
    exit();
}

$error_message = '';
$success_message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $documento = trim($_POST['documento']);
    
    if (empty($documento)) {
        $error_message = "Por favor, ingresa tu número de documento.";
    } else {
        // Buscar usuario por cualquier tipo de documento usando el nuevo helper
        $usuario = buscarUsuarioPorDocumento($conn, $documento);
        
        if ($usuario) {
            $email = obtenerEmailUsuario($usuario);
            $nombre_completo = obtenerNombreCompletoUsuario($usuario);
            
            if (empty($email)) {
                $error_message = "No se encontró un correo electrónico asociado a esta cuenta.";
            } else {
                // Generar token único
                $token = bin2hex(random_bytes(50));
                $expiration = date('Y-m-d H:i:s', strtotime('+1 hour'));
                
                // Guardar token en la base de datos
                $sql_token = "INSERT INTO password_reset_tokens (user_id, token, expiration) VALUES (?, ?, ?)";
                $stmt_token = $conn->prepare($sql_token);
                
                if ($stmt_token === false) {
                    $error_message = "Error al generar token: " . $conn->error;
                } else {
                    $stmt_token->bind_param('iss', $usuario['id'], $token, $expiration);
                    
                    if ($stmt_token->execute()) {
                        // Enviar correo con el enlace de recuperación
                        include BASE_PATH . '/config/mail_config.php';
                        
                        if (!verificar_configuracion_correo()) {
                            $error_message = "Configuración de correo incompleta. Contacta al administrador.";
                        } else {
                            try {
                                $mail = new PHPMailer(true);
                                $mail->isSMTP();
                                $mail->Host       = MAIL_HOST;
                                $mail->SMTPAuth   = MAIL_SMTP_AUTH;
                                $mail->Username   = MAIL_USERNAME;
                                $mail->Password   = MAIL_PASSWORD;
                                $mail->SMTPSecure = MAIL_ENCRYPTION;
                                $mail->Port       = MAIL_PORT;
                                $mail->CharSet    = 'UTF-8';
                                $mail->Timeout    = MAIL_TIMEOUT;
                                
                                $mail->setFrom(MAIL_FROM_EMAIL, MAIL_FROM_NAME);
                                $mail->addAddress($email, $nombre_completo);
                                $mail->addReplyTo(SUPPORT_EMAIL, 'Soporte del Sistema');

                                $reset_link = SITE_URL . "/reset_password.php?token=" . $token;
                                
                                $mail->isHTML(true);
                                $mail->Subject = 'Restablecer Contraseña - Sistema de Postgrado';
                                
                                // Determinar tipo de usuario para el mensaje
                                $tipo_usuario = (!empty($usuario['estudiante_id'])) ? 'estudiante' : 'administrativo';
                                $rol_display = ($tipo_usuario == 'estudiante') ? 'Estudiante' : ucfirst($usuario['rol']);
                                
                                $mail->Body = "
                                <!DOCTYPE html>
                                <html lang='es'>
                                <head>
                                    <meta charset='UTF-8'>
                                    <style>
                                        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
                                        .container { max-width: 600px; margin: 0 auto; background: #f9f9f9; padding: 20px; border-radius: 10px; }
                                        .header { background: #007bff; color: white; padding: 20px; text-align: center; border-radius: 10px 10px 0 0; }
                                        .content { padding: 20px; background: white; }
                                        .button { display: inline-block; background: #007bff; color: white; padding: 12px 25px; text-decoration: none; border-radius: 5px; }
                                        .footer { text-align: center; padding: 20px; color: #666; font-size: 12px; }
                                        .alert { background: #fff3cd; border: 1px solid #ffeaa7; padding: 10px; border-radius: 5px; margin: 15px 0; }
                                        .user-info { background: #e9ecef; padding: 10px; border-radius: 5px; margin: 10px 0; }
                                    </style>
                                </head>
                                <body>
                                    <div class='container'>
                                        <div class='header'>
                                            <h2>Restablecer Contraseña</h2>
                                        </div>
                                        <div class='content'>
                                            <p>Hola <strong>{$nombre_completo}</strong>,</p>
                                            <div class='user-info'>
                                                <strong>Tipo de Cuenta:</strong> {$rol_display}<br>
                                                <strong>Usuario:</strong> {$usuario['username']}
                                            </div>
                                            <p>Has solicitado restablecer tu contraseña para el Sistema de Postgrado.</p>
                                            <p style='text-align: center;'>
                                                <a href='{$reset_link}' class='button'>Restablecer Contraseña</a>
                                            </p>
                                            <p>Si el botón no funciona, copia y pega este enlace en tu navegador:</p>
                                            <p><code>{$reset_link}</code></p>
                                            <div class='alert'>
                                                <strong>⚠️ Importante:</strong> Este enlace expirará en 1 hora. Si no lo usas en ese tiempo, deberás solicitar uno nuevo.
                                            </div>
                                            <p>Si no solicitaste este restablecimiento, ignora este mensaje.</p>
                                        </div>
                                        <div class='footer'>
                                            <p>Sistema de Postgrado - Medicina UCV</p>
                                        </div>
                                    </div>
                                </body>
                                </html>";
                                
                                $mail->AltBody = "Restablecer Contraseña - Sistema de Postgrado\n\n" .
                                                "Hola {$nombre_completo},\n\n" .
                                                "Para restablecer tu contraseña, visita: {$reset_link}\n\n" .
                                                "Este enlace expira en 1 hora.\n\n" .
                                                "Si no solicitaste esto, ignora este mensaje.";
                                
                                if ($mail->send()) {
                                    $success_message = "Se ha enviado un enlace de recuperación a tu correo electrónico. Revisa tu bandeja de entrada y carpeta de spam.";
                                } else {
                                    $error_message = "Error al enviar el correo. Por favor, contacta al administrador.";
                                }
                                
                            } catch (Exception $e) {
                                $error_message = "Error al enviar el correo: " . $e->getMessage();
                            }
                        }
                        
                    } else {
                        $error_message = "Error al procesar la solicitud: " . $stmt_token->error;
                    }
                    $stmt_token->close();
                }
            }
        } else {
            $error_message = "No se encontró ningún usuario con ese documento.";
        }
    }
}
?>

<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h4 class="mb-0">Recuperar Contraseña</h4>
                </div>
                <div class="card-body">
                    <?php if ($error_message): ?>
                        <div class="alert alert-danger"><?php echo $error_message; ?></div>
                    <?php endif; ?>
                    
                    <?php if ($success_message): ?>
                        <div class="alert alert-success"><?php echo $success_message; ?></div>
                        <div class="text-center">
                            <a href="login.php" class="btn btn-primary">Volver al Login</a>
                        </div>
                    <?php else: ?>
                        <p>Ingresa tu número de documento para recibir un enlace de recuperación.</p>
                        <div class="alert alert-info">
                            <strong>Documentos aceptados:</strong><br>
                            • Cédula Venezolana<br>
                            • Cédula Extranjera<br>
                            • Pasaporte<br>
                            • Usuario del sistema
                        </div>
                        <form method="POST" action="">
                            <div class="mb-3">
                                <label for="documento" class="form-label">Documento *</label>
                                <input type="text" class="form-control" id="documento" name="documento" required 
                                       value="<?php echo isset($_POST['documento']) ? htmlspecialchars($_POST['documento']) : ''; ?>"
                                       placeholder="Cédula, pasaporte o usuario">
                                <div class="form-text">Funciona para estudiantes y personal administrativo.</div>
                            </div>
                            <button type="submit" class="btn btn-primary w-100">Enviar Enlace de Recuperación</button>
                        </form>
                        <div class="text-center mt-3">
                            <a href="login.php">Volver al Login</a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include BASE_PATH . '/includes/footer.php'; ?>