<?php
session_start();

// Headers de seguridad adicionales
header("X-Frame-Options: DENY");
header("X-Content-Type-Options: nosniff");
header("X-XSS-Protection: 1; mode=block");
header("Referrer-Policy: strict-origin-when-cross-origin");

// Generar token CSRF
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// Autenticación y rol
if (!isset($_SESSION['username']) || ($_SESSION['rol'] != 'administrador' && $_SESSION['rol'] != 'coordinador2')) {
    header("Location: ../login.php");
    exit();
}

require_once __DIR__ . '/../includes/db.php';

if ($conn->connect_error) {
    die("Error de conexión: " . $conn->connect_error);
}

// Habilitar reportes de error para depuración
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

// Obtener listado de postgrados con todas las promociones posibles
$query = "SELECT p.id, p.nombre, pr.id as promocion_id, pr.nombre as promocion_nombre 
          FROM postgrados p
          LEFT JOIN estudiante_postgrado ep ON p.id = ep.postgrado_id
          LEFT JOIN promociones pr ON ep.promocion_id = pr.id
          GROUP BY p.id, pr.id
          ORDER BY p.nombre, pr.nombre";
$postgrados = $conn->query($query)->fetch_all(MYSQLI_ASSOC);

// Agrupar por postgrado
$postgrados_agrupados = [];
foreach($postgrados as $postgrado) {
    if(!isset($postgrados_agrupados[$postgrado['id']])) {
        $postgrados_agrupados[$postgrado['id']] = [
            'nombre' => $postgrado['nombre'],
            'promociones' => []
        ];
    }
    if($postgrado['promocion_id']) {
        $postgrados_agrupados[$postgrado['id']]['promociones'][$postgrado['promocion_id']] = $postgrado['promocion_nombre'];
    }
}

$page_title = "Generar Reporte de Graduando";
include '../includes/header.php'; 
?>

<div class="container">
    <!-- Botón Volver arriba a la izquierda -->
    <div class="mb-4">
        <?php if ($_SESSION['rol'] == 'administrador'): ?>
            <a href="../admin" class="btn btn-secondary">
                <i class="bi bi-arrow-left-circle-fill"></i> Volver al Menú Principal
            </a>
        <?php elseif ($_SESSION['rol'] == 'coordinador2'): ?>
            <a href="../coordinador2" class="btn btn-secondary">
                <i class="bi bi-arrow-left-circle-fill"></i> Volver al Menú Principal
            </a>
        <?php endif; ?>
    </div>

    <div class="text-center mb-4">
        <h1 class="display-4">Generar Reporte de Graduando</h1>
        <p class="lead">Seleccione el postgrado y la promoción</p>
    </div>

    <div class="card mb-4">
        <div class="card-header bg-primary text-white">
            <h5>Selección de Reporte</h5>
        </div>
        <div class="card-body">
            <?php if(isset($_GET['error'])): ?>
                <div class="alert alert-danger">Error: <?= htmlspecialchars($_GET['error']) ?></div>
            <?php endif; ?>
            
            <form id="reportForm">
                <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
                
                <div class="mb-3">
                    <label for="postgrado_id" class="form-label">Postgrado:</label>
                    <select name="postgrado_id" id="postgrado_id" class="form-select" required onchange="actualizarPromociones()">
                        <option value="">Seleccione un postgrado</option>
                        <?php foreach($postgrados_agrupados as $id => $postgrado): ?>
                            <option value="<?= $id ?>"><?= htmlspecialchars($postgrado['nombre']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="mb-3">
                    <label for="promocion_id" class="form-label">Promoción:</label>
                    <select name="promocion_id" id="promocion_id" class="form-select" required>
                        <option value="">Seleccione primero un postgrado</option>
                    </select>
                </div>

                <div class="d-grid gap-2 d-md-flex justify-content-md-center mt-4">
                    <button type="button" onclick="previewReport()" class="btn btn-success me-md-2">
                        <i class="bi bi-eye-fill"></i> Previsualizar
                    </button>
                    <button type="button" onclick="downloadReport()" class="btn btn-primary">
                        <i class="bi bi-file-earmark-excel-fill"></i> Descargar Excel
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    // Datos de promociones por postgrado
    const postgradosData = <?= json_encode($postgrados_agrupados) ?>;

    function actualizarPromociones() {
        const postgradoId = document.getElementById('postgrado_id').value;
        const promocionSelect = document.getElementById('promocion_id');
        
        promocionSelect.innerHTML = '<option value="">Seleccione una promoción</option>';
        
        if(postgradoId && postgradosData[postgradoId] && postgradosData[postgradoId].promociones) {
            Object.entries(postgradosData[postgradoId].promociones).forEach(([id, nombre]) => {
                const option = document.createElement('option');
                option.value = id;
                option.textContent = nombre;
                promocionSelect.appendChild(option);
            });
        }
    }

    function previewReport() {
        const form = document.getElementById('reportForm');
        const postgradoId = form.postgrado_id.value;
        const promocionId = form.promocion_id.value;
        
        if(postgradoId && promocionId) {
            window.open(`generar_reporte.php?postgrado_id=${postgradoId}&promocion_id=${promocionId}&preview=1`, '_blank');
        } else {
            alert('Por favor seleccione un postgrado y una promoción');
        }
    }

    function downloadReport() {
        const form = document.getElementById('reportForm');
        const postgradoId = form.postgrado_id.value;
        const promocionId = form.promocion_id.value;
        
        if(postgradoId && promocionId) {
            window.location.href = `generar_reporte.php?postgrado_id=${postgradoId}&promocion_id=${promocionId}`;
        } else {
            alert('Por favor seleccione un postgrado y una promoción');
        }
    }
</script>

<?php 
include '../includes/footer.php';
$conn->close();
?>