<?php

include '../includes/db.php';

// Consulta para el reporte 1
$sql = "SELECT e.cedula, e.nombres, e.apellidos, p.nombre AS postgrado, d.nombre AS denominacion, 
               i.nota_final, i.nota_definitiva 
        FROM inscripciones i
        JOIN estudiantes e ON i.estudiante_id = e.id
        JOIN denominaciones d ON i.denominacion_id = d.id
        JOIN postgrados p ON d.postgrado_id = p.id";

// Ejecutar la consulta
$result = $conn->query($sql);

// Verificar si la consulta falló
if ($result === false) {
    die("Error en la consulta SQL: " . $conn->error);
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Reporte 1</title>
    <link rel="stylesheet" href="../css/styles.css">
</head>
<body>
    <h1>Reporte 1</h1>
    <a href="../admin/index.php">Volver al Inicio</a>

    <!-- Tabla de reporte 1 -->
    <table>
        <tr>
            <th>Cédula</th>
            <th>Nombres</th>
            <th>Apellidos</th>
            <th>Postgrado</th>
            <th>Denominación</th>
            <th>Nota Final</th>
            <th>Nota Definitiva</th>
        </tr>
        <?php
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                echo "<tr>
                        <td>{$row['cedula']}</td>
                        <td>{$row['nombres']}</td>
                        <td>{$row['apellidos']}</td>
                        <td>{$row['postgrado']}</td>
                        <td>{$row['denominacion']}</td>
                        <td>{$row['nota_final']}</td>
                        <td>{$row['nota_definitiva']}</td>
                      </tr>";
            }
        } else {
            echo "<tr><td colspan='7'>No hay inscripciones registradas.</td></tr>";
        }
        ?>
    </table>
</body>
</html>