<?php
// 1. CONFIGURACIÓN DE ENTORNO
// error_reporting(E_ALL & ~E_DEPRECATED & ~E_STRICT);
// ini_set('display_errors', 0); // 0 en producción, 1 en desarrollo

// 2. CODIFICACIÓN DE CARACTERES
ini_set('default_charset', 'UTF-8');
mb_internal_encoding('UTF-8');
header('Content-Type: text/html; charset=utf-8');

// 3. RUTA RAÍZ DEL PROYECTO (ROOT_PATH)
if (!defined('ROOT_PATH')) {
    define('ROOT_PATH', dirname(__DIR__));
}

// 4. URL BASE DINÁMICA (BASE_URL) - CORREGIDO
if (!defined('BASE_URL')) {
    // Forzar la URL correcta para cepmed
    define('BASE_URL', '/cepmed');
    
    /* COMENTA TEMPORALMENTE EL CÓDIGO ANTERIOR SI EXISTE:
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
    $host = $_SERVER['HTTP_HOST'];
    $base_dir = str_replace('\\', '/', realpath(ROOT_PATH));
    $doc_root = str_replace('\\', '/', realpath($_SERVER['DOCUMENT_ROOT']));
    $base_url = str_replace($doc_root, '', $base_dir);
    define('BASE_URL', rtrim($base_url, '/'));
    */
}

// --- LÓGICA ORIGINAL DEL ARCHIVO ---

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Este archivo se debe incluir al principio de las páginas seguras.

if (!isset($conn)) {
    // Asegurarse de que la conexión a la BD esté disponible.
    require_once ROOT_PATH . '/includes/db.php';
}

// Ahora que $conn está garantizado, ejecutamos la consulta.
if (isset($conn)) {
    $sql_session = "SELECT setting_key, setting_value FROM app_settings WHERE setting_key IN ('session_duration', 'session_never_expire')";
    $result_session = $conn->query($sql_session);

    $_SESSION['app_settings'] = [];
    if ($result_session) {
        while ($row = $result_session->fetch_assoc()) {
            $_SESSION['app_settings'][$row['setting_key']] = $row['setting_value'];
        }
    }
}
?>