<?php
// Centralized authentication and session check
$allowed_roles = ['coordinador2'];
require_once __DIR__ . '/../includes/auth_check.php';
 
include '../includes/db.php';

// Obtener los postgrados que administra este coordinador
$sql_postgrados = "SELECT p.id, p.nombre 
                  FROM coordinador_postgrado cp
                  JOIN postgrados p ON cp.postgrado_id = p.id
                  WHERE cp.coordinador_id = ?";
$stmt_postgrados = $conn->prepare($sql_postgrados);
$stmt_postgrados->bind_param("i", $_SESSION['user_id']);
$stmt_postgrados->execute();
$result_postgrados = $stmt_postgrados->get_result();

// Configurar el título de la página
$page_title = "Panel Coordinador2 - UCV";
include '../includes/header.php';
?>

<div class="container">
    <div class="card">
        <h2>Bienvenido al panel de coordinación</h2>
        <p>Desde aquí podrás gestionar las principales funciones administrativas del postgrado.</p>
        
        <?php if ($result_postgrados->num_rows > 0): ?>
            <h3 style="margin-top: 1.5rem;">Postgrados que administras:</h3>
            <ul class="postgrados-list">
                <?php while ($postgrado = $result_postgrados->fetch_assoc()): ?>
                    <li><?= htmlspecialchars($postgrado['nombre']) ?></li>
                <?php endwhile; ?>
            </ul>
        <?php else: ?>
            <div class="alert alert-warning" style="margin-top: 1.5rem; background: #fff3cd; padding: 0.75rem 1.25rem; border-radius: 4px;">
                No tienes postgrados asignados. Contacta al administrador.
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
    .postgrados-list {
        margin-top: 1rem;
        padding-left: 1.5rem;
    }
    .postgrados-list li {
        margin-bottom: 0.5rem;
        position: relative;
    }
    .postgrados-list li:before {
        content: "•";
        color: #3498db;
        font-weight: bold;
        display: inline-block;
        width: 1em;
        margin-left: -1em;
    }
</style>

<?php
include '../includes/footer.php'; // Asegurarse de que el footer se incluye
$conn->close();
?>