<?php
session_start();
include '../includes/db.php';

// Verificar sesión y rol
if (!isset($_SESSION['username']) || $_SESSION['rol'] != 'coordinador2') {
    header("Location: ../login.php");
    exit();
}

// Verificar conexión a la base de datos
if ($conn->connect_error) {
    die("Error de conexión: " . $conn->connect_error);
}

$coordinador_id = $_SESSION['user_id'];
$mensaje = '';
$error = '';

// Procesar formulario de nuevo estudiante
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['nuevo_estudiante'])) {
    $cedula = trim($_POST['cedula']);
    $nombres = trim($_POST['nombres']);
    $apellidos = trim($_POST['apellidos']);
    $postgrado_id = intval($_POST['postgrado_id']);
    
    if (empty($cedula) || empty($nombres) || empty($apellidos) || $postgrado_id <= 0) {
        $_SESSION['error'] = "Todos los campos son obligatorios";
    } else {
        $sql_verificar = "SELECT 1 FROM coordinador_postgrado WHERE coordinador_id = ? AND postgrado_id = ?";
        $stmt_verificar = $conn->prepare($sql_verificar);
        $stmt_verificar->bind_param("ii", $coordinador_id, $postgrado_id);
        $stmt_verificar->execute();
        $result_verificar = $stmt_verificar->get_result();
        
        if ($result_verificar->num_rows == 0) {
            $_SESSION['error'] = "No tienes permisos para asignar estudiantes a este postgrado";
        } else {
            $sql_existe = "SELECT id FROM estudiantes WHERE cedula = ?";
            $stmt_existe = $conn->prepare($sql_existe);
            $stmt_existe->bind_param("s", $cedula);
            $stmt_existe->execute();
            $result_existe = $stmt_existe->get_result();
            
            if ($result_existe->num_rows > 0) {
                $_SESSION['error'] = "Ya existe un estudiante con esta cédula";
            } else {
                $conn->begin_transaction();
                try {
                    $sql_estudiante = "INSERT INTO estudiantes (cedula, nombres, apellidos) VALUES (?, ?, ?)";
                    $stmt_estudiante = $conn->prepare($sql_estudiante);
                    $stmt_estudiante->bind_param("sss", $cedula, $nombres, $apellidos);
                    $stmt_estudiante->execute();
                    $estudiante_id = $stmt_estudiante->insert_id;
                    
                    $sql_asignar = "INSERT INTO estudiante_postgrado (estudiante_id, postgrado_id, estado) VALUES (?, ?, 'activo')";
                    $stmt_asignar = $conn->prepare($sql_asignar);
                    $stmt_asignar->bind_param("ii", $estudiante_id, $postgrado_id);
                    $stmt_asignar->execute();
                    
                    $conn->commit();
                    $_SESSION['success'] = "Estudiante registrado y asignado al postgrado correctamente";
                } catch (Exception $e) {
                    $conn->rollback();
                    $_SESSION['error'] = "Error al registrar el estudiante: " . $e->getMessage();
                }
            }
        }
    }
    header("Location: carga_estudiantes_graduacion.php");
    exit();
}

// ... (resto de la lógica POST) ...

$page_title = "Gestión de Estudiantes - Coordinador";
include '../includes/header.php';

// Obtener datos para la página
$sql_postgrados = "SELECT p.id, p.nombre FROM postgrados p JOIN coordinador_postgrado cp ON p.id = cp.postgrado_id WHERE cp.coordinador_id = ?";
$stmt_postgrados = $conn->prepare($sql_postgrados);
$stmt_postgrados->bind_param("i", $coordinador_id);
$stmt_postgrados->execute();
$postgrados = $stmt_postgrados->get_result();

$sql_estudiantes = "SELECT e.id, e.cedula, e.nombres, e.apellidos, p.nombre as postgrado_nombre, ep.postgrado_id, ep.fecha_graduacion, pr.nombre as promocion_nombre, ep.estado FROM estudiantes e JOIN estudiante_postgrado ep ON e.id = ep.estudiante_id JOIN postgrados p ON ep.postgrado_id = p.id LEFT JOIN promociones pr ON ep.promocion_id = pr.id JOIN coordinador_postgrado cp ON ep.postgrado_id = cp.postgrado_id WHERE cp.coordinador_id = ? ORDER BY ep.estado, e.apellidos, e.nombres";
$stmt_estudiantes = $conn->prepare($sql_estudiantes);
$stmt_estudiantes->bind_param("i", $coordinador_id);
$stmt_estudiantes->execute();
$estudiantes = $stmt_estudiantes->get_result();

$denominaciones_estudiante = [];
if (isset($_GET['estudiante_id'])) {
    $estudiante_id = intval($_GET['estudiante_id']);
    $sql_denominaciones = "SELECT i.id, d.codigo, d.nombre, i.nota_definitiva, d.tipo FROM inscripciones i JOIN denominaciones d ON i.denominacion_id = d.id WHERE i.estudiante_id = ? ORDER BY d.periodo, d.codigo";
    $stmt_denominaciones = $conn->prepare($sql_denominaciones);
    $stmt_denominaciones->bind_param("i", $estudiante_id);
    $stmt_denominaciones->execute();
    $denominaciones_estudiante = $stmt_denominaciones->get_result();
}

$sql_promociones = "SELECT id, nombre FROM promociones ORDER BY nombre";
$result_promociones = $conn->query($sql_promociones);
$promociones = $result_promociones->fetch_all(MYSQLI_ASSOC);
?>
<style>
    .status-badge {
        padding: 0.35em 0.65em;
        font-size: 0.75em;
        font-weight: 700;
        border-radius: 0.25rem;
    }
    .badge-activo {
        background-color: #198754;
        color: white;
    }
    .badge-graduado {
        background-color: #0d6efd;
        color: white;
    }
    .badge-inactivo {
        background-color: #6c757d;
        color: white;
    }
    .progress {
        height: 1.5rem;
        margin-bottom: 1rem;
    }
</style>

<div class="mb-3">
    <a href="index.php" class="btn btn-secondary">Volver al Panel</a>
</div>

<div class="card">
    <div class="card-header">
        <ul class="nav nav-tabs card-header-tabs" id="myTab" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="registro-tab" data-bs-toggle="tab" data-bs-target="#registro" type="button" role="tab">Registrar Estudiante</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="lista-tab" data-bs-toggle="tab" data-bs-target="#lista" type="button" role="tab">Lista de Estudiantes</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="notas-tab" data-bs-toggle="tab" data-bs-target="#notas" type="button" role="tab">Cargar Notas</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="graduacion-tab" data-bs-toggle="tab" data-bs-target="#graduacion" type="button" role="tab">Graduación</button>
            </li>
        </ul>
    </div>
    <div class="card-body">
        <div class="tab-content" id="myTabContent">
            <!-- Pestaña de Registro -->
            <div class="tab-pane fade show active" id="registro" role="tabpanel">
                <h3>Registrar Nuevo Estudiante</h3>
                <form method="post" action="">
                    <!-- ... Formulario de registro ... -->
                </form>
            </div>
            
            <!-- Pestaña de Lista de Estudiantes -->
            <div class="tab-pane fade" id="lista" role="tabpanel">
                <h3>Estudiantes Asignados</h3>
                <div class="table-responsive">
                    <!-- ... Tabla de estudiantes ... -->
                </div>
            </div>
            
            <!-- Pestaña de Carga de Notas -->
            <div class="tab-pane fade" id="notas" role="tabpanel">
                <!-- ... Contenido de carga de notas ... -->
            </div>
            
            <!-- Pestaña de Graduación -->
            <div class="tab-pane fade" id="graduacion" role="tabpanel">
                <!-- ... Contenido de graduación ... -->
            </div>
        </div>
    </div>
</div>

<?php
$custom_scripts = "<script>
    // Activar la pestaña correspondiente si hay hash en la URL
    document.addEventListener('DOMContentLoaded', function() {
        if (window.location.hash) {
            const tabTrigger = new bootstrap.Tab(document.querySelector(`.nav-tabs .nav-link[data-bs-target='${window.location.hash}']`));
            if(tabTrigger) {
                tabTrigger.show();
            }
        }

        // Manejar clics en pestañas para actualizar la URL
        const tabLinks = document.querySelectorAll('.nav-tabs .nav-link');
        tabLinks.forEach(link => {
            link.addEventListener('click', function(event) {
                history.pushState(null, null, event.target.dataset.bsTarget);
            });
        });
    });
</script>";

include '../includes/footer.php';
$conn->close();
?>
