<?php
session_start();

// Configurar encoding UTF-8
header('Content-Type: text/html; charset=utf-8');
mb_internal_encoding('UTF-8');

if (!isset($_SESSION['username']) || $_SESSION['rol'] != 'administrador') {
    header("Location: ../login.php");
    exit();
}

include '../includes/db.php';

// Configurar conexión para usar UTF-8
$conn->set_charset("utf8mb4");
$conn->query("SET NAMES 'utf8mb4'");
$conn->query("SET CHARACTER SET utf8mb4");
$conn->query("SET COLLATION_CONNECTION = 'utf8mb4_unicode_ci'");

if (!isset($_SESSION['username']) || $_SESSION['rol'] != 'administrador') {
    header("Location: ../login.php");
    exit();
}

// Obtener parámetros de filtrado
$estudiante_id = isset($_GET['estudiante_id']) ? intval($_GET['estudiante_id']) : 0;
$postgrado_id = isset($_GET['postgrado_id']) ? intval($_GET['postgrado_id']) : 0;
$fecha_desde = isset($_GET['fecha_desde']) ? $_GET['fecha_desde'] : '';
$fecha_hasta = isset($_GET['fecha_hasta']) ? $_GET['fecha_hasta'] : '';

// Construir la consulta SQL con filtros
$sql = "SELECT c.*, e.nombres, e.apellidos, e.cedula, 
        pa.nombre as postgrado_anterior_nombre, 
        pn.nombre as postgrado_nuevo_nombre, 
        u.username as administrador
        FROM cambios_postgrado c
        JOIN estudiantes e ON c.estudiante_id = e.id
        JOIN postgrados pa ON c.postgrado_anterior = pa.id
        JOIN postgrados pn ON c.postgrado_nuevo = pn.id
        JOIN usuarios u ON c.administrador_id = u.id
        WHERE 1=1";

$params = [];
$types = '';

if ($estudiante_id > 0) {
    $sql .= " AND c.estudiante_id = ?";
    $params[] = $estudiante_id;
    $types .= 'i';
}

if ($postgrado_id > 0) {
    $sql .= " AND (c.postgrado_anterior = ? OR c.postgrado_nuevo = ?)";
    $params[] = $postgrado_id;
    $params[] = $postgrado_id;
    $types .= 'ii';
}

if (!empty($fecha_desde)) {
    $sql .= " AND c.fecha >= ?";
    $params[] = $fecha_desde;
    $types .= 's';
}

if (!empty($fecha_hasta)) {
    $sql .= " AND c.fecha <= ?";
    $params[] = $fecha_hasta . ' 23:59:59';
    $types .= 's';
}

$sql .= " ORDER BY c.fecha DESC";

// Preparar y ejecutar la consulta
$stmt = $conn->prepare($sql);

if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}

$stmt->execute();
$result = $stmt->get_result();

// Obtener listas para filtros
$sql_estudiantes = "SELECT id, nombres, apellidos, cedula FROM estudiantes ORDER BY apellidos, nombres";
$result_estudiantes = $conn->query($sql_estudiantes);

$sql_postgrados = "SELECT id, nombre FROM postgrados ORDER BY nombre";
$result_postgrados = $conn->query($sql_postgrados);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Historial de Cambios de Postgrado</title>
    <link rel="stylesheet" href="../css/styles.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }
        h1 {
            color: #333;
            margin-bottom: 20px;
        }
        .filtros {
            background-color: #f5f5f5;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .filtro-group {
            margin-bottom: 10px;
        }
        label {
            display: inline-block;
            width: 150px;
            font-weight: bold;
        }
        select, input[type="date"], input[type="text"] {
            padding: 6px;
            width: 200px;
        }
        button {
            padding: 8px 15px;
            background-color: #4CAF50;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        button:hover {
            background-color: #45a049;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
            position: sticky;
            top: 0;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        tr:hover {
            background-color: #f1f1f1;
        }
        .acciones {
            white-space: nowrap;
        }
        .btn-limpiar {
            background-color: #f44336;
        }
        .btn-limpiar:hover {
            background-color: #d32f2f;
        }
    </style>
</head>
<body>
    <h1>Historial de Cambios de Postgrado</h1>
    <a href="index.php">← Volver al Menú</a>

    <!-- Formulario de filtros -->
    <div class="filtros">
        <form method="get">
            <div class="filtro-group">
                <label for="estudiante_id">Estudiante:</label>
                <select name="estudiante_id" id="estudiante_id">
                    <option value="">Todos los estudiantes</option>
                    <?php while ($row = $result_estudiantes->fetch_assoc()): ?>
                        <option value="<?= $row['id'] ?>" <?= $estudiante_id == $row['id'] ? 'selected' : '' ?>>
                            <?= htmlspecialchars($row['apellidos'] . ', ' . $row['nombres'] . ' (' . $row['cedula'] . ')') ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>

            <div class="filtro-group">
                <label for="postgrado_id">Postgrado:</label>
                <select name="postgrado_id" id="postgrado_id">
                    <option value="">Todos los postgrados</option>
                    <?php while ($row = $result_postgrados->fetch_assoc()): ?>
                        <option value="<?= $row['id'] ?>" <?= $postgrado_id == $row['id'] ? 'selected' : '' ?>>
                            <?= htmlspecialchars($row['nombre']) ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>

            <div class="filtro-group">
                <label for="fecha_desde">Fecha desde:</label>
                <input type="date" name="fecha_desde" id="fecha_desde" value="<?= htmlspecialchars($fecha_desde) ?>">
            </div>

            <div class="filtro-group">
                <label for="fecha_hasta">Fecha hasta:</label>
                <input type="date" name="fecha_hasta" id="fecha_hasta" value="<?= htmlspecialchars($fecha_hasta) ?>">
            </div>

            <div class="filtro-group">
                <button type="submit">Filtrar</button>
                <a href="historial_postgrados.php"><button type="button" class="btn-limpiar">Limpiar</button></a>
            </div>
        </form>
    </div>

    <!-- Tabla de resultados -->
    <table>
        <thead>
            <tr>
                <th>Fecha y Hora</th>
                <th>Estudiante</th>
                <th>Cédula</th>
                <th>Postgrado Anterior</th>
                <th>Postgrado Nuevo</th>
                <th>Motivo</th>
                <th>Administrador</th>
            </tr>
        </thead>
        <tbody>
            <?php if ($result->num_rows > 0): ?>
                <?php while ($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars($row['fecha']) ?></td>
                        <td><?= htmlspecialchars($row['apellidos'] . ', ' . $row['nombres']) ?></td>
                        <td><?= htmlspecialchars($row['cedula']) ?></td>
                        <td><?= htmlspecialchars($row['postgrado_anterior_nombre']) ?></td>
                        <td><?= htmlspecialchars($row['postgrado_nuevo_nombre']) ?></td>
                        <td><?= htmlspecialchars($row['motivo']) ?></td>
                        <td><?= htmlspecialchars($row['administrador']) ?></td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr>
                    <td colspan="7" style="text-align: center;">No se encontraron registros con los filtros aplicados</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <script>
        // Establecer fecha máxima para el filtro de fecha hasta
        document.addEventListener('DOMContentLoaded', function() {
            const fechaHasta = document.getElementById('fecha_hasta');
            const fechaDesde = document.getElementById('fecha_desde');
            
            // Establecer fecha máxima como hoy
            const hoy = new Date().toISOString().split('T')[0];
            fechaHasta.max = hoy;
            fechaDesde.max = hoy;
            
            // Validar que fecha desde no sea mayor que fecha hasta
            fechaDesde.addEventListener('change', function() {
                fechaHasta.min = this.value;
            });
            
            fechaHasta.addEventListener('change', function() {
                fechaDesde.max = this.value;
            });
        });
    </script>
</body>
</html>