<?php
session_start();

// Configurar encoding UTF-8
header('Content-Type: text/html; charset=utf-8');
mb_internal_encoding('UTF-8');

if (!isset($_SESSION['username']) || $_SESSION['rol'] != 'administrador') {
    header("Location: ../login.php");
    exit();
}

include '../includes/db.php';

// Configurar conexión para usar UTF-8
$conn->set_charset("utf8mb4");
$conn->query("SET NAMES 'utf8mb4'");
$conn->query("SET CHARACTER SET utf8mb4");
$conn->query("SET COLLATION_CONNECTION = 'utf8mb4_unicode_ci'");

// Verificar si se proporcionó un ID válido
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    $_SESSION['error'] = "ID de inscripción no válido";
    header("Location: gestion_inscripciones.php");
    exit();
}

$inscripcion_id = intval($_GET['id']);

// Obtener información detallada de la inscripción específica
$sql_info = "SELECT ep.id, e.id as estudiante_id, e.nombres, e.apellidos, 
            p.id as postgrado_id, p.nombre as postgrado, ep.fecha_inscripcion, ep.anio_inicio,
            ep.estado
            FROM estudiante_postgrado ep
            JOIN estudiantes e ON ep.estudiante_id = e.id
            JOIN postgrados p ON ep.postgrado_id = p.id
            WHERE ep.id = ?";
$stmt_info = $conn->prepare($sql_info);
$stmt_info->bind_param("i", $inscripcion_id);
$stmt_info->execute();
$result_info = $stmt_info->get_result();

if ($result_info->num_rows == 0) {
    $_SESSION['error'] = "Inscripción no encontrada";
    header("Location: gestion_inscripciones.php");
    exit();
}

$inscripcion = $result_info->fetch_assoc();

// Contar cuántas asignaturas se eliminarán específicamente para esta inscripción
$sql_count_asignaturas = "SELECT COUNT(*) as total_asignaturas 
                         FROM inscripciones i
                         JOIN denominaciones d ON i.denominacion_id = d.id
                         WHERE i.estudiante_id = ? AND d.postgrado_id = ?";
$stmt_count = $conn->prepare($sql_count_asignaturas);
$stmt_count->bind_param("ii", $inscripcion['estudiante_id'], $inscripcion['postgrado_id']);
$stmt_count->execute();
$result_count = $stmt_count->get_result();
$count_data = $result_count->fetch_assoc();
$total_asignaturas = $count_data['total_asignaturas'];

// Procesar el formulario de eliminación
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['confirmar'])) {
        $conn->begin_transaction();
        
        try {
            // 1. Eliminar SOLO las inscripciones a denominaciones relacionadas con ESTA inscripción específica
            $sql_delete_inscripciones = "DELETE i FROM inscripciones i
                                       JOIN denominaciones d ON i.denominacion_id = d.id
                                       WHERE i.estudiante_id = ? 
                                       AND d.postgrado_id = ?";
            $stmt_delete_insc = $conn->prepare($sql_delete_inscripciones);
            if ($stmt_delete_insc === false) {
                throw new Exception("Error preparando consulta de inscripciones: " . $conn->error);
            }
            $stmt_delete_insc->bind_param("ii", $inscripcion['estudiante_id'], $inscripcion['postgrado_id']);
            $stmt_delete_insc->execute();
            $asignaturas_eliminadas = $stmt_delete_insc->affected_rows;
            
            // 2. Eliminar SOLO la inscripción principal específica
            $sql_delete_principal = "DELETE FROM estudiante_postgrado WHERE id = ?";
            $stmt_delete_principal = $conn->prepare($sql_delete_principal);
            if ($stmt_delete_principal === false) {
                throw new Exception("Error preparando consulta principal: " . $conn->error);
            }
            $stmt_delete_principal->bind_param("i", $inscripcion_id);
            $stmt_delete_principal->execute();
            
            $conn->commit();
            
            $_SESSION['success'] = "Inscripción eliminada exitosamente. " . 
                                 "Se eliminó 1 inscripción principal y $asignaturas_eliminadas asignatura(s) relacionadas.";
            header("Location: gestion_inscripciones.php");
            exit();
        } catch (Exception $e) {
            $conn->rollback();
            $_SESSION['error'] = "Error al eliminar la inscripción: " . $e->getMessage();
            header("Location: gestion_inscripciones.php");
            exit();
        }
    } elseif (isset($_POST['cancelar'])) {
        header("Location: gestion_inscripciones.php");
        exit();
    }
}

include '../includes/header.php';
?>

<div class="container mt-4">
    <div class="mb-4">
        <a href="gestion_inscripciones.php" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Volver a Gestión de Inscripciones
        </a>
    </div>

    <div class="card border-danger">
        <div class="card-header bg-danger text-white">
            <h3 class="mb-0"><i class="bi bi-exclamation-triangle"></i> Confirmar Eliminación Específica</h3>
        </div>
        <div class="card-body">
            <div class="alert alert-danger">
                <h4 class="alert-heading">¡Advertencia!</h4>
                <p>Estás a punto de eliminar <strong>SOLAMENTE</strong> la siguiente inscripción específica:</p>
                <hr>
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>Estudiante:</strong><br>
                        <span class="fw-bold"><?= htmlspecialchars($inscripcion['apellidos'] . ', ' . $inscripcion['nombres']) ?></span></p>
                        <p><strong>ID Estudiante:</strong> <?= $inscripcion['estudiante_id'] ?></p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>Postgrado:</strong><br>
                        <span class="fw-bold"><?= htmlspecialchars($inscripcion['postgrado']) ?></span></p>
                        <p><strong>Año de Inicio:</strong> <?= $inscripcion['anio_inicio'] ?></p>
                    </div>
                </div>
                <div class="row mt-2">
                    <div class="col-md-12">
                        <p><strong>Fecha de inscripción:</strong> <?= date('d/m/Y', strtotime($inscripcion['fecha_inscripcion'])) ?></p>
                        <p><strong>Estado actual:</strong> <span class="badge bg-<?= $inscripcion['estado'] == 'activo' ? 'success' : 'warning' ?>"><?= ucfirst($inscripcion['estado']) ?></span></p>
                        <p><strong>Asignaturas a eliminar:</strong> <?= $total_asignaturas ?> asignatura(s)</p>
                    </div>
                </div>
            </div>
            
            <div class="alert alert-warning">
                <h5 class="alert-heading">¿Qué se eliminará EXACTAMENTE?</h5>
                <ul>
                    <li><strong>SOLO</strong> esta inscripción específica (ID: <?= $inscripcion_id ?>)</li>
                    <li><strong>SOLO</strong> las <?= $total_asignaturas ?> asignatura(s) asociadas a ESTA inscripción</li>
                </ul>
                <p class="mb-0"><strong>✅ NO se eliminarán:</strong> Otras inscripciones del estudiante, otros registros del estudiante, u otras inscripciones al mismo postgrado.</p>
                <p class="mb-0 mt-2"><strong>⚠️ Esta acción no se puede deshacer.</strong></p>
            </div>
            
            <form method="post">
                <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                    <button type="submit" name="cancelar" class="btn btn-secondary me-md-2">
                        <i class="bi bi-x-circle"></i> Cancelar
                    </button>
                    <button type="submit" name="confirmar" class="btn btn-danger">
                        <i class="bi bi-trash"></i> Eliminar SOLO esta inscripción
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php
include '../includes/footer.php';
$conn->close();
?>