<?php
session_start();

// Configurar encoding UTF-8
header('Content-Type: text/html; charset=utf-8');
mb_internal_encoding('UTF-8');

if (!isset($_SESSION['username']) || $_SESSION['rol'] != 'administrador') {
    header("Location: ../login.php");
    exit();
}

include '../includes/db.php';

// Configurar conexión para usar UTF-8
$conn->set_charset("utf8mb4");
$conn->query("SET NAMES 'utf8mb4'");
$conn->query("SET CHARACTER SET utf8mb4");
$conn->query("SET COLLATION_CONNECTION = 'utf8mb4_unicode_ci'");

// Obtener ID de la denominación a editar
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($id <= 0) {
    header("Location: gestion_denominaciones.php");
    exit();
}

// Obtener datos de la denominación
$sql = "SELECT d.*, p.nombre AS postgrado_nombre, pl.nombre AS plan_nombre 
        FROM denominaciones d
        JOIN postgrados p ON d.postgrado_id = p.id
        JOIN planes pl ON d.plan_id = pl.id
        WHERE d.id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$denominacion = $result->fetch_assoc();

if (!$denominacion) {
    header("Location: gestion_denominaciones.php");
    exit();
}

// Procesar actualización
if (isset($_POST['actualizar_denominacion'])) {
    $codigo = trim($_POST['codigo']);
    $nombre = trim($_POST['nombre']);
    $credito = intval($_POST['credito']);
    $periodo = intval($_POST['periodo']);
    $postgrado_id = intval($_POST['postgrado_id']);
    $plan_id = intval($_POST['plan_id']);
    $tipo = $_POST['tipo'];

    // Validar si el código ya existe (excluyendo el actual)
    $stmt = $conn->prepare("SELECT id FROM denominaciones WHERE codigo = ? AND id != ?");
    $stmt->bind_param("si", $codigo, $id);
    $stmt->execute();
    $stmt->store_result();
    
    if ($stmt->num_rows > 0) {
        $_SESSION['error'] = "El código de la denominación ya existe";
    } else {
        // Validar si el nombre ya existe en el mismo postgrado (excluyendo el actual)
        $stmt = $conn->prepare("SELECT id FROM denominaciones WHERE nombre = ? AND postgrado_id = ? AND id != ?");
        $stmt->bind_param("sii", $nombre, $postgrado_id, $id);
        $stmt->execute();
        $stmt->store_result();
        
        if ($stmt->num_rows > 0) {
            $_SESSION['error'] = "Ya existe una denominación con el mismo nombre en este postgrado";
        } else {
            // Actualizar la denominación
            $stmt = $conn->prepare("UPDATE denominaciones SET codigo = ?, nombre = ?, credito = ?, periodo = ?, postgrado_id = ?, plan_id = ?, tipo = ? WHERE id = ?");
            $stmt->bind_param("ssiiissi", $codigo, $nombre, $credito, $periodo, $postgrado_id, $plan_id, $tipo, $id);
            
            if ($stmt->execute()) {
                $_SESSION['success'] = "Denominación actualizada correctamente";
                header("Location: gestion_denominaciones.php");
                exit();
            } else {
                $_SESSION['error'] = "Error al actualizar la denominación: " . $conn->error;
            }
        }
    }
    $stmt->close();
}

$page_title = "Editar Denominación";
include '../includes/header.php';
?>

<div class="container">
    <!-- Botones de navegación -->
    <div class="d-flex justify-content-between mb-4">
        <a href="index.php" class="btn btn-secondary">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-left" viewBox="0 0 16 16">
                <path fill-rule="evenodd" d="M15 8a.5.5 0 0 0-.5-.5H2.707l3.147-3.146a.5.5 0 1 0-.708-.708l-4 4a.5.5 0 0 0 0 .708l4 4a.5.5 0 0 0 .708-.708L2.707 8.5H14.5A.5.5 0 0 0 15 8z"/>
            </svg>
            Volver al Panel
        </a>
        <a href="gestion_denominaciones.php" class="btn btn-outline-secondary">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-list-ul" viewBox="0 0 16 16">
                <path fill-rule="evenodd" d="M5 11.5a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5zm0-4a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5zm0-4a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5zm-3 1a1 1 0 1 0 0-2 1 1 0 0 0 0 2zm0 4a1 1 0 1 0 0-2 1 1 0 0 0 0 2zm0 4a1 1 0 1 0 0-2 1 1 0 0 0 0 2z"/>
            </svg>
            Volver a Denominaciones
        </a>
    </div>

    <?php if (isset($_SESSION['error'])): ?>
        <div class="alert alert-danger"><?= $_SESSION['error'] ?></div>
        <?php unset($_SESSION['error']); ?>
    <?php endif; ?>

    <div class="card">
        <div class="card-header bg-primary text-white">
            <h3 class="mb-0">Editar Denominación</h3>
        </div>
        <div class="card-body">
            <form action="editar_denominacion.php?id=<?= $id ?>" method="post">
                <div class="row g-3">
                    <div class="col-md-6">
                        <label for="codigo" class="form-label">Código:</label>
                        <input type="text" class="form-control" id="codigo" name="codigo" 
                               value="<?= htmlspecialchars($denominacion['codigo']) ?>" required>
                    </div>
                    
                    <div class="col-md-6">
                        <label for="nombre" class="form-label">Nombre:</label>
                        <input type="text" class="form-control" id="nombre" name="nombre" 
                               value="<?= htmlspecialchars($denominacion['nombre']) ?>" required>
                    </div>
                    
                    <div class="col-md-3">
                        <label for="credito" class="form-label">Créditos:</label>
                        <input type="number" class="form-control" id="credito" name="credito" 
                               value="<?= htmlspecialchars($denominacion['credito']) ?>" required>
                    </div>
                    
                    <div class="col-md-3">
                        <label for="periodo" class="form-label">Periodo:</label>
                        <input type="number" class="form-control" id="periodo" name="periodo" 
                               value="<?= htmlspecialchars($denominacion['periodo']) ?>" required>
                    </div>
                    
                    <div class="col-md-6">
                        <label for="postgrado_id" class="form-label">Postgrado:</label>
                        <select class="form-select" id="postgrado_id" name="postgrado_id" required>
                            <?php
                            $sql = "SELECT id, nombre FROM postgrados";
                            $result = $conn->query($sql);
                            while ($row = $result->fetch_assoc()) {
                                $selected = ($row['id'] == $denominacion['postgrado_id']) ? 'selected' : '';
                                echo "<option value='{$row['id']}' $selected>{$row['nombre']}</option>";
                            }
                            ?>
                        </select>
                    </div>
                    
                    <div class="col-md-6">
                        <label for="plan_id" class="form-label">Plan:</label>
                        <select class="form-select" id="plan_id" name="plan_id" required>
                            <?php
                            $sql = "SELECT id, nombre FROM planes";
                            $result = $conn->query($sql);
                            while ($row = $result->fetch_assoc()) {
                                $selected = ($row['id'] == $denominacion['plan_id']) ? 'selected' : '';
                                echo "<option value='{$row['id']}' $selected>{$row['nombre']}</option>";
                            }
                            ?>
                        </select>
                    </div>
                    
                    <div class="col-md-6">
                        <label for="tipo" class="form-label">Tipo:</label>
                        <select class="form-select" id="tipo" name="tipo" required>
                            <option value="puntaje" <?= $denominacion['tipo'] == 'puntaje' ? 'selected' : '' ?>>Puntaje</option>
                            <option value="aprobado_reprobado" <?= $denominacion['tipo'] == 'aprobado_reprobado' ? 'selected' : '' ?>>Aprobado/Reprobado</option>
                        </select>
                    </div>
                    
                    <div class="col-12">
                        <button type="submit" name="actualizar_denominacion" class="btn btn-primary">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-save" viewBox="0 0 16 16">
                                <path d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1H9.5a1 1 0 0 0-1 1v7.293l2.646-2.647a.5.5 0 0 1 .708.708l-3.5 3.5a.5.5 0 0 1-.708 0l-3.5-3.5a.5.5 0 1 1 .708-.708L7.5 9.293V2a2 2 0 0 1 2-2H14a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h2.5a.5.5 0 0 1 0 1H2z"/>
                            </svg>
                            Actualizar Denominación
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<?php
include '../includes/footer.php';
$conn->close();
?>