<?php
session_start();

// Configurar encoding UTF-8
header('Content-Type: text/html; charset=utf-8');
mb_internal_encoding('UTF-8');

if (!isset($_SESSION['username']) || $_SESSION['rol'] != 'administrador') {
    header("Location: ../login.php");
    exit();
}

include '../includes/db.php';

// Configurar conexión para usar UTF-8
$conn->set_charset("utf8mb4");
$conn->query("SET NAMES 'utf8mb4'");
$conn->query("SET CHARACTER SET utf8mb4");
$conn->query("SET COLLATION_CONNECTION = 'utf8mb4_unicode_ci'");

if (!isset($_SESSION['username']) || $_SESSION['rol'] != 'administrador') {
    header("Location: ../login.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $estudiante_id = intval($_POST['estudiante_id']);
    $nuevo_postgrado_id = intval($_POST['nuevo_postgrado_id']);
    $motivo = $_POST['motivo'];
    $administrador_id = $_SESSION['user_id']; // Asumiendo que el ID del admin está en la sesión
    
    // Verificar que el nuevo postgrado sea diferente
    $sql = "SELECT postgrado_id FROM estudiante_postgrado 
            WHERE estudiante_id = ? AND estado = 'activo'";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $estudiante_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows == 0) {
        echo "<p>El estudiante no está inscrito en ningún postgrado activo.</p>";
        return;
    }
    
    $postgrado_actual = $result->fetch_assoc();
    
    if ($postgrado_actual['postgrado_id'] == $nuevo_postgrado_id) {
        echo "<p>El estudiante ya está en este postgrado.</p>";
        return;
    }
    
    // Verificar que no esté ya graduado del nuevo postgrado
    $sql = "SELECT 1 FROM estudiante_postgrado 
            WHERE estudiante_id = ? AND postgrado_id = ? AND estado = 'graduado'";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ii", $estudiante_id, $nuevo_postgrado_id);
    $stmt->execute();
    
    if ($stmt->get_result()->num_rows > 0) {
        echo "<p>El estudiante ya se graduó de este postgrado.</p>";
        return;
    }
    
    // Actualizar el postgrado actual a estado 'cambio'
    $sql = "UPDATE estudiante_postgrado SET estado = 'cambio' 
            WHERE estudiante_id = ? AND postgrado_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ii", $estudiante_id, $postgrado_actual['postgrado_id']);
    $stmt->execute();
    
    // Verificar si ya existe una relación con el nuevo postgrado (para reactivarla)
    $sql = "SELECT 1 FROM estudiante_postgrado 
            WHERE estudiante_id = ? AND postgrado_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ii", $estudiante_id, $nuevo_postgrado_id);
    $stmt->execute();
    
    if ($stmt->get_result()->num_rows > 0) {
        // Reactivar la relación existente
        $sql = "UPDATE estudiante_postgrado SET estado = 'activo', fecha_inscripcion = CURDATE() 
                WHERE estudiante_id = ? AND postgrado_id = ?";
    } else {
        // Crear nueva relación
        $sql = "INSERT INTO estudiante_postgrado (estudiante_id, postgrado_id, fecha_inscripcion, estado)
                VALUES (?, ?, CURDATE(), 'activo')";
    }
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ii", $estudiante_id, $nuevo_postgrado_id);
    $stmt->execute();
    
    // Registrar el cambio en el historial
    $sql = "INSERT INTO cambios_postgrado (estudiante_id, postgrado_anterior, postgrado_nuevo, motivo, fecha, administrador_id)
            VALUES (?, ?, ?, ?, NOW(), ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("iiisi", $estudiante_id, $postgrado_actual['postgrado_id'], $nuevo_postgrado_id, $motivo, $administrador_id);
    $stmt->execute();
    
    echo "<p>Cambio de postgrado realizado exitosamente.</p>";
}

// Obtener lista de postgrados
$sql_postgrados = "SELECT id, nombre FROM postgrados";
$result_postgrados = $conn->query($sql_postgrados);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Cambio de Postgrado</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        form { max-width: 500px; margin: 0 auto; }
        label { display: block; margin: 10px 0; }
        select, textarea { width: 100%; padding: 8px; margin-bottom: 10px; }
        button { padding: 10px 15px; background-color: #4CAF50; color: white; border: none; cursor: pointer; }
    </style>
</head>
<body>
    <h1>Cambio de Postgrado</h1>
    <form method="post">
        <label for="estudiante_id">Estudiante:</label>
        <select name="estudiante_id" id="estudiante_id" required>
            <option value="">Seleccione un estudiante</option>
            <?php
            // CONSULTA ACTUALIZADA - Incluir todos los campos de documentos
            $sql = "SELECT id, nombres, apellidos, cedula, tipo_documento, cedula_venezolana, cedula_extranjera, pasaporte FROM estudiantes";
            $result = $conn->query($sql);
            while ($row = $result->fetch_assoc()) {
                // Determinar qué documento mostrar
                $documento_mostrar = '';
                switch($row['tipo_documento']) {
                    case 'V':
                        $documento_mostrar = 'V-' . $row['cedula_venezolana'];
                        break;
                    case 'E':
                        $documento_mostrar = 'E-' . $row['cedula_extranjera'];
                        break;
                    case 'P':
                        $documento_mostrar = 'P-' . $row['pasaporte'];
                        break;
                    default:
                        $documento_mostrar = $row['cedula'];
                }
                echo "<option value='{$row['id']}'>{$row['nombres']} {$row['apellidos']} ({$documento_mostrar})</option>";
            }
            ?>
        </select>
        
        <label for="nuevo_postgrado_id">Nuevo Postgrado:</label>
        <select name="nuevo_postgrado_id" id="nuevo_postgrado_id" required>
            <option value="">Seleccione un postgrado</option>
            <?php
            while ($row = $result_postgrados->fetch_assoc()) {
                echo "<option value='{$row['id']}'>{$row['nombre']}</option>";
            }
            ?>
        </select>
        
        <label for="motivo">Motivo del cambio:</label>
        <textarea name="motivo" id="motivo" required></textarea>
        
        <button type="submit">Realizar Cambio</button>
    </form>
</body>
</html>