<?php
session_start();
include '../includes/db.php';

// Verificar sesión
if (!isset($_SESSION['username'])) {
    header("Location: ../login.php");
    exit();
}

if (!isset($_SESSION['rol']) || ($_SESSION['rol'] != 'administrador' && $_SESSION['rol'] != 'coordinador2')) {
    header("Location: ../login.php");
    exit();
}

// Configurar encoding
$conn->set_charset("utf8");
header('Content-Type: text/html; charset=utf-8');

$es_administrador = ($_SESSION['rol'] == 'administrador');
$coordinador_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : 0;
$url_panel = $es_administrador ? '../admin/index.php' : '../coordinador2/index.php';

// Verificar si se viene desde index.php con estudiante_id
$estudiante_id_from_index = isset($_GET['estudiante_id']) ? intval($_GET['estudiante_id']) : 0;

// Procesar retiro de estudiante
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['retirar_estudiante'])) {
    $estudiante_id = intval($_POST['estudiante_id']);
    $postgrado_id = intval($_POST['postgrado_id']);
    $motivo = trim($_POST['motivo']);
    
    if ($estudiante_id <= 0 || $postgrado_id <= 0 || empty($motivo)) {
        $_SESSION['error'] = "Complete todos los campos.";
        header("Location: retiro_estudiantes.php");
        exit();
    }

    // Verificar que el estudiante existe y está activo
    $sql_verificar = "SELECT ep.estudiante_id, e.nombres, e.apellidos, p.nombre as postgrado_nombre
                     FROM estudiante_postgrado ep
                     JOIN estudiantes e ON ep.estudiante_id = e.id
                     JOIN postgrados p ON ep.postgrado_id = p.id
                     WHERE ep.estudiante_id = $estudiante_id 
                     AND ep.postgrado_id = $postgrado_id
                     AND ep.estado = 'activo'";
    
    $result_verificar = $conn->query($sql_verificar);
    
    if ($result_verificar->num_rows == 0) {
        $_SESSION['error'] = "El estudiante no existe o ya no está activo.";
        header("Location: retiro_estudiantes.php");
        exit();
    }

    // Actualizar estado
    $sql_retirar = "UPDATE estudiante_postgrado 
                   SET estado = 'retirado' 
                   WHERE estudiante_id = $estudiante_id 
                   AND postgrado_id = $postgrado_id";
    
    if ($conn->query($sql_retirar)) {
        // Registrar retiro
        $usuario_id = $_SESSION['user_id'];
        $motivo_escaped = $conn->real_escape_string($motivo);
        $sql_registrar = "INSERT INTO retiros_estudiantes 
                         (estudiante_id, postgrado_id, motivo, fecha_retiro, usuario_id) 
                         VALUES ($estudiante_id, $postgrado_id, '$motivo_escaped', NOW(), $usuario_id)";
        
        $conn->query($sql_registrar);
        $_SESSION['success'] = "Estudiante retirado correctamente";
    } else {
        $_SESSION['error'] = "Error al retirar estudiante: " . $conn->error;
    }
    
    header("Location: retiro_estudiantes.php");
    exit();
}

// Procesar reactivación
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['reactivar_estudiante'])) {
    $estudiante_id = intval($_POST['estudiante_id']);
    $postgrado_id = intval($_POST['postgrado_id']);
    $motivo_reactivacion = trim($_POST['motivo_reactivacion']);
    
    if ($estudiante_id <= 0 || $postgrado_id <= 0 || empty($motivo_reactivacion)) {
        $_SESSION['error'] = "Complete todos los campos.";
        header("Location: retiro_estudiantes.php");
        exit();
    }
    
    // Verificar que el estudiante existe y está retirado
    $sql_verificar = "SELECT ep.estudiante_id, e.nombres, e.apellidos, p.nombre as postgrado_nombre
                     FROM estudiante_postgrado ep
                     JOIN estudiantes e ON ep.estudiante_id = e.id
                     JOIN postgrados p ON ep.postgrado_id = p.id
                     WHERE ep.estudiante_id = $estudiante_id 
                     AND ep.postgrado_id = $postgrado_id
                     AND ep.estado = 'retirado'";
    
    $result_verificar = $conn->query($sql_verificar);
    
    if ($result_verificar->num_rows == 0) {
        $_SESSION['error'] = "El estudiante no existe o no está retirado.";
        header("Location: retiro_estudiantes.php");
        exit();
    }
    
    // Reactivar estudiante
    $sql_reactivar = "UPDATE estudiante_postgrado 
                     SET estado = 'activo' 
                     WHERE estudiante_id = $estudiante_id 
                     AND postgrado_id = $postgrado_id";
    
    if ($conn->query($sql_reactivar)) {
        // Actualizar registro de retiro
        $usuario_id = $_SESSION['user_id'];
        $motivo_escaped = $conn->real_escape_string($motivo_reactivacion);
        $sql_actualizar = "UPDATE retiros_estudiantes 
                          SET fecha_reactivacion = NOW(), 
                              motivo_reactivacion = '$motivo_escaped',
                              usuario_reactivacion_id = $usuario_id
                          WHERE estudiante_id = $estudiante_id 
                          AND postgrado_id = $postgrado_id
                          AND fecha_reactivacion IS NULL
                          ORDER BY id DESC LIMIT 1";
        
        $conn->query($sql_actualizar);
        $_SESSION['success'] = "Estudiante reactivado correctamente";
    } else {
        $_SESSION['error'] = "Error al reactivar estudiante: " . $conn->error;
    }
    
    header("Location: retiro_estudiantes.php");
    exit();
}

// Obtener parámetros de búsqueda y paginación
$busqueda_activos = isset($_GET['busqueda_activos']) ? trim($conn->real_escape_string($_GET['busqueda_activos'])) : '';
$busqueda_retirados = isset($_GET['busqueda_retirados']) ? trim($conn->real_escape_string($_GET['busqueda_retirados'])) : '';
$pagina = isset($_GET['pagina']) ? max(1, intval($_GET['pagina'])) : 1;
$por_pagina = 10;
$offset = ($pagina - 1) * $por_pagina;

// Obtener estudiantes activos
if ($es_administrador) {
    $sql_activos = "SELECT ep.estudiante_id, e.cedula, e.nombres, e.apellidos, e.correo,
                    ep.postgrado_id, p.nombre as postgrado_nombre,
                    ep.fecha_inscripcion
                    FROM estudiante_postgrado ep
                    JOIN estudiantes e ON ep.estudiante_id = e.id
                    JOIN postgrados p ON ep.postgrado_id = p.id
                    WHERE ep.estado = 'activo'";
} else {
    $sql_activos = "SELECT ep.estudiante_id, e.cedula, e.nombres, e.apellidos, e.correo,
                    ep.postgrado_id, p.nombre as postgrado_nombre,
                    ep.fecha_inscripcion
                    FROM estudiante_postgrado ep
                    JOIN estudiantes e ON ep.estudiante_id = e.id
                    JOIN postgrados p ON ep.postgrado_id = p.id
                    JOIN coordinador_postgrado cp ON ep.postgrado_id = cp.postgrado_id
                    WHERE ep.estado = 'activo' AND cp.coordinador_id = $coordinador_id";
}

// Si viene desde index.php con estudiante_id, filtrar por ese estudiante
if ($estudiante_id_from_index > 0) {
    $sql_activos .= " AND ep.estudiante_id = $estudiante_id_from_index";
}

// Aplicar búsqueda si existe
if (!empty($busqueda_activos)) {
    $sql_activos .= " AND (e.cedula LIKE '%$busqueda_activos%' OR e.nombres LIKE '%$busqueda_activos%' OR e.apellidos LIKE '%$busqueda_activos%' OR e.correo LIKE '%$busqueda_activos%')";
}

// Contar total para paginación
$result_total = $conn->query($sql_activos);
$total_estudiantes = $result_total->num_rows;
$total_paginas = ceil($total_estudiantes / $por_pagina);

// Añadir paginación
$sql_activos .= " ORDER BY e.apellidos, e.nombres LIMIT $por_pagina OFFSET $offset";
$result_activos = $conn->query($sql_activos);

// Obtener estudiantes retirados
if ($es_administrador) {
    $sql_retirados = "SELECT ep.estudiante_id, e.cedula, e.nombres, e.apellidos,
                     ep.postgrado_id, p.nombre as postgrado_nombre,
                     re.fecha_retiro, re.fecha_reactivacion, re.motivo
                     FROM estudiante_postgrado ep
                     JOIN estudiantes e ON ep.estudiante_id = e.id
                     JOIN postgrados p ON ep.postgrado_id = p.id
                     LEFT JOIN retiros_estudiantes re ON ep.estudiante_id = re.estudiante_id AND ep.postgrado_id = re.postgrado_id
                     WHERE ep.estado = 'retirado'";
} else {
    $sql_retirados = "SELECT ep.estudiante_id, e.cedula, e.nombres, e.apellidos,
                     ep.postgrado_id, p.nombre as postgrado_nombre,
                     re.fecha_retiro, re.fecha_reactivacion, re.motivo
                     FROM estudiante_postgrado ep
                     JOIN estudiantes e ON ep.estudiante_id = e.id
                     JOIN postgrados p ON ep.postgrado_id = p.id
                     JOIN coordinador_postgrado cp ON ep.postgrado_id = cp.postgrado_id
                     LEFT JOIN retiros_estudiantes re ON ep.estudiante_id = re.estudiante_id AND ep.postgrado_id = re.postgrado_id
                     WHERE ep.estado = 'retirado' AND cp.coordinador_id = $coordinador_id";
}

// Aplicar búsqueda si existe
if (!empty($busqueda_retirados)) {
    $sql_retirados .= " AND (e.cedula LIKE '%$busqueda_retirados%' OR e.nombres LIKE '%$busqueda_retirados%' OR e.apellidos LIKE '%$busqueda_retirados%' OR e.correo LIKE '%$busqueda_retirados%')";
}

$sql_retirados .= " ORDER BY e.apellidos, e.nombres";
$result_retirados = $conn->query($sql_retirados);

// Si viene desde index.php, obtener información del estudiante específico
$estudiante_especifico = null;
if ($estudiante_id_from_index > 0) {
    $sql_estudiante = "SELECT e.id, e.cedula, e.nombres, e.apellidos, e.correo,
                       p.id as postgrado_id, p.nombre as postgrado_nombre
                       FROM estudiantes e
                       JOIN estudiante_postgrado ep ON e.id = ep.estudiante_id
                       JOIN postgrados p ON ep.postgrado_id = p.id
                       WHERE e.id = $estudiante_id_from_index 
                       AND ep.estado = 'activo'";
    $result_estudiante = $conn->query($sql_estudiante);
    if ($result_estudiante && $result_estudiante->num_rows > 0) {
        $estudiante_especifico = $result_estudiante->fetch_assoc();
    }
}

$page_title = "Gestión de Estudiantes";
include '../includes/header.php';
?>
<style>
    .card-header.bg-danger { background-color: #dc3545 !important; }
    .card-header.bg-success { background-color: #198754 !important; }
    .section-divider { border-top: 2px solid #dee2e6; margin: 30px 0; }
    .highlighted-student { 
        border: 3px solid #ffc107 !important;
        background-color: #fff3cd !important;
    }
</style>
<div class="container mt-4">
    <div class="mb-4">
        <a href="<?= $url_panel ?>" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Volver al Panel
        </a>
    </div>

    <!-- Mensaje especial si viene desde index.php -->
    <?php if ($estudiante_especifico): ?>
    <div class="alert alert-warning alert-dismissible fade show" role="alert">
        <h6><i class="bi bi-exclamation-triangle"></i> Estudiante con Alertas Académicas</h6>
        <p class="mb-0">
            <strong>Estudiante:</strong> <?= htmlspecialchars($estudiante_especifico['nombres'] . ' ' . $estudiante_especifico['apellidos'], ENT_QUOTES, 'UTF-8') ?> |
            <strong>Cédula:</strong> <?= htmlspecialchars($estudiante_especifico['cedula'], ENT_QUOTES, 'UTF-8') ?> |
            <strong>Postgrado:</strong> <?= htmlspecialchars($estudiante_especifico['postgrado_nombre'], ENT_QUOTES, 'UTF-8') ?>
        </p>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    <?php endif; ?>

    <!-- ESTUDIANTES ACTIVOS -->
    <div class="card mb-4">
        <div class="card-header bg-success text-white d-flex justify-content-between align-items-center">
            <h5 class="mb-0"><i class="bi bi-person-check"></i> Estudiantes Activos</h5>
            <form method="get" class="d-flex">
                <input type="text" name="busqueda_activos" class="form-control form-control-sm" 
                       placeholder="Buscar..." value="<?= htmlspecialchars($busqueda_activos, ENT_QUOTES, 'UTF-8') ?>">
                <button type="submit" class="btn btn-light btn-sm ms-2"><i class="bi bi-search"></i></button>
                <?php if (!empty($busqueda_activos) || $estudiante_id_from_index > 0): ?>
                    <a href="retiro_estudiantes.php" class="btn btn-warning btn-sm ms-2"><i class="bi bi-x-circle"></i></a>
                <?php endif; ?>
            </form>
        </div>
        <div class="card-body">
            <?php if ($result_activos && $result_activos->num_rows > 0): ?>
                <p class="text-success">
                    <strong>Mostrando <?= $result_activos->num_rows ?> de <?= $total_estudiantes ?> estudiantes activos</strong>
                    <?php if ($estudiante_id_from_index > 0): ?>
                        <span class="badge bg-warning ms-2">Filtrado por alerta académica</span>
                    <?php endif; ?>
                </p>
                <div class="row">
                    <?php while ($estudiante = $result_activos->fetch_assoc()): ?>
                        <?php
                        $es_estudiante_destacado = ($estudiante_id_from_index > 0 && $estudiante['estudiante_id'] == $estudiante_id_from_index);
                        $card_class = $es_estudiante_destacado ? 'highlighted-student' : '';
                        ?>
                        <div class="col-md-6 col-lg-4 mb-3">
                            <div class="card h-100 <?= $card_class ?>">
                                <div class="card-body">
                                    <?php if ($es_estudiante_destacado): ?>
                                        <div class="badge bg-warning mb-2">Alerta Académica</div>
                                    <?php endif; ?>
                                    <h6 class="card-title"><?= htmlspecialchars($estudiante['apellidos'] . ', ' . $estudiante['nombres'], ENT_QUOTES, 'UTF-8') ?></h6>
                                    <p class="mb-1"><small><strong>Cédula:</strong> <?= htmlspecialchars($estudiante['cedula'], ENT_QUOTES, 'UTF-8') ?></small></p>
                                    <p class="mb-1"><small><strong>Postgrado:</strong> <?= htmlspecialchars($estudiante['postgrado_nombre'], ENT_QUOTES, 'UTF-8') ?></small></p>
                                    <p class="mb-1"><small><strong>Correo:</strong> <?= htmlspecialchars($estudiante['correo'], ENT_QUOTES, 'UTF-8') ?></small></p>
                                    <p class="mb-0"><small><strong>Inscrito:</strong> <?= date('d/m/Y', strtotime($estudiante['fecha_inscripcion'])) ?></small></p>
                                </div>
                                <div class="card-footer bg-transparent p-3">
                                    <form method="post">
                                        <input type="hidden" name="estudiante_id" value="<?= $estudiante['estudiante_id'] ?>">
                                        <input type="hidden" name="postgrado_id" value="<?= $estudiante['postgrado_id'] ?>">
                                        <div class="mb-2">
                                            <label class="form-label small"><strong>Motivo del retiro:</strong></label>
                                            <textarea class="form-control form-control-sm" name="motivo" rows="2" 
                                                      placeholder="Ingrese el motivo del retiro..." required></textarea>
                                        </div>
                                        <button type="submit" name="retirar_estudiante" class="btn btn-danger btn-sm w-100">
                                            <i class="bi bi-person-dash"></i> Retirar Estudiante
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>

                <!-- Paginación -->
                <?php if ($total_paginas > 1 && $estudiante_id_from_index == 0): ?>
                <nav aria-label="Paginación">
                    <ul class="pagination pagination-sm justify-content-center mt-3">
                        <?php if ($pagina > 1): ?>
                            <li class="page-item">
                                <a class="page-link" href="?pagina=<?= $pagina - 1 ?>&busqueda_activos=<?= urlencode($busqueda_activos) ?>">Anterior</a>
                            </li>
                        <?php endif; ?>
                        
                        <?php for ($i = 1; $i <= $total_paginas; $i++): ?>
                            <li class="page-item <?= ($i == $pagina) ? 'active' : '' ?>">
                                <a class="page-link" href="?pagina=<?= $i ?>&busqueda_activos=<?= urlencode($busqueda_activos) ?>"><?= $i ?></a>
                            </li>
                        <?php endfor; ?>
                        
                        <?php if ($pagina < $total_paginas): ?>
                            <li class="page-item">
                                <a class="page-link" href="?pagina=<?= $pagina + 1 ?>&busqueda_activos=<?= urlencode($busqueda_activos) ?>">Siguiente</a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </nav>
                <?php endif; ?>

            <?php else: ?>
                <div class="alert alert-warning mb-0">
                    <i class="bi bi-exclamation-triangle"></i> No se encontraron estudiantes activos.
                    <?php if ($estudiante_id_from_index > 0): ?>
                        <br><small>El estudiante con ID <?= $estudiante_id_from_index ?> puede que ya haya sido retirado o no exista.</small>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <div class="section-divider"></div>

    <!-- ESTUDIANTES RETIRADOS -->
    <div class="card">
        <div class="card-header bg-danger text-white d-flex justify-content-between align-items-center">
            <h5 class="mb-0"><i class="bi bi-person-x"></i> Estudiantes Retirados</h5>
            <form method="get" class="d-flex">
                <input type="text" name="busqueda_retirados" class="form-control form-control-sm" 
                       placeholder="Buscar..." value="<?= htmlspecialchars($busqueda_retirados, ENT_QUOTES, 'UTF-8') ?>">
                <button type="submit" class="btn btn-light btn-sm ms-2"><i class="bi bi-search"></i></button>
                <?php if (!empty($busqueda_retirados)): ?>
                    <a href="retiro_estudiantes.php" class="btn btn-warning btn-sm ms-2"><i class="bi bi-x-circle"></i></a>
                <?php endif; ?>
            </form>
        </div>
        <div class="card-body">
            <?php if ($result_retirados && $result_retirados->num_rows > 0): ?>
                <div class="table-responsive">
                    <table class="table table-sm table-hover">
                        <thead>
                            <tr>
                                <th>Estudiante</th>
                                <th>Cédula</th>
                                <th>Postgrado</th>
                                <th>Fecha Retiro</th>
                                <th>Motivo</th>
                                <th>Estado</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($estudiante = $result_retirados->fetch_assoc()): 
                                $fue_reactivado = !empty($estudiante['fecha_reactivacion']);
                                $estado_texto = $fue_reactivado ? 'Reactivado' : 'Retirado';
                                $estado_clase = $fue_reactivado ? 'text-success' : 'text-danger';
                            ?>
                                <tr>
                                    <td><?= htmlspecialchars($estudiante['apellidos'] . ', ' . $estudiante['nombres'], ENT_QUOTES, 'UTF-8') ?></td>
                                    <td><?= htmlspecialchars($estudiante['cedula'], ENT_QUOTES, 'UTF-8') ?></td>
                                    <td><?= htmlspecialchars($estudiante['postgrado_nombre'], ENT_QUOTES, 'UTF-8') ?></td>
                                    <td><?= isset($estudiante['fecha_retiro']) ? date('d/m/Y', strtotime($estudiante['fecha_retiro'])) : 'N/A' ?></td>
                                    <td>
                                        <small><?= isset($estudiante['motivo']) ? htmlspecialchars($estudiante['motivo'], ENT_QUOTES, 'UTF-8') : 'N/A' ?></small>
                                    </td>
                                    <td class="<?= $estado_clase ?> fw-bold"><?= $estado_texto ?></td>
                                    <td>
                                        <?php if (!$fue_reactivado): ?>
                                            <button type="button" class="btn btn-success btn-sm" 
                                                    data-bs-toggle="modal" 
                                                    data-bs-target="#modalReactivar<?= $estudiante['estudiante_id'] ?>">
                                                <i class="bi bi-person-check"></i> Reactivar
                                            </button>
                                            
                                            <!-- Modal de Reactivación -->
                                            <div class="modal fade" id="modalReactivar<?= $estudiante['estudiante_id'] ?>" tabindex="-1">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header bg-success text-white">
                                                            <h6 class="modal-title">Reactivar Estudiante</h6>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                        </div>
                                                        <form method="post">
                                                            <div class="modal-body">
                                                                <p>¿Está seguro de reactivar a <strong><?= htmlspecialchars($estudiante['nombres'] . ' ' . $estudiante['apellidos'], ENT_QUOTES, 'UTF-8') ?></strong>?</p>
                                                                <div class="mb-3">
                                                                    <label class="form-label"><strong>Motivo de la reactivación:</strong></label>
                                                                    <textarea class="form-control" name="motivo_reactivacion" rows="3" required placeholder="Ingrese el motivo de la reactivación..."></textarea>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <input type="hidden" name="estudiante_id" value="<?= $estudiante['estudiante_id'] ?>">
                                                                <input type="hidden" name="postgrado_id" value="<?= $estudiante['postgrado_id'] ?>">
                                                                <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Cancelar</button>
                                                                <button type="submit" name="reactivar_estudiante" class="btn btn-success btn-sm">Reactivar</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php else: ?>
                                            <span class="text-muted"><small>Reactivado el <?= date('d/m/Y', strtotime($estudiante['fecha_reactivacion'])) ?></small></span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="alert alert-info mb-0">
                    <i class="bi bi-info-circle"></i> No se encontraron estudiantes retirados.
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Validación básica de formularios
    const forms = document.querySelectorAll('form');
    forms.forEach(form => {
        form.addEventListener('submit', function(e) {
            const textarea = this.querySelector('textarea[name="motivo"]');
            const textareaReactivar = this.querySelector('textarea[name="motivo_reactivacion"]');
            
            if (textarea && !textarea.value.trim()) {
                e.preventDefault();
                alert('Complete el motivo del retiro.');
                textarea.focus();
                return;
            }
            
            if (textareaReactivar && !textareaReactivar.value.trim()) {
                e.preventDefault();
                alert('Complete el motivo de la reactivación.');
                textareaReactivar.focus();
                return;
            }
        });
    });

    // Auto-focus en el textarea del estudiante destacado (si existe)
    const highlightedCard = document.querySelector('.highlighted-student');
    if (highlightedCard) {
        const textarea = highlightedCard.querySelector('textarea[name="motivo"]');
        if (textarea) {
            textarea.focus();
        }
    }
});
</script>

<?php
include '../includes/footer.php';
$conn->close();
?>
