<?php
session_start();

// Verificación de sesión y roles
if (empty($_SESSION['username']) || ($_SESSION['rol'] !== 'administrador' && $_SESSION['rol'] !== 'coordinador1' && $_SESSION['rol'] !== 'coordinador2')) {
    header("Location: ../login.php");
    exit();
}

include '../includes/db.php';

// Configurar conexión para usar UTF-8
$conn->set_charset("utf8mb4");

// Obtener datos para vista previa (similar al reporte principal)
$filtros = [
    'postgrado_id' => $_GET['postgrado_id'] ?? '',
    'anio_lectivo' => $_GET['anio_lectivo'] ?? '',
    'cuatrimestre' => $_GET['cuatrimestre'] ?? '',
    'estudiante' => $_GET['estudiante'] ?? ''
];

// Construir consulta (similar a la del reporte principal)
$where_conditions = [];
$params = [];
$types = '';

// ... (código similar para construir la consulta)

$sql = "SELECT 
            e.nombres, e.apellidos, e.cedula, p.nombre as postgrado_nombre,
            d.codigo, d.nombre as asignatura_nombre, d.credito,
            i.nota_definitiva, i.fecha_modificacion, al.nombre as año_lectivo,
            esc.nombre as escolaridad
        FROM inscripciones i
        JOIN estudiantes e ON i.estudiante_id = e.id
        JOIN denominaciones d ON i.denominacion_id = d.id
        JOIN postgrados p ON d.postgrado_id = p.id
        JOIN años_lectivos al ON i.año_lectivo_id = al.id
        JOIN escolaridades esc ON i.escolaridad_id = esc.id
        WHERE " . implode(' AND ', $where_conditions) . "
        ORDER BY e.apellidos, e.nombres, al.nombre, d.codigo
        LIMIT 50"; // Limitamos para vista previa

$stmt = $conn->prepare($sql);
$stmt->bind_param($types, ...$params);
$stmt->execute();
$resultados = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Vista Previa Excel - Reporte de Notas</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; }
        .excel-preview { background-color: white; border: 1px solid #dee2e6; }
        .excel-header { background-color: #337ab7; color: white; }
        .excel-row:nth-child(even) { background-color: #f9f9f9; }
        .excel-row:hover { background-color: #e9ecef; }
    </style>
</head>
<body>
    <div class="container-fluid mt-3">
        <div class="card">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0">
                    <i class="bi bi-file-excel"></i> Vista Previa - Reporte Excel
                    <small class="float-end">Mostrando primeros 50 registros</small>
                </h5>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-bordered mb-0 excel-preview">
                        <thead>
                            <tr class="excel-header">
                                <th>Estudiante</th>
                                <th>Cédula</th>
                                <th>Postgrado</th>
                                <th>Asignatura</th>
                                <th>Crédito</th>
                                <th>Nota</th>
                                <th>Año Lectivo</th>
                                <th>Escolaridad</th>
                                <th>Fecha Modificación</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($resultados as $row): ?>
                                <tr class="excel-row">
                                    <td><?= htmlspecialchars($row['apellidos'] . ', ' . $row['nombres']) ?></td>
                                    <td><?= htmlspecialchars($row['cedula']) ?></td>
                                    <td><?= htmlspecialchars($row['postgrado_nombre']) ?></td>
                                    <td><?= htmlspecialchars($row['codigo'] . ' - ' . $row['asignatura_nombre']) ?></td>
                                    <td class="text-center"><?= htmlspecialchars($row['credito']) ?></td>
                                    <td class="text-center"><?= htmlspecialchars($row['nota_definitiva'] ?? 'PENDIENTE') ?></td>
                                    <td><?= htmlspecialchars($row['año_lectivo']) ?></td>
                                    <td><?= htmlspecialchars($row['escolaridad']) ?></td>
                                    <td><?= $row['fecha_modificacion'] ? date('d/m/Y H:i', strtotime($row['fecha_modificacion'])) : 'N/A' ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card-footer text-center">
                <a href="reportes_cuatrimestral.php?<?= http_build_query($filtros) ?>&export=excel" 
                   class="btn btn-success">
                    <i class="bi bi-download"></i> Descargar Excel Completo
                </a>
                <a href="reportes_cuatrimestral.php" class="btn btn-secondary">
                    <i class="bi bi-arrow-left"></i> Volver al Reporte
                </a>
            </div>
        </div>
    </div>
</body>
</html>