<?php
session_start();
include '../includes/db.php';

// Verificar sesión y rol de administrador
if (!isset($_SESSION['username']) || $_SESSION['rol'] != 'administrador') {
    header("Location: ../login.php");
    exit();
}

// Obtener parámetros de filtrado
$fecha_inicio = isset($_GET['fecha_inicio']) ? $_GET['fecha_inicio'] : '';
$fecha_fin = isset($_GET['fecha_fin']) ? $_GET['fecha_fin'] : '';
$estudiante_id = isset($_GET['estudiante_id']) ? intval($_GET['estudiante_id']) : 0;

// Consulta base
$sql = "SELECT c.id, c.fecha, 
       e.id as estudiante_id, e.cedula, e.nombres, e.apellidos,
       p1.id as postgrado_anterior_id, p1.nombre as postgrado_anterior,
       p2.id as postgrado_nuevo_id, p2.nombre as postgrado_nuevo,
       c.motivo, u.username as administrador
       FROM cambios_postgrado c
       JOIN estudiantes e ON c.estudiante_id = e.id
       JOIN postgrados p1 ON c.postgrado_anterior = p1.id
       JOIN postgrados p2 ON c.postgrado_nuevo = p2.id
       JOIN usuarios u ON c.administrador_id = u.id
       WHERE 1=1";

// Aplicar filtros
if (!empty($fecha_inicio)) {
    $sql .= " AND c.fecha >= '$fecha_inicio'";
}
if (!empty($fecha_fin)) {
    $sql .= " AND c.fecha <= '$fecha_fin 23:59:59'";
}
if ($estudiante_id > 0) {
    $sql .= " AND e.id = $estudiante_id";
}

$sql .= " ORDER BY c.fecha DESC";

$result = $conn->query($sql);

// Obtener lista de estudiantes para el filtro
$sql_estudiantes = "SELECT e.id, e.cedula, e.nombres, e.apellidos 
                   FROM estudiantes e
                   JOIN cambios_postgrado c ON e.id = c.estudiante_id
                   GROUP BY e.id
                   ORDER BY e.apellidos, e.nombres";
$result_estudiantes = $conn->query($sql_estudiantes);

$page_title = "Reporte de Cambios de Postgrado";
include '../includes/header.php';
?>

<div class="container">
    <!-- Botón para volver al panel -->
    <div class="mb-4">
        <a href="../admin/index.php" class="btn btn-secondary">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-left" viewBox="0 0 16 16">
                <path fill-rule="evenodd" d="M15 8a.5.5 0 0 0-.5-.5H2.707l3.147-3.146a.5.5 0 1 0-.708-.708l-4 4a.5.5 0 0 0 0 .708l4 4a.5.5 0 0 0 .708-.708L2.707 8.5H14.5A.5.5 0 0 0 15 8z"/>
            </svg>
            Volver al Panel
        </a>
    </div>

    <!-- Filtros -->
    <div class="card filter-card">
        <div class="card-header">
            <h3 class="mb-0">Filtros</h3>
        </div>
        <div class="card-body">
            <form method="get" action="reporte_cambios_postgrado.php">
                <div class="row">
                    <div class="col-md-3">
                        <div class="mb-3">
                            <label for="fecha_inicio" class="form-label">Fecha Inicio:</label>
                            <input type="date" class="form-control" id="fecha_inicio" name="fecha_inicio" value="<?= htmlspecialchars($fecha_inicio) ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="mb-3">
                            <label for="fecha_fin" class="form-label">Fecha Fin:</label>
                            <input type="date" class="form-control" id="fecha_fin" name="fecha_fin" value="<?= htmlspecialchars($fecha_fin) ?>">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label for="estudiante_id" class="form-label">Estudiante:</label>
                            <select class="form-select" id="estudiante_id" name="estudiante_id">
                                <option value="0">Todos los estudiantes</option>
                                <?php while ($estudiante = $result_estudiantes->fetch_assoc()): ?>
                                    <option value="<?= $estudiante['id'] ?>" <?= $estudiante['id'] == $estudiante_id ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($estudiante['apellidos'] . ', ' . $estudiante['nombres'] . ' (' . $estudiante['cedula'] . ')') ?>
                                    </option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary w-100">Filtrar</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Resultados -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h3 class="mb-0">Resultados</h3>
            <div>
                <a href="exportar_cambios.php?<?= http_build_query($_GET) ?>" class="btn btn-success">
                    Exportar a Excel
                </a>
            </div>
        </div>
        <div class="card-body">
            <?php if ($result->num_rows > 0): ?>
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead class="table-dark">
                            <tr>
                                <th>Fecha</th>
                                <th>Estudiante</th>
                                <th>Postgrado Anterior</th>
                                <th>Postgrado Nuevo</th>
                                <th>Motivo</th>
                                <th>Administrador</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($cambio = $result->fetch_assoc()): ?>
                                <tr>
                                    <td><?= date('d/m/Y H:i', strtotime($cambio['fecha'])) ?></td>
                                    <td>
                                        <a href="gestion_estudiantes.php?estudiante_id=<?= $cambio['estudiante_id'] ?>">
                                            <?= htmlspecialchars($cambio['apellidos'] . ', ' . $cambio['nombres']) ?>
                                            <br><small><?= htmlspecialchars($cambio['cedula']) ?></small>
                                        </a>
                                    </td>
                                    <td>
                                        <span class="badge bg-warning text-dark"><?= htmlspecialchars($cambio['postgrado_anterior']) ?></span>
                                    </td>
                                    <td>
                                        <span class="badge bg-success"><?= htmlspecialchars($cambio['postgrado_nuevo']) ?></span>
                                    </td>
                                    <td><?= htmlspecialchars($cambio['motivo']) ?></td>
                                    <td><?= htmlspecialchars($cambio['administrador']) ?></td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="alert alert-info">
                    No se encontraron cambios de postgrado con los filtros seleccionados.
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<style>
    .filter-card {
        background-color: #f0f8ff;
        margin-bottom: 1.5rem;
        box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }
    .table-responsive {
        overflow-x: auto;
    }
    .badge-old {
        background-color: #fd7e14;
    }
    .badge-new {
        background-color: #28a745;
    }
</style>

<?php
include '../includes/footer.php';
$conn->close();
?>