<?php
// migrar_documentos.php - SCRIPT DE MIGRACIÓN DE DOCUMENTOS
// COLOCAR EN: https://postgradomedicinaucv.com/cepmed/migrar_documentos.php

session_start();
define('BASE_PATH', dirname(__FILE__));
include BASE_PATH . '/includes/db.php';

echo "<!DOCTYPE html>
<html lang='es'>
<head>
    <meta charset='UTF-8'>
    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
    <title>Migración de Documentos</title>
    <link href='https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css' rel='stylesheet'>
    <style>
        .container { max-width: 800px; margin-top: 50px; }
        .log { background: #f8f9fa; padding: 15px; border-radius: 5px; margin: 10px 0; max-height: 400px; overflow-y: auto; }
        .success { color: #198754; }
        .error { color: #dc3545; }
        .warning { color: #ffc107; }
    </style>
</head>
<body>
    <div class='container'>
        <div class='card'>
            <div class='card-header bg-primary text-white'>
                <h3>Migración de Documentos - Sistema de Postgrado</h3>
            </div>
            <div class='card-body'>
                <div class='log' id='log'>";

// Verificar conexión
if ($conn->connect_error) {
    die("<p class='error'>❌ Error de conexión a la base de datos: " . $conn->connect_error . "</p>");
}

echo "<p class='success'>✅ Conexión a la base de datos establecida</p>";

// Paso 1: Agregar columnas a la tabla usuarios
echo "<h5>Paso 1: Agregando columnas a la tabla usuarios...</h5>";

$alter_queries = [
    "ALTER TABLE usuarios ADD COLUMN tipo_documento ENUM('V','E','P') NULL DEFAULT 'V' COMMENT 'V=Cédula Venezolana, E=Cédula Extranjera, P=Pasaporte' AFTER username",
    "ALTER TABLE usuarios ADD COLUMN cedula_venezolana VARCHAR(20) NULL AFTER tipo_documento",
    "ALTER TABLE usuarios ADD COLUMN cedula_extranjera VARCHAR(20) NULL AFTER cedula_venezolana", 
    "ALTER TABLE usuarios ADD COLUMN pasaporte VARCHAR(20) NULL AFTER cedula_extranjera"
];

foreach ($alter_queries as $query) {
    if ($conn->query($query) === TRUE) {
        echo "<p class='success'>✅ Ejecutado: " . substr($query, 0, 50) . "...</p>";
    } else {
        // Si la columna ya existe, continuar
        if (strpos($conn->error, "Duplicate column name") !== false) {
            echo "<p class='warning'>⚠️ Columna ya existe: " . substr($query, 0, 50) . "...</p>";
        } else {
            echo "<p class='error'>❌ Error: " . $conn->error . "</p>";
        }
    }
}

// Paso 2: Crear índices
echo "<h5>Paso 2: Creando índices...</h5>";

$index_queries = [
    "ALTER TABLE usuarios ADD INDEX idx_tipo_documento (tipo_documento)",
    "ALTER TABLE usuarios ADD INDEX idx_cedula_venezolana (cedula_venezolana)",
    "ALTER TABLE usuarios ADD INDEX idx_cedula_extranjera (cedula_extranjera)", 
    "ALTER TABLE usuarios ADD INDEX idx_pasaporte (pasaporte)"
];

foreach ($index_queries as $query) {
    if ($conn->query($query) === TRUE) {
        echo "<p class='success'>✅ Ejecutado: " . $query . "</p>";
    } else {
        echo "<p class='warning'>⚠️ " . $conn->error . "</p>";
    }
}

// Paso 3: Migrar datos de estudiantes
echo "<h5>Paso 3: Migrando datos de estudiantes...</h5>";

$sql_estudiantes = "UPDATE usuarios u 
                   INNER JOIN estudiantes e ON u.estudiante_id = e.id 
                   SET 
                       u.tipo_documento = e.tipo_documento,
                       u.cedula_venezolana = e.cedula_venezolana,
                       u.cedula_extranjera = e.cedula_extranjera,
                       u.pasaporte = e.pasaporte
                   WHERE u.estudiante_id IS NOT NULL";

if ($conn->query($sql_estudiantes) === TRUE) {
    $affected_estudiantes = $conn->affected_rows;
    echo "<p class='success'>✅ Migrados $affected_estudiantes registros de estudiantes</p>";
} else {
    echo "<p class='error'>❌ Error migrando estudiantes: " . $conn->error . "</p>";
}

// Paso 4: Migrar datos de usuarios administrativos
echo "<h5>Paso 4: Migrando datos de usuarios administrativos...</h5>";

$sql_administrativos = "UPDATE usuarios 
                       SET 
                           tipo_documento = 'V',
                           cedula_venezolana = username
                       WHERE estudiante_id IS NULL 
                       AND (cedula_venezolana IS NULL OR cedula_venezolana = '')";

if ($conn->query($sql_administrativos) === TRUE) {
    $affected_admin = $conn->affected_rows;
    echo "<p class='success'>✅ Migrados $affected_admin usuarios administrativos</p>";
} else {
    echo "<p class='error'>❌ Error migrando administrativos: " . $conn->error . "</p>";
}

// Paso 5: Verificar resultados
echo "<h5>Paso 5: Verificando resultados...</h5>";

$sql_verificar = "SELECT 
    COUNT(*) as total_usuarios,
    SUM(CASE WHEN estudiante_id IS NOT NULL THEN 1 ELSE 0 END) as estudiantes,
    SUM(CASE WHEN estudiante_id IS NULL THEN 1 ELSE 0 END) as administrativos,
    SUM(CASE WHEN tipo_documento IS NOT NULL THEN 1 ELSE 0 END) as con_tipo_documento,
    SUM(CASE WHEN cedula_venezolana IS NOT NULL THEN 1 ELSE 0 END) as con_cedula_venezolana
FROM usuarios";

$result = $conn->query($sql_verificar);
if ($result && $row = $result->fetch_assoc()) {
    echo "<p class='success'>📊 Resumen de migración:</p>";
    echo "<ul>";
    echo "<li>Total usuarios: " . $row['total_usuarios'] . "</li>";
    echo "<li>Estudiantes: " . $row['estudiantes'] . "</li>";
    echo "<li>Administrativos: " . $row['administrativos'] . "</li>";
    echo "<li>Con tipo documento: " . $row['con_tipo_documento'] . "</li>";
    echo "<li>Con cédula venezolana: " . $row['con_cedula_venezolana'] . "</li>";
    echo "</ul>";
}

// Paso 6: Mostrar ejemplos de usuarios migrados
echo "<h5>Paso 6: Ejemplos de usuarios migrados:</h5>";

$sql_ejemplos = "SELECT 
    u.id, u.username, u.rol, u.tipo_documento, 
    u.cedula_venezolana, u.cedula_extranjera, u.pasaporte,
    CASE WHEN u.estudiante_id IS NOT NULL THEN 'Estudiante' ELSE 'Administrativo' END as tipo_usuario
FROM usuarios u 
ORDER BY u.estudiante_id IS NULL, u.id 
LIMIT 10";

$result = $conn->query($sql_ejemplos);
if ($result && $result->num_rows > 0) {
    echo "<table class='table table-sm table-bordered'>";
    echo "<thead><tr><th>ID</th><th>Usuario</th><th>Rol</th><th>Tipo</th><th>Tipo Doc</th><th>Cédula V</th><th>Cédula E</th><th>Pasaporte</th></tr></thead>";
    echo "<tbody>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['id'] . "</td>";
        echo "<td>" . htmlspecialchars($row['username']) . "</td>";
        echo "<td>" . htmlspecialchars($row['rol']) . "</td>";
        echo "<td>" . $row['tipo_usuario'] . "</td>";
        echo "<td>" . ($row['tipo_documento'] ?: '-') . "</td>";
        echo "<td>" . ($row['cedula_venezolana'] ?: '-') . "</td>";
        echo "<td>" . ($row['cedula_extranjera'] ?: '-') . "</td>";
        echo "<td>" . ($row['pasaporte'] ?: '-') . "</td>";
        echo "</tr>";
    }
    echo "</tbody></table>";
}

echo "</div>"; // Cierre del log

// Mensaje final
echo "<div class='alert alert-success mt-4'>
        <h4>✅ Migración completada exitosamente</h4>
        <p><strong>IMPORTANTE:</strong> Una vez verificado que todo funciona correctamente, elimina este archivo (<code>migrar_documentos.php</code>) por seguridad.</p>
        <p>Ahora puedes usar el sistema de recuperación de contraseñas con documentos para todos los usuarios.</p>
    </div>";

echo "<div class='text-center mt-3'>
        <a href='solicitar_reset.php' class='btn btn-primary'>Probar Recuperación</a>
        <a href='login.php' class='btn btn-secondary'>Ir al Login</a>
    </div>";

echo "            </div>
        </div>
    </div>
</body>
</html>";

$conn->close();
?>