<?php
// 1. Cargar la configuración central (sesión, rutas, bd, codificación)
// CORREGIDO: Ruta correcta
require_once __DIR__ . '/includes/session_config.php';

// Manejar redirección por sesión expirada
if (isset($_GET['error']) && $_GET['error'] === 'session_expired') {
    $error = "Tu sesión ha expirado por inactividad. Por favor, inicia sesión nuevamente.";
}

// Verificar si ya está logueado
if (isset($_SESSION['username'])) {
    $redirect_path = 'index.php'; // Default redirect
    if (isset($_SESSION['rol'])) {
        switch ($_SESSION['rol']) {
            case 'administrador': $redirect_path = 'admin/index.php'; break;
            case 'coordinador1': $redirect_path = 'coordinador1/index.php'; break;
            case 'coordinador2': $redirect_path = 'coordinador2/index.php'; break;
            case 'secretaria': $redirect_path = 'secretaria/index.php'; break;
            case 'estudiante': $redirect_path = 'estudiante/index.php'; break;
        }
    }
    // CORREGIDO: Usar ruta absoluta
    header("Location: /cepmed/" . $redirect_path);
    exit();
}

$error = '';

// Obtener configuración de registro
$registro_habilitado = false;
$password_reset_enabled = false;

if ($conn) {
    // Obtener estado del registro de estudiantes
    $sql_config = "SELECT setting_value FROM app_settings WHERE setting_key = 'student_registration_enabled'";
    $result_config = $conn->query($sql_config);
    if ($result_config && $result_config->num_rows > 0) {
        $config = $result_config->fetch_assoc();
        if ($config['setting_value'] == '1') {
            $registro_habilitado = true;
        }
    }

    // Obtener estado de recuperación de contraseña
    $sql_reset = "SELECT setting_value FROM app_settings WHERE setting_key = 'password_reset_enabled'";
    $result_reset = $conn->query($sql_reset);
    if ($result_reset && $result_reset->num_rows > 0) {
        $config_reset = $result_reset->fetch_assoc();
        if ($config_reset['setting_value'] == '1') {
            $password_reset_enabled = true;
        }
    }
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = trim($_POST['username']);
    $password = $_POST['password'];

    if (!empty($username) && !empty($password)) {
        $sql = "SELECT id, username, password, rol, nombres, apellidos FROM usuarios WHERE username = ?";
        $stmt = $conn->prepare($sql);

        if ($stmt) {
            $stmt->bind_param("s", $username);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows == 1) {
                $usuario = $result->fetch_assoc();

                if (password_verify($password, $usuario['password'])) {
                    // Iniciar sesión y guardar datos del usuario
                    $_SESSION['user_id'] = $usuario['id'];
                    $_SESSION['username'] = $usuario['username'];
                    $_SESSION['rol'] = $usuario['rol'];
                    $_SESSION['nombre_usuario'] = $usuario['nombres'];
                    $_SESSION['apellido_usuario'] = $usuario['apellidos'];
                    $_SESSION['LAST_ACTIVITY'] = time();
                    $_SESSION['CREATED'] = time();

                    // Redirección basada en el rol
                    $redirect_path = 'index.php';
                    switch ($usuario['rol']) {
                        case 'administrador': $redirect_path = 'admin/index.php'; break;
                        case 'secretaria': $redirect_path = 'secretaria/index.php'; break;
                        case 'estudiante': $redirect_path = 'estudiante/index.php'; break;
                        case 'coordinador1': $redirect_path = 'coordinador1/index.php'; break;
                        case 'coordinador2': $redirect_path = 'coordinador2/index.php'; break;
                    }
                    // CORREGIDO: Usar ruta absoluta
                    header("Location: /cepmed/" . $redirect_path);
                    exit();
                } else {
                    $error = "Usuario o contraseña incorrectos";
                }
            } else {
                $error = "Usuario o contraseña incorrectos";
            }
            $stmt->close();
        } else {
            $error = "Error interno del servidor. Intente nuevamente.";
        }
    } else {
        $error = "Por favor ingrese usuario y contraseña";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistema de Postgrado - Login</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        /* Estilos generales */
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f2f5; /* Un gris muy claro, suave */
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
            color: #333;
        }

        /* Contenedor del formulario de login */
        .login-container {
            background-color: #ffffff;
            border-radius: 10px; /* Bordes suaves */
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.08); /* Sombra sutil y elegante */
            padding: 40px;
            width: 100%;
            max-width: 400px; /* Un tamaño cómodo */
            text-align: center;
            animation: slideInUp 0.7s ease-out;
        }

        @keyframes slideInUp {
            from { opacity: 0; transform: translateY(30px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* Sección del logo/título */
        .logo {
            margin-bottom: 30px;
        }

        .logo h1 {
            color: #34495e; /* Un azul oscuro más sobrio */
            margin-bottom: 8px;
            font-weight: 600;
            font-size: 2rem;
        }

        .logo p {
            color: #7f8c8d;
            margin: 0;
            font-size: 0.9rem;
        }

        /* Grupos de formulario */
        .form-group {
            margin-bottom: 20px;
            text-align: left;
        }

        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #555;
            font-weight: 500;
            font-size: 0.95rem;
        }

        .form-group input {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid #ddd;
            border-radius: 6px; /* Bordes suaves */
            font-size: 1rem;
            box-sizing: border-box;
            transition: border-color 0.2s ease, box-shadow 0.2s ease;
        }

        .form-group input:focus {
            border-color: #007bff; /* Azul clásico de enfoque */
            box-shadow: 0 0 0 3px rgba(0, 123, 255, 0.15);
            outline: none;
        }

        /* Botón de login */
        .btn-login {
            width: 100%;
            padding: 14px;
            background-color: #007bff; /* Azul primario */
            color: white; /* Texto blanco para contraste */
            border: none;
            border-radius: 6px;
            font-size: 1.05rem;
            font-weight: 600;
            cursor: pointer;
            transition: background-color 0.3s ease, transform 0.2s ease;
        }

        .btn-login:hover {
            background-color: #0056b3; /* Azul más oscuro al pasar el ratón */
            transform: translateY(-1px); /* Pequeño efecto de elevación */
            color: white; /* ASEGURADO: El texto sigue siendo blanco */
        }

        .btn-login:active {
            transform: translateY(0);
        }

        /* Mensaje de error */
        .error-message {
            color: #dc3545;
            background-color: #fef4f4; /* Fondo rojo muy claro */
            border: 1px solid #f5c6cb;
            border-radius: 6px;
            padding: 10px;
            margin-bottom: 20px;
            font-size: 0.9rem;
            text-align: center;
        }

        /* Pie de página */
        .footer {
            margin-top: 25px;
            color: #a0a0a0;
            font-size: 0.8rem;
        }

        .register-link {
            margin-bottom: 10px;
            font-size: 0.9rem;
        }

        .register-link a {
            color: #007bff;
            text-decoration: none;
            font-weight: 500;
        }

        .register-link a:hover {
            text-decoration: underline;
        }

        .reset-link {
            margin-bottom: 15px;
            font-size: 0.9rem;
        }

        .reset-link a {
            color: #6c757d;
            text-decoration: none;
        }

        .reset-link a:hover {
            color: #495057;
            text-decoration: underline;
        }

        .links-container {
            margin: 20px 0;
            padding: 15px;
            background-color: #f8f9fa;
            border-radius: 6px;
            border-left: 4px solid #007bff;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="logo">
            <h1>Sistema de Postgrado</h1>
            <p>Facultad de Medicina - UCV</p>
        </div>

        <?php if (!empty($error)): ?>
            <div class="error-message"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>

        <form method="POST" action="login.php">
            <div class="form-group">
                <label for="username">Usuario</label>
                <input type="text" id="username" name="username" required autofocus>
            </div>

            <div class="form-group">
                <label for="password">Contraseña</label>
                <input type="password" id="password" name="password" required>
            </div>

            <button type="submit" class="btn-login">Iniciar Sesión</button>
        </form>

        <div class="footer">
            <?php if ($registro_habilitado): ?>
                <p class="register-link"><a href="registro_estudiante.php">¿Eres estudiante? Regístrate aquí</a></p>
            <?php endif; ?>
            
            <?php if ($password_reset_enabled): ?>
                <p class="reset-link"><a href="solicitar_reset.php">¿Olvidaste tu contraseña?</a></p>
            <?php endif; ?>
            
            © <?php echo date('Y'); ?> Universidad Central de Venezuela
        </div>
    </div>
</body>
</html>