<?php
// No es necesario iniciar sesión ni requerir db.php aquí, 
// porque este archivo siempre se incluye después de header.php que ya los tiene.

// Obtener el texto del footer desde la base de datos
$footer_text = '&copy; ' . date('Y') . ' Sistema de Gestión de Postgrados - Todos los derechos reservados'; // Default
if (isset($conn)) {
    $sql_footer = "SELECT setting_value FROM app_settings WHERE setting_key = 'footer_text'";
    $result_footer = $conn->query($sql_footer);
    if ($result_footer && $result_footer->num_rows > 0) {
        $db_footer_text = $result_footer->fetch_assoc()['setting_value'];
        if (!empty(trim($db_footer_text))) {
            $footer_text = $db_footer_text;
        }
    }
}
?>
        </main> <!-- Cierre del main-container -->

        <footer class="full-width-footer" style="background-color: #2c3e50; color: white; width: 100%; padding: 2rem 0; margin-top: 4rem;">
            <div class="footer-container" style="max-width: 1200px; margin: 0 auto; padding: 0 15px;">
                <div class="row">
                    <div class="col-md-4 mb-4 mb-md-0">
                        <h5 style="font-size: 1.2rem;"><i class="fas fa-university me-2"></i>Universidad Central de Venezuela</h5>
                        <p class="mb-1">Facultad de Medicina</p>
                        <p>Comisión de Estudios de Postgrado</p>
                    </div>
                    
                    <div class="col-md-4 mb-4 mb-md-0">
                        <h5 style="font-size: 1.2rem;"><i class="fas fa-map-marker-alt me-2"></i>Contacto</h5>
                        <p class="mb-1"><i class="fas fa-phone me-2"></i> +58 212-555-1234</p>
                        <p class="mb-1"><i class="fas fa-envelope me-2"></i> postgrado.medicina@ucv.ve</p>
                    </div>
                    
                    <div class="col-md-4">
                        <h5 style="font-size: 1.2rem;"><i class="fas fa-link me-2"></i>Enlaces</h5>
                        <ul class="list-unstyled">
                            <li class="mb-2"><a href="<?= BASE_URL ?>/index.php" class="text-white text-decoration-none"><i class="fas fa-home me-2"></i>Portal</a></li>
                        </ul>
                    </div>
                </div>
                
                <div class="text-center pt-3" style="border-top: 1px solid rgba(255,255,255,0.1); margin-top: 2rem;">
                    <p class="mb-0">
                        <?= htmlspecialchars($footer_text); ?>
                    </p>
                </div>
            </div>
        </footer>

        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
        
<?php if (isset($_SESSION['user_id'])): ?>
        <script>
            // Inyectar la configuración de la sesión de PHP a JavaScript
            const sessionConfig = {
                duration: <?php echo json_encode($session_settings['session_duration'] ?? 3600); ?>,
                neverExpire: <?php echo json_encode($session_settings['session_never_expire'] ?? 0); ?>,
                warningTime: 300 // 5 minutos en segundos
            };
            // Agregar BASE_URL para que esté disponible en JavaScript
            const BASE_URL = '<?= BASE_URL ?>';
        </script> 
         <script src="<?= BASE_URL ?>/js/session_manager.js"></script>
        <?php endif; ?>
        <?php if (isset($custom_scripts)): ?>
            <?php echo $custom_scripts; ?>
        <?php endif; ?>
    </body>
</html>
