<?php
echo "<h1>🔍 Buscador de Redirecciones a /v2/</h1>";

function searchInFiles($directory, $searchText) {
    $found = [];
    $iterator = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($directory));
    
    foreach ($iterator as $file) {
        if ($file->isFile() && $file->getExtension() == 'php') {
            $content = file_get_contents($file->getPathname());
            if (strpos($content, $searchText) !== false) {
                $found[] = $file->getPathname();
            }
        }
    }
    return $found;
}

// Buscar
$results = searchInFiles('.', 'Location: /v2/');

if (count($results) > 0) {
    echo "<h3>✅ Se encontraron redirecciones en:</h3>";
    foreach ($results as $file) {
        echo "<p><strong>Archivo:</strong> $file</p>";
        
        // Mostrar línea específica
        $lines = file($file);
        foreach ($lines as $lineNumber => $line) {
            if (strpos($line, 'Location: /v2/') !== false) {
                echo "<pre>Línea " . ($lineNumber + 1) . ": " . htmlspecialchars($line) . "</pre>";
            }
        }
    }
} else {
    echo "<p>No se encontraron redirecciones directas a '/v2/'</p>";
    echo "<p>Buscando patrones similares...</p>";
    
    // Buscar otros patrones
    $patterns = ['/v2/', 'header.*Location', 'redirect.*v2'];
    foreach ($patterns as $pattern) {
        $results = searchInFiles('.', $pattern);
        if (count($results) > 0) {
            echo "<h4>Patrón: $pattern</h4>";
            foreach ($results as $file) {
                echo "<p>$file</p>";
            }
        }
    }
}
?>