<?php
session_start();

if (!isset($_SESSION['username']) || $_SESSION['rol'] != 'coordinador2') {
    header("Location: ../login.php");
    exit();
}

include '../includes/db.php';

// Obtener el postgrado asignado al coordinador2 (asumimos ID 1 según tu DB)
$postgrado_asignado = 1;
$id = intval($_GET['id']);

// Verificar que la inscripción pertenece al postgrado del coordinador
$sql = "SELECT i.id 
        FROM inscripciones i
        JOIN denominaciones d ON i.denominacion_id = d.id
        WHERE i.id = ? AND d.postgrado_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ii", $id, $postgrado_asignado);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows == 0) {
    $_SESSION['error'] = "No tienes permiso para eliminar esta inscripción.";
    header("Location: inscripciones.php");
    exit();
}

// Eliminar la inscripción
$sql = "DELETE FROM inscripciones WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);

if ($stmt->execute()) {
    $_SESSION['success'] = "Inscripción eliminada correctamente.";
} else {
    $_SESSION['error'] = "Error al eliminar la inscripción: " . $conn->error;
}

header("Location: inscripciones.php");
exit();
?>