<?php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['rol'] != 'coordinador2') {
    header("Location: ../login.php");
    exit();
}

include '../includes/db.php';

// Obtener datos del estudiante
$estudiante_id = $_GET['id'] ?? 0;
$estudiante = [];

if ($estudiante_id > 0) {
    $stmt = $conn->prepare("SELECT * FROM estudiantes WHERE id = ?");
    $stmt->bind_param("i", $estudiante_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $estudiante = $result->fetch_assoc();
}

// Procesar actualización
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $nombres = $_POST['nombres'];
    $apellidos = $_POST['apellidos'];
    $cedula = $_POST['cedula'];
    $correo = $_POST['correo'];
    
    $stmt = $conn->prepare("UPDATE estudiantes SET 
                          nombres = ?, 
                          apellidos = ?, 
                          cedula = ?, 
                          correo = ?
                          WHERE id = ?");
    $stmt->bind_param("ssssi", $nombres, $apellidos, $cedula, $correo, $estudiante_id);
    
    if ($stmt->execute()) {
        $_SESSION['success'] = "Estudiante actualizado correctamente";
        header("Location: estudiantes.php");
        exit();
    } else {
        $_SESSION['error'] = "Error al actualizar el estudiante";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Estudiante</title>
    <style>
        /* Estilos unificados */
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 20px;
            background-color: #f8f9fa;
        }
        
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            padding: 25px;
            border-radius: 10px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.1);
        }
        
        .form-group {
            margin-bottom: 1.5rem;
        }
        
        label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 600;
            color: #2c3e50;
        }
        
        input[type="text"],
        input[type="email"] {
            width: 100%;
            padding: 0.75rem;
            border: 1px solid #ced4da;
            border-radius: 5px;
            font-size: 1rem;
        }
        
        .btn-container {
            margin-top: 2rem;
            text-align: right;
        }
        
        .btn {
            padding: 0.75rem 1.5rem;
            border-radius: 5px;
            text-decoration: none;
            font-size: 1rem;
            transition: all 0.3s;
            border: none;
            cursor: pointer;
        }
        
        .btn-primary {
            background-color: #2c3e50;
            color: white;
        }
        
        .btn-secondary {
            background-color: #6c757d;
            color: white;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Editar Estudiante</h1>
            <a href="estudiantes.php" class="btn btn-secondary">← Volver</a>
        </div>
        
        <?php if (isset($_SESSION['error'])): ?>
            <div class="alert alert-danger"><?= $_SESSION['error'] ?></div>
            <?php unset($_SESSION['error']); ?>
        <?php endif; ?>
        
        <form method="POST">
            <div class="form-group">
                <label for="cedula">Cédula:</label>
                <input type="text" id="cedula" name="cedula" 
                       value="<?= htmlspecialchars($estudiante['cedula'] ?? '') ?>" required>
            </div>
            
            <div class="form-group">
                <label for="nombres">Nombres:</label>
                <input type="text" id="nombres" name="nombres" 
                       value="<?= htmlspecialchars($estudiante['nombres'] ?? '') ?>" required>
            </div>
            
            <div class="form-group">
                <label for="apellidos">Apellidos:</label>
                <input type="text" id="apellidos" name="apellidos" 
                       value="<?= htmlspecialchars($estudiante['apellidos'] ?? '') ?>" required>
            </div>
            
            <div class="form-group">
                <label for="correo">Correo:</label>
                <input type="email" id="correo" name="correo" 
                       value="<?= htmlspecialchars($estudiante['correo'] ?? '') ?>" required>
            </div>
            
            <div class="btn-container">
                <button type="submit" class="btn btn-primary">Guardar Cambios</button>
            </div>
        </form>
    </div>
</body>
</html>
<?php $conn->close(); ?>