<?php
header('Content-Type: application/json');
include '../includes/db.php';

// Verificar conexión
if ($conn->connect_error) {
    echo json_encode([
        'success' => false,
        'message' => 'Error de conexión a la base de datos'
    ]);
    exit();
}

if (isset($_GET['cedula'])) {
    $cedula = trim($_GET['cedula']);
    
    if (empty($cedula)) {
        echo json_encode([
            'success' => false,
            'message' => 'El documento no puede estar vacío'
        ]);
        exit();
    }
    
    // CONSULTA ACTUALIZADA - Buscar en todos los campos de documentos
    $stmt = $conn->prepare("SELECT 
        id, cedula, nombres, apellidos, correo, telefono, direccion,
        tipo_documento, cedula_venezolana, cedula_extranjera, pasaporte
        FROM estudiantes 
        WHERE cedula = ? 
        OR cedula_venezolana = ? 
        OR cedula_extranjera = ? 
        OR pasaporte = ?");
    
    if ($stmt === false) {
        echo json_encode([
            'success' => false,
            'message' => 'Error en la preparación de la consulta: ' . $conn->error
        ]);
        exit();
    }
    
    $stmt->bind_param("ssss", $cedula, $cedula, $cedula, $cedula);
    
    if (!$stmt->execute()) {
        echo json_encode([
            'success' => false,
            'message' => 'Error al ejecutar la consulta: ' . $stmt->error
        ]);
        $stmt->close();
        exit();
    }
    
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $estudiante = $result->fetch_assoc();
        
        // Determinar el tipo de documento encontrado
        $tipo_documento_encontrado = '';
        if ($estudiante['cedula'] === $cedula) {
            $tipo_documento_encontrado = 'cedula_principal';
        } elseif ($estudiante['cedula_venezolana'] === $cedula) {
            $tipo_documento_encontrado = 'cedula_venezolana';
        } elseif ($estudiante['cedula_extranjera'] === $cedula) {
            $tipo_documento_encontrado = 'cedula_extranjera';
        } elseif ($estudiante['pasaporte'] === $cedula) {
            $tipo_documento_encontrado = 'pasaporte';
        }
        
        // Texto descriptivo del tipo de documento
        $tipo_texto = '';
        switch($estudiante['tipo_documento']) {
            case 'V': $tipo_texto = 'Cédula Venezolana'; break;
            case 'E': $tipo_texto = 'Cédula Extranjera'; break;
            case 'P': $tipo_texto = 'Pasaporte'; break;
            default: $tipo_texto = 'Documento';
        }
        
        echo json_encode([
            'success' => true,
            'data' => [
                'id' => $estudiante['id'],
                'cedula' => $estudiante['cedula'],
                'nombres' => $estudiante['nombres'],
                'apellidos' => $estudiante['apellidos'],
                'correo' => $estudiante['correo'],
                'telefono' => $estudiante['telefono'],
                'direccion' => $estudiante['direccion'],
                'tipo_documento' => $estudiante['tipo_documento'],
                'tipo_documento_texto' => $tipo_texto,
                'documento_encontrado_en' => $tipo_documento_encontrado
            ],
            'message' => "Estudiante encontrado ($tipo_texto)"
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'No se encontró un estudiante con ese documento'
        ]);
    }
    $stmt->close();
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Documento no proporcionado'
    ]);
}

$conn->close();
?>