<?php
/**
 * keep_alive.php
 */
// Incluir la configuración de sesión
require_once __DIR__ . '/session_config.php';

// Configurar headers
header('Content-Type: application/json');
header('Cache-Control: no-cache, no-store, must-revalidate');
header('Pragma: no-cache');
header('Expires: 0');

// Solo aceptar POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Método no permitido']);
    exit();
}

// Verificar sesión
if (isset($_SESSION['user_id'])) {
    $_SESSION['LAST_ACTIVITY'] = time();
    echo json_encode([
        'status' => 'success', 
        'message' => 'Session refreshed',
        'timestamp' => $_SESSION['LAST_ACTIVITY']
    ]);
} else {
    http_response_code(401);
    echo json_encode([
        'status' => 'error', 
        'message' => 'Not authenticated'
    ]);
}
?>