<?php
session_start();

if (!isset($_SESSION['username']) || $_SESSION['rol'] != 'administrador') {
    header("Location: ../login.php");
    exit();
}

include '../includes/db.php';

// Obtener parámetros de búsqueda
$search = isset($_GET['search']) ? trim($_GET['search']) : '';

// Obtener lista de estudiantes (filtrados por búsqueda si existe)
$sql_estudiantes = "SELECT e.* 
                   FROM estudiantes e
                   WHERE e.cedula LIKE ? OR e.nombres LIKE ? OR e.apellidos LIKE ?
                   ORDER BY e.apellidos";
$stmt_estudiantes = $conn->prepare($sql_estudiantes);

if (!$stmt_estudiantes) {
    die("Error en la preparación de la consulta: " . $conn->error);
}

$search_term = "%$search%";
$stmt_estudiantes->bind_param("sss", $search_term, $search_term, $search_term);
$stmt_estudiantes->execute();
$estudiantes = $stmt_estudiantes->get_result()->fetch_all(MYSQLI_ASSOC);

$page_title = "Kardex de Estudiantes";
include '../includes/header.php';
?>

<div class="container">
    <h1 class="mt-4">Kardex de Estudiantes</h1>

    <!-- Enlace para volver al menú -->
    <a href="../admin/index.php" class="btn btn-secondary mb-4">Volver al Menú</a>

    <!-- Buscador de estudiantes -->
    <div class="card mb-4">
        <div class="card-header bg-primary text-white">
            <h2 class="mb-0">Buscar Estudiante</h2>
        </div>
        <div class="card-body">
            <form method="get" class="row g-3">
                <div class="col-md-8">
                    <input type="text" name="search" class="form-control" placeholder="Cédula, Nombre o Apellido" value="<?= htmlspecialchars($search) ?>">
                </div>
                <div class="col-md-4">
                    <button type="submit" class="btn btn-primary">Buscar</button>
                    <a href="kardex_estudiantes.php" class="btn btn-outline-secondary">Limpiar</a>
                </div>
            </form>
        </div>
    </div>

    <!-- Lista de estudiantes -->
    <div class="card">
        <div class="card-header bg-info text-white">
            <h2 class="mb-0">Listado de Estudiantes</h2>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-bordered">
                    <thead class="table-light">
                        <tr>
                            <th>ID</th>
                            <th>Nombre</th>
                            <th>Apellidos</th>
                            <th>Cédula</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($estudiantes as $estudiante): ?>
                            <tr>
                                <td><?= $estudiante['id'] ?></td>
                                <td><?= htmlspecialchars($estudiante['nombres']) ?></td>
                                <td><?= htmlspecialchars($estudiante['apellidos']) ?></td>
                                <td><?= htmlspecialchars($estudiante['cedula']) ?></td>
                                <td>
                                    <a href="detalles_estudiante.php?estudiante_id=<?= $estudiante['id'] ?>" class="btn btn-sm btn-primary">Ver Detalles</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php
include '../includes/footer.php';
$stmt_estudiantes->close();
$conn->close();
?>