<?php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['rol'] != 'administrador') {
    header("Location: ../login.php");
    exit();
}

include '../includes/db.php';

// --- LÓGICA PARA ACTUALIZAR EL ESTADO ---
if (isset($_GET['cambiar_estado'])) {
    $postgrado_id = intval($_GET['id']);
    $nuevo_estado = $_GET['cambiar_estado'] === 'cerrado' ? 'cerrado' : 'abierto';

    if ($postgrado_id > 0) {
        $sql = "UPDATE postgrados SET estado = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("si", $nuevo_estado, $postgrado_id);
        if ($stmt->execute()) {
            $_SESSION['success'] = "Estado del postgrado actualizado correctamente.";
        } else {
            $_SESSION['error'] = "Error al actualizar el estado.";
        }
        header("Location: gestionar_estado_postgrados.php");
        exit();
    }
}


$page_title = "Gestionar Estado de Postgrados";
include '../includes/header.php';

// --- OBTENER TODOS LOS POSTGRADOS Y SU ESTADO ---
$sql_postgrados = "SELECT id, nombre, estado FROM postgrados ORDER BY nombre";
$result_postgrados = $conn->query($sql_postgrados);

?>

<div class="container mt-4">
    <div class="mb-4">
        <a href="index.php" class="btn btn-secondary">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-left" viewBox="0 0 16 16">
                <path fill-rule="evenodd" d="M15 8a.5.5 0 0 0-.5-.5H2.707l3.147-3.146a.5.5 0 1 0-.708-.708l-4 4a.5.5 0 0 0 0 .708l4 4a.5.5 0 0 0 .708-.708L2.707 8.5H14.5A.5.5 0 0 0 15 8z"/>
            </svg>
            Volver al Panel
        </a>
    </div>
    
    <?php if (isset($_SESSION['success'])): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert"><?= htmlspecialchars($_SESSION['success']) ?><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>
        <?php unset($_SESSION['success']); ?>
    <?php endif; ?>
    
    <?php if (isset($_SESSION['error'])): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert"><?= htmlspecialchars($_SESSION['error']) ?><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>
        <?php unset($_SESSION['error']); ?>
    <?php endif; ?>

    <div class="card">
        <div class="card-header bg-primary text-white">
            <h3 class="mb-0">Gestionar Estado de Postgrados para Agregar Denominaciones</h3>
        </div>
        <div class="card-body">
            <p>Desde aquí puedes "cerrar" un postgrado para que no se le puedan agregar más denominaciones, o "abrirlo" para permitir nuevas adiciones.</p>
            <div class="table-responsive">
                <table class="table table-striped table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>Postgrado</th>
                            <th>Estado Actual</th>
                            <th>Acción</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($result_postgrados->num_rows > 0): ?>
                            <?php while($postgrado = $result_postgrados->fetch_assoc()): ?>
                                <tr>
                                    <td><?= htmlspecialchars($postgrado['nombre']) ?></td>
                                    <td>
                                        <?php if ($postgrado['estado'] == 'abierto'): ?>
                                            <span class="badge bg-success">Abierto</span>
                                        <?php else: ?>
                                            <span class="badge bg-danger">Cerrado</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if ($postgrado['estado'] == 'abierto'): ?>
                                            <a href="gestionar_estado_postgrados.php?cambiar_estado=cerrado&id=<?= $postgrado['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('¿Está seguro que desea cerrar este postgrado a nuevas denominaciones?')">Cerrar Denominaciones</a>
                                        <?php else: ?>
                                            <a href="gestionar_estado_postgrados.php?cambiar_estado=abierto&id=<?= $postgrado['id'] ?>" class="btn btn-success btn-sm" onclick="return confirm('¿Está seguro que desea abrir este postgrado a nuevas denominaciones?')">Abrir Denominaciones</a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="3" class="text-center">No hay postgrados registrados.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php
include '../includes/footer.php';
$conn->close();
?>