<?php
session_start();

// Configurar encoding UTF-8
header('Content-Type: text/html; charset=utf-8');
mb_internal_encoding('UTF-8');

if (!isset($_SESSION['username']) || $_SESSION['rol'] != 'administrador') {
    header("Location: ../login.php");
    exit();
}

include '../includes/db.php';

// Configurar conexión para usar UTF-8
$conn->set_charset("utf8mb4");
$conn->query("SET NAMES 'utf8mb4'");
$conn->query("SET CHARACTER SET utf8mb4");
$conn->query("SET COLLATION_CONNECTION = 'utf8mb4_unicode_ci'");

// Obtener ID del estudiante a editar
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($id <= 0) {
    header("Location: gestion_estudiantes.php");
    exit();
}

// Obtener datos del estudiante
$sql = "SELECT * FROM estudiantes WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$estudiante = $result->fetch_assoc();

if (!$estudiante) {
    header("Location: gestion_estudiantes.php");
    exit();
}

// Procesar actualización
if (isset($_POST['actualizar_estudiante'])) {
    $tipo_documento = trim($_POST['tipo_documento']);
    $cedula_venezolana = trim($_POST['cedula_venezolana']);
    $cedula_extranjera = trim($_POST['cedula_extranjera']);
    $pasaporte = trim($_POST['pasaporte']);
    $nombres = trim($_POST['nombres']);
    $apellidos = trim($_POST['apellidos']);
    $correo = trim($_POST['correo']);
    $telefono = trim($_POST['telefono']);
    $celular = trim($_POST['celular']);
    $direccion = trim($_POST['direccion']);

    // Determinar qué campo usar como cédula principal (para compatibilidad)
    $cedula_principal = '';
    switch ($tipo_documento) {
        case 'V':
            $cedula_principal = $cedula_venezolana;
            break;
        case 'E':
            $cedula_principal = $cedula_extranjera;
            break;
        case 'P':
            $cedula_principal = $pasaporte;
            break;
    }

    $sql = "UPDATE estudiantes SET 
            cedula = ?,
            tipo_documento = ?,
            cedula_venezolana = ?,
            cedula_extranjera = ?,
            pasaporte = ?,
            nombres = ?, 
            apellidos = ?, 
            correo = ?, 
            telefono = ?, 
            celular = ?, 
            direccion = ? 
            WHERE id = ?";
    
    $stmt = $conn->prepare($sql);
    
    // CORRECCIÓN: 12 parámetros = 12 caracteres en el string de tipos
    if ($stmt) {
        $stmt->bind_param("sssssssssssi", 
            $cedula_principal, 
            $tipo_documento, 
            $cedula_venezolana, 
            $cedula_extranjera, 
            $pasaporte, 
            $nombres, 
            $apellidos, 
            $correo, 
            $telefono, 
            $celular, 
            $direccion, 
            $id
        );
        
        if ($stmt->execute()) {
            $_SESSION['success'] = "Estudiante actualizado correctamente.";
        } else {
            $_SESSION['error'] = "Error al actualizar el estudiante: " . $conn->error;
        }
        $stmt->close();
    } else {
        $_SESSION['error'] = "Error en la preparación de la consulta: " . $conn->error;
    }
    
    header("Location: gestion_estudiantes.php");
    exit();
}

$page_title = "Editar Estudiante";
include '../includes/header.php';
?>

<div class="container">
    <!-- Botones de navegación en línea -->
    <div class="d-flex justify-content-between mb-4">
        <a href="index.php" class="btn btn-secondary">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-left" viewBox="0 0 16 16">
                <path fill-rule="evenodd" d="M15 8a.5.5 0 0 0-.5-.5H2.707l3.147-3.146a.5.5 0 1 0-.708-.708l-4 4a.5.5 0 0 0 0 .708l4 4a.5.5 0 0 0 .708-.708L2.707 8.5H14.5A.5.5 0 0 0 15 8z"/>
            </svg>
            Volver al Panel
        </a>
        <a href="gestion_estudiantes.php" class="btn btn-outline-secondary">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-people" viewBox="0 0 16 16">
                <path d="M15 14s1 0 1-1-1-4-5-4-5 3-5 4 1 1 1 1h8zm-7.978-1A.261.261 0 0 1 7 12.996c.001-.264.167-1.03.76-1.72C8.312 10.629 9.282 10 11 10c1.717 0 2.687.63 3.24 1.276.593.69.758 1.457.76 1.72l-.008.002a.274.274 0 0 1-.014.002H7.022zM11 7a2 2 0 1 0 0-4 2 2 0 0 0 0 4zm3-2a3 3 0 1 1-6 0 3 3 0 0 1 6 0zM6.936 9.28a5.88 5.88 0 0 0-1.23-.247A7.35 7.35 0 0 0 5 9c-4 0-5 3-5 4 0 .667.333 1 1 1h4.216A2.238 2.238 0 0 1 5 13c0-1.01.377-2.042 1.09-2.904.243-.294.526-.569.846-.816zM4.92 10A5.493 5.493 0 0 0 4 13H1c0-.26.164-1.03.76-1.724.545-.636 1.492-1.256 3.16-1.275z"/>
            </svg>
            Volver a Estudiantes
        </a>
    </div>

    <?php if (isset($_SESSION['error'])): ?>
        <div class="alert alert-danger"><?= $_SESSION['error'] ?></div>
        <?php unset($_SESSION['error']); ?>
    <?php endif; ?>

    <div class="card">
        <div class="card-header bg-primary text-white">
            <h3 class="mb-0">Editar Información del Estudiante</h3>
        </div>
        <div class="card-body">
            <form action="editar_estudiante.php?id=<?= $id ?>" method="post" class="row g-3" onsubmit="return validateDocumentFields()">
                <div class="col-md-3">
                    <label for="tipo_documento" class="form-label">Tipo de Documento:</label>
                    <select class="form-control" id="tipo_documento" name="tipo_documento" required onchange="toggleDocumentFields()">
                        <option value="V" <?= ($estudiante['tipo_documento'] ?? 'V') == 'V' ? 'selected' : '' ?>>Cédula Venezolana</option>
                        <option value="E" <?= ($estudiante['tipo_documento'] ?? 'V') == 'E' ? 'selected' : '' ?>>Cédula Extranjera</option>
                        <option value="P" <?= ($estudiante['tipo_documento'] ?? 'V') == 'P' ? 'selected' : '' ?>>Pasaporte</option>
                    </select>
                </div>
                
                <div class="col-md-3" id="cedula_venezolana_field">
                    <label for="cedula_venezolana" class="form-label">Cédula Venezolana:</label>
                    <input type="text" class="form-control" id="cedula_venezolana" name="cedula_venezolana" 
                           value="<?= htmlspecialchars($estudiante['cedula_venezolana'] ?? $estudiante['cedula']) ?>" 
                           placeholder="Cédula Venezolana">
                </div>
                
                <div class="col-md-3" id="cedula_extranjera_field" style="display: none;">
                    <label for="cedula_extranjera" class="form-label">Cédula Extranjera:</label>
                    <input type="text" class="form-control" id="cedula_extranjera" name="cedula_extranjera" 
                           value="<?= htmlspecialchars($estudiante['cedula_extranjera'] ?? '') ?>" 
                           placeholder="Cédula Extranjera">
                </div>
                
                <div class="col-md-3" id="pasaporte_field" style="display: none;">
                    <label for="pasaporte" class="form-label">Pasaporte:</label>
                    <input type="text" class="form-control" id="pasaporte" name="pasaporte" 
                           value="<?= htmlspecialchars($estudiante['pasaporte'] ?? '') ?>" 
                           placeholder="Pasaporte">
                </div>
                
                <div class="col-md-3">
                    <label for="nombres" class="form-label">Nombres:</label>
                    <input type="text" class="form-control" id="nombres" name="nombres" 
                           value="<?= htmlspecialchars($estudiante['nombres']) ?>" required>
                </div>
                
                <div class="col-md-3">
                    <label for="apellidos" class="form-label">Apellidos:</label>
                    <input type="text" class="form-control" id="apellidos" name="apellidos" 
                           value="<?= htmlspecialchars($estudiante['apellidos']) ?>" required>
                </div>
                
                <div class="col-md-3">
                    <label for="correo" class="form-label">Correo:</label>
                    <input type="email" class="form-control" id="correo" name="correo" 
                           value="<?= htmlspecialchars($estudiante['correo']) ?>" required>
                </div>
                
                <div class="col-md-3">
                    <label for="telefono" class="form-label">Teléfono:</label>
                    <input type="text" class="form-control" id="telefono" name="telefono" 
                           value="<?= htmlspecialchars($estudiante['telefono']) ?>">
                </div>
                
                <div class="col-md-3">
                    <label for="celular" class="form-label">Celular:</label>
                    <input type="text" class="form-control" id="celular" name="celular" 
                           value="<?= htmlspecialchars($estudiante['celular']) ?>">
                </div>
                
                <div class="col-md-6">
                    <label for="direccion" class="form-label">Dirección:</label>
                    <input type="text" class="form-control" id="direccion" name="direccion" 
                           value="<?= htmlspecialchars($estudiante['direccion']) ?>">
                </div>
                
                <div class="col-12">
                    <button type="submit" name="actualizar_estudiante" class="btn btn-primary">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-save" viewBox="0 0 16 16">
                            <path d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1H9.5a1 1 0 0 0-1 1v7.293l2.646-2.647a.5.5 0 0 1 .708.708l-3.5 3.5a.5.5 0 0 1-.708 0l-3.5-3.5a.5.5 0 1 1 .708-.708L7.5 9.293V2a2 2 0 0 1 2-2H14a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h2.5a.5.5 0 0 1 0 1H2z"/>
                        </svg>
                        Actualizar Estudiante
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function toggleDocumentFields() {
    const tipoDocumento = document.getElementById('tipo_documento').value;
    
    // Ocultar todos los campos primero
    document.getElementById('cedula_venezolana_field').style.display = 'none';
    document.getElementById('cedula_extranjera_field').style.display = 'none';
    document.getElementById('pasaporte_field').style.display = 'none';
    
    // Mostrar solo el campo correspondiente
    switch(tipoDocumento) {
        case 'V':
            document.getElementById('cedula_venezolana_field').style.display = 'block';
            document.getElementById('cedula_venezolana').required = true;
            document.getElementById('cedula_extranjera').required = false;
            document.getElementById('pasaporte').required = false;
            break;
        case 'E':
            document.getElementById('cedula_extranjera_field').style.display = 'block';
            document.getElementById('cedula_venezolana').required = false;
            document.getElementById('cedula_extranjera').required = true;
            document.getElementById('pasaporte').required = false;
            break;
        case 'P':
            document.getElementById('pasaporte_field').style.display = 'block';
            document.getElementById('cedula_venezolana').required = false;
            document.getElementById('cedula_extranjera').required = false;
            document.getElementById('pasaporte').required = true;
            break;
    }
}

function validateDocumentFields() {
    const tipoDocumento = document.getElementById('tipo_documento').value;
    let isValid = true;
    
    switch(tipoDocumento) {
        case 'V':
            if (!document.getElementById('cedula_venezolana').value.trim()) {
                alert('Por favor ingrese la cédula venezolana');
                isValid = false;
            }
            break;
        case 'E':
            if (!document.getElementById('cedula_extranjera').value.trim()) {
                alert('Por favor ingrese la cédula extranjera');
                isValid = false;
            }
            break;
        case 'P':
            if (!document.getElementById('pasaporte').value.trim()) {
                alert('Por favor ingrese el pasaporte');
                isValid = false;
            }
            break;
    }
    
    return isValid;
}

// Inicializar campos al cargar la página
document.addEventListener('DOMContentLoaded', function() {
    toggleDocumentFields();
});
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<?php
include '../includes/footer.php';
$conn->close();
?>