<?php
session_start();

// Configurar encoding UTF-8
header('Content-Type: text/html; charset=utf-8');
mb_internal_encoding('UTF-8');

if (!isset($_SESSION['username']) || $_SESSION['rol'] != 'administrador') {
    header("Location: ../login.php");
    exit();
}

include '../includes/db.php';

// Configurar conexión para usar UTF-8
$conn->set_charset("utf8mb4");
$conn->query("SET NAMES 'utf8mb4'");
$conn->query("SET CHARACTER SET utf8mb4");
$conn->query("SET COLLATION_CONNECTION = 'utf8mb4_unicode_ci'");

// Validar parámetros
if (!isset($_GET['tabla']) || !isset($_GET['id'])) {
    header("Location: gestion_datos_fijos.php");
    exit();
}

$tabla = $_GET['tabla'];
$id = intval($_GET['id']);

// Validar tabla permitida - CORREGIDO: usar anios_lectivos en lugar de años_lectivos
$tablas_permitidas = ['planes', 'promociones', 'escolaridades', 'anios_lectivos', 'secciones'];
if (!in_array($tabla, $tablas_permitidas)) {
    header("Location: gestion_datos_fijos.php");
    exit();
}

// Obtener el dato actual
$sql = "SELECT * FROM $tabla WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$dato = $result->fetch_assoc();

if (!$dato) {
    header("Location: gestion_datos_fijos.php");
    exit();
}

// Procesar actualización
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['actualizar'])) {
    $nombre = trim($_POST['nombre']);
    
    if (!empty($nombre)) {
        $sql = "UPDATE $tabla SET nombre = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("si", $nombre, $id);
        
        if ($stmt->execute()) {
            $_SESSION['success'] = "Registro actualizado correctamente";
            header("Location: gestion_datos_fijos.php");
            exit();
        } else {
            $error = "Error al actualizar registro: " . $conn->error;
        }
    } else {
        $error = "El nombre no puede estar vacío";
    }
}

// Traducción de nombres de tablas para mostrar - CORREGIDO: usar anios_lectivos
$nombres_tablas = [
    'planes' => 'Plan',
    'promociones' => 'Promoción',
    'escolaridades' => 'Escolaridad',
    'anios_lectivos' => 'Año Lectivo',
    'secciones' => 'Sección'
];
$nombre_tabla = $nombres_tablas[$tabla];

$page_title = "Editar $nombre_tabla";
include '../includes/header.php';
?>

<div class="container">
    <!-- Botón para volver -->
    <div class="mb-4">
        <a href="gestion_datos_fijos.php" class="btn btn-secondary">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-left" viewBox="0 0 16 16">
                <path fill-rule="evenodd" d="M15 8a.5.5 0 0 0-.5-.5H2.707l3.147-3.146a.5.5 0 1 0-.708-.708l-4 4a.5.5 0 0 0 0 .708l4 4a.5.5 0 0 0 .708-.708L2.707 8.5H14.5A.5.5 0 0 0 15 8z"/>
            </svg>
            Volver a Gestión de Datos
        </a>
    </div>

    <?php if (isset($error)): ?>
        <div class="alert alert-danger"><?= $error ?></div>
    <?php endif; ?>

    <div class="card">
        <div class="card-header bg-primary text-white">
            <h3 class="mb-0">Editar <?= $nombre_tabla ?></h3>
        </div>
        <div class="card-body">
            <form method="post">
                <div class="mb-3">
                    <label for="nombre" class="form-label">Nombre:</label>
                    <input type="text" class="form-control" id="nombre" name="nombre" 
                           value="<?= htmlspecialchars($dato['nombre']) ?>" required>
                </div>
                <button type="submit" name="actualizar" class="btn btn-primary">Actualizar</button>
            </form>
        </div>
    </div>
</div>

<?php
include '../includes/footer.php';
$conn->close();
?>