<?php
session_start();

// Configurar encoding UTF-8
header('Content-Type: text/html; charset=utf-8');
mb_internal_encoding('UTF-8');

if (!isset($_SESSION['username']) || $_SESSION['rol'] != 'administrador') {
    header("Location: ../login.php");
    exit();
}

include '../includes/db.php';

// Configurar conexión para usar UTF-8
$conn->set_charset("utf8mb4");
$conn->query("SET NAMES 'utf8mb4'");
$conn->query("SET CHARACTER SET utf8mb4");
$conn->query("SET COLLATION_CONNECTION = 'utf8mb4_unicode_ci'");

// Obtener ID de la asignación a editar
$asignacion_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Validar ID
if ($asignacion_id <= 0) {
    $_SESSION['error'] = "ID de asignación inválido";
    header("Location: asignar_postgrados.php");
    exit();
}

// Obtener datos de la asignación
$sql = "SELECT cp.id, cp.coordinador_id, cp.postgrado_id, 
               u.username AS coordinador, p.nombre AS postgrado
        FROM coordinador_postgrado cp
        JOIN usuarios u ON cp.coordinador_id = u.id
        JOIN postgrados p ON cp.postgrado_id = p.id
        WHERE cp.id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $asignacion_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    $_SESSION['error'] = "Asignación no encontrada";
    header("Location: asignar_postgrados.php");
    exit();
}

$asignacion = $result->fetch_assoc();

// Obtener lista de coordinadores y postgrados para los selects
$sql_coordinadores = "SELECT id, username FROM usuarios WHERE rol = 'coordinador2' ORDER BY username";
$coordinadores = $conn->query($sql_coordinadores);

$sql_postgrados = "SELECT id, nombre FROM postgrados ORDER BY nombre";
$postgrados = $conn->query($sql_postgrados);

// Procesar formulario de actualización
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['actualizar_asignacion'])) {
    $nuevo_coordinador_id = intval($_POST['coordinador_id']);
    $nuevo_postgrado_id = intval($_POST['postgrado_id']);

    // Validar que no exista ya esta asignación
    $sql_check = "SELECT 1 FROM coordinador_postgrado 
                 WHERE coordinador_id = ? AND postgrado_id = ? AND id != ?";
    $stmt = $conn->prepare($sql_check);
    $stmt->bind_param("iii", $nuevo_coordinador_id, $nuevo_postgrado_id, $asignacion_id);
    $stmt->execute();
    
    if ($stmt->get_result()->num_rows > 0) {
        $_SESSION['error'] = "Esta asignación ya existe";
    } else {
        $sql_update = "UPDATE coordinador_postgrado 
                      SET coordinador_id = ?, postgrado_id = ?
                      WHERE id = ?";
        $stmt = $conn->prepare($sql_update);
        $stmt->bind_param("iii", $nuevo_coordinador_id, $nuevo_postgrado_id, $asignacion_id);
        
        if ($stmt->execute()) {
            $_SESSION['success'] = "Asignación actualizada correctamente";
            header("Location: asignar_postgrados.php");
            exit();
        } else {
            $_SESSION['error'] = "Error al actualizar la asignación";
        }
    }
}

$page_title = "Editar Asignación";
include '../includes/header.php';
?>

<div class="container">
    <!-- Botón para volver -->
    <div class="mb-4">
        <a href="asignar_postgrados.php" class="btn btn-secondary">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-left" viewBox="0 0 16 16">
                <path fill-rule="evenodd" d="M15 8a.5.5 0 0 0-.5-.5H2.707l3.147-3.146a.5.5 0 1 0-.708-.708l-4 4a.5.5 0 0 0 0 .708l4 4a.5.5 0 0 0 .708-.708L2.707 8.5H14.5A.5.5 0 0 0 15 8z"/>
            </svg>
            Volver a la lista
        </a>
    </div>

    <?php if (isset($_SESSION['error'])): ?>
        <div class="alert alert-danger"><?= $_SESSION['error'] ?></div>
        <?php unset($_SESSION['error']); ?>
    <?php endif; ?>

    <div class="card mb-4">
        <div class="card-header bg-light">
            <h5 class="mb-0">Asignación actual</h5>
        </div>
        <div class="card-body">
            <p class="mb-1"><strong>Coordinador:</strong> <?= htmlspecialchars($asignacion['coordinador']) ?></p>
            <p class="mb-0"><strong>Postgrado:</strong> <?= htmlspecialchars($asignacion['postgrado']) ?></p>
        </div>
    </div>

    <div class="card">
        <div class="card-header bg-primary text-white">
            <h3 class="mb-0">Editar Asignación</h3>
        </div>
        <div class="card-body">
            <form method="post">
                <div class="mb-3">
                    <label for="coordinador_id" class="form-label">Nuevo Coordinador:</label>
                    <select class="form-select" id="coordinador_id" name="coordinador_id" required>
                        <option value="">-- Seleccione un coordinador --</option>
                        <?php while ($coordinador = $coordinadores->fetch_assoc()): ?>
                            <option value="<?= $coordinador['id'] ?>" <?= $asignacion['coordinador_id'] == $coordinador['id'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($coordinador['username']) ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
                
                <div class="mb-3">
                    <label for="postgrado_id" class="form-label">Nuevo Postgrado:</label>
                    <select class="form-select" id="postgrado_id" name="postgrado_id" required>
                        <option value="">-- Seleccione un postgrado --</option>
                        <?php while ($postgrado = $postgrados->fetch_assoc()): ?>
                            <option value="<?= $postgrado['id'] ?>" <?= $asignacion['postgrado_id'] == $postgrado['id'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($postgrado['nombre']) ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
                
                <div class="d-flex justify-content-between">
                    <button type="submit" name="actualizar_asignacion" class="btn btn-primary">Actualizar Asignación</button>
                    <a href="asignar_postgrados.php" class="btn btn-danger">Cancelar</a>
                </div>
            </form>
        </div>
    </div>
</div>

<?php
include '../includes/footer.php';
$conn->close();
?>