<?php
session_start();

// Configurar encoding UTF-8
header('Content-Type: text/html; charset=utf-8');
mb_internal_encoding('UTF-8');

if (!isset($_SESSION['username']) || $_SESSION['rol'] != 'administrador') {
    header("Location: ../login.php");
    exit();
}

include '../includes/db.php';

// Configurar conexión para usar UTF-8
$conn->set_charset("utf8mb4");
$conn->query("SET NAMES 'utf8mb4'");
$conn->query("SET CHARACTER SET utf8mb4");
$conn->query("SET COLLATION_CONNECTION = 'utf8mb4_unicode_ci'");

if (!isset($_GET['id'])) {
    header("Location: gestion_inscripciones.php");
    exit();
}

$estudiante_id = intval($_GET['id']);

// Obtener datos del estudiante
$sql_estudiante = "SELECT * FROM estudiantes WHERE id = $estudiante_id";
$result_estudiante = $conn->query($sql_estudiante);

if ($result_estudiante->num_rows == 0) {
    echo "<p>Estudiante no encontrado.</p>";
    exit();
}

$estudiante = $result_estudiante->fetch_assoc();

// Obtener las inscripciones del estudiante
$sql_inscripciones = "SELECT i.id, d.nombre AS denominacion, pl.nombre AS plan, es.nombre AS escolaridad,
                      al.nombre AS año_lectivo, s.nombre AS seccion, i.nota_final, i.nota_definitiva, i.fecha_inscripcion, i.estado
                      FROM inscripciones i
                      JOIN denominaciones d ON i.denominacion_id = d.id
                      JOIN planes pl ON d.plan_id = pl.id
                      JOIN escolaridades es ON i.escolaridad_id = es.id
                      JOIN años_lectivos al ON i.año_lectivo_id = al.id
                      JOIN secciones s ON i.seccion_id = s.id
                      WHERE i.estudiante_id = $estudiante_id";

$result_inscripciones = $conn->query($sql_inscripciones);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Detalle del Estudiante</title>
    <link rel="stylesheet" href="../css/styles.css">
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #000;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
    </style>
</head>
<body>
    <h1>Detalle del Estudiante</h1>
    <a href="gestion_inscripciones.php">Volver a la lista</a>

    <h2>Datos del Estudiante</h2>
    <table>
        <tr>
            <th>Cédula</th>
            <th>Nombres</th>
            <th>Apellidos</th>
            <th>Correo</th>
            <th>Teléfono</th>
            <th>Celular</th>
            <th>Dirección</th>
        </tr>
        <tr>
            <td><?php echo $estudiante['cedula']; ?></td>
            <td><?php echo $estudiante['nombres']; ?></td>
            <td><?php echo $estudiante['apellidos']; ?></td>
            <td><?php echo $estudiante['correo']; ?></td>
            <td><?php echo $estudiante['telefono']; ?></td>
            <td><?php echo $estudiante['celular']; ?></td>
            <td><?php echo $estudiante['direccion']; ?></td>
        </tr>
    </table>

    <h2>Materias Inscritas</h2>
    <table>
        <tr>
            <th>Denominación</th>
            <th>Plan</th>
            <th>Escolaridad</th>
            <th>Año Lectivo</th>
            <th>Sección</th>
            <th>Nota Final</th>
            <th>Nota Definitiva</th>
            <th>Fecha Inscripción</th>
            <th>Estado</th>
        </tr>
        <?php
        if ($result_inscripciones->num_rows > 0) {
            while ($row = $result_inscripciones->fetch_assoc()) {
                echo "<tr>
                        <td>{$row['denominacion']}</td>
                        <td>{$row['plan']}</td>
                        <td>{$row['escolaridad']}</td>
                        <td>{$row['año_lectivo']}</td>
                        <td>{$row['seccion']}</td>
                        <td>" . (isset($row['nota_final']) ? $row['nota_final'] : 'Sin nota') . "</td>
                        <td>" . (isset($row['nota_definitiva']) ? $row['nota_definitiva'] : 'Sin nota') . "</td>
                        <td>{$row['fecha_inscripcion']}</td>
                        <td>{$row['estado']}</td>
                      </tr>";
            }
        } else {
            echo "<tr><td colspan='9'>No hay materias inscritas.</td></tr>";
        }
        ?>
    </table>
</body>
</html>