<?php
session_start();

if (!isset($_SESSION['username']) || $_SESSION['rol'] != 'administrador') {
    header("Location: ../login.php");
    exit();
}

include '../includes/db.php';

// Configurar conexión para usar UTF-8
$conn->set_charset("utf8mb4");
$conn->query("SET NAMES 'utf8mb4'");
$conn->query("SET CHARACTER SET utf8mb4");
$conn->query("SET COLLATION_CONNECTION = 'utf8mb4_unicode_ci'");

// Obtener las firmas actuales
$sql_firmas = "SELECT * FROM firmas_constancia ORDER BY id";
$result_firmas = $conn->query($sql_firmas);
$firmas = $result_firmas->fetch_all(MYSQLI_ASSOC);

// Procesar el formulario para actualizar las firmas
if (isset($_POST['guardar_firmas'])) {
    // Eliminar las firmas existentes
    $conn->query("DELETE FROM firmas_constancia");

    // Insertar las nuevas firmas
    $nombres = $_POST['nombre'];
    $cargos = $_POST['cargo'];

    $stmt = $conn->prepare("INSERT INTO firmas_constancia (nombre, cargo) VALUES (?, ?)");
    
    for ($i = 0; $i < count($nombres); $i++) {
        $nombre = trim($nombres[$i]);
        $cargo = trim($cargos[$i]);
        
        if (!empty($nombre) && !empty($cargo)) {
            $stmt->bind_param("ss", $nombre, $cargo);
            $stmt->execute();
        }
    }

    $_SESSION['success'] = "Firmas actualizadas correctamente";
    header("Location: configurar_firmas.php");
    exit();
}

$page_title = "Configurar Firmas";
include '../includes/header.php';
?>

<div class="container">
    <!-- Botón para volver -->
    <div class="mb-4">
        <a href="../admin/index.php" class="btn btn-secondary">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-left" viewBox="0 0 16 16">
                <path fill-rule="evenodd" d="M15 8a.5.5 0 0 0-.5-.5H2.707l3.147-3.146a.5.5 0 1 0-.708-.708l-4 4a.5.5 0 0 0 0 .708l4 4a.5.5 0 0 0 .708-.708L2.707 8.5H14.5A.5.5 0 0 0 15 8z"/>
            </svg>
            Volver al Menú
        </a>
    </div>

    <?php if (isset($_SESSION['success'])): ?>
        <div class="alert alert-success"><?= $_SESSION['success'] ?></div>
        <?php unset($_SESSION['success']); ?>
    <?php endif; ?>

    <div class="card">
        <div class="card-header bg-primary text-white">
            <h3 class="mb-0">Configurar Firmas para Constancias</h3>
        </div>
        <div class="card-body">
            <form method="post">
                <div class="row g-3">
                    <?php 
                    // Inicializar array con 4 elementos vacíos si no hay firmas
                    $firmas_mostrar = $firmas;
                    for ($i = count($firmas_mostrar); $i < 4; $i++) {
                        $firmas_mostrar[] = ['nombre' => '', 'cargo' => ''];
                    }
                    
                    for ($i = 0; $i < 4; $i++): 
                        $firma = $firmas_mostrar[$i] ?? ['nombre' => '', 'cargo' => ''];
                    ?>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="nombre_<?= $i ?>" class="form-label"><strong>Nombre <?= $i + 1 ?></strong></label>
                                <input type="text" class="form-control" id="nombre_<?= $i ?>" 
                                       name="nombre[]" value="<?= htmlspecialchars($firma['nombre'], ENT_QUOTES, 'UTF-8') ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="cargo_<?= $i ?>" class="form-label"><strong>Cargo <?= $i + 1 ?></strong></label>
                                <input type="text" class="form-control" id="cargo_<?= $i ?>" 
                                       name="cargo[]" value="<?= htmlspecialchars($firma['cargo'], ENT_QUOTES, 'UTF-8') ?>" required>
                            </div>
                        </div>
                    <?php endfor; ?>
                </div>
                
                <div class="mt-4">
                    <button type="submit" name="guardar_firmas" class="btn btn-primary">Guardar Firmas</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php
include '../includes/footer.php';
$conn->close();
?>