<?php
session_start();
// Verificar si el usuario está logueado y es administrador
if (!isset($_SESSION['username']) || $_SESSION['rol'] != 'administrador') {
    http_response_code(403);
    echo json_encode(['error' => 'Acceso no autorizado.']);
    exit();
}

include '../../includes/db.php'; // RUTA CORREGIDA AQUÍ

$coordinador_id = filter_input(INPUT_GET, 'coordinador_id', FILTER_VALIDATE_INT);
$postgrado_id = filter_input(INPUT_GET, 'postgrado_id', FILTER_VALIDATE_INT);

$all_escolaridades = [];
$assigned_escolaridad_ids = [];

if ($coordinador_id && $postgrado_id) {
    // Obtener todas las escolaridades disponibles
    $sql_all = "SELECT id, nombre FROM escolaridades ORDER BY nombre";
    $result_all = $conn->query($sql_all);
    while ($row = $result_all->fetch_assoc()) {
        $all_escolaridades[] = $row;
    }

    // Obtener las escolaridades ya asignadas a este coordinador y postgrado
    $sql_assigned = "SELECT escolaridad_id 
                     FROM coordinador_postgrado_escolaridad 
                     WHERE coordinador_id = ? AND postgrado_id = ?";
    $stmt_assigned = $conn->prepare($sql_assigned);
    $stmt_assigned->bind_param("ii", $coordinador_id, $postgrado_id);
    $stmt_assigned->execute();
    $result_assigned = $stmt_assigned->get_result();
    while ($row = $result_assigned->fetch_assoc()) {
        $assigned_escolaridad_ids[] = (int)$row['escolaridad_id'];
    }
    $stmt_assigned->close();
}

header('Content-Type: application/json');
echo json_encode([
    'all_escolaridades' => $all_escolaridades,
    'assigned_escolaridad_ids' => $assigned_escolaridad_ids
]);

$conn->close();
?>