<?php
// test_email.php - Archivo temporal para probar la configuración

// Definir la ruta base
define('BASE_PATH', dirname(__FILE__));

echo "<h2>Probando configuración de correo...</h2>";

// Verificar si vendor/autoload.php existe
$vendorPath = BASE_PATH . '/vendor/autoload.php';
if (!file_exists($vendorPath)) {
    die("<p style='color: red;'>❌ Error: No se encuentra vendor/autoload.php en: " . $vendorPath . "</p>");
}

// Verificar si config/mail_config.php existe
$configPath = BASE_PATH . '/config/mail_config.php';
if (!file_exists($configPath)) {
    die("<p style='color: red;'>❌ Error: No se encuentra config/mail_config.php en: " . $configPath . "</p>");
}

// Cargar PHPMailer
require $vendorPath;

// Cargar configuración
require $configPath;

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

echo "<p>✅ Archivos cargados correctamente</p>";
echo "<p>Host: " . MAIL_HOST . "</p>";
echo "<p>Usuario: " . MAIL_USERNAME . "</p>";
echo "<p>Puerto: " . MAIL_PORT . "</p>";
echo "<p>Encriptación: " . MAIL_ENCRYPTION . "</p>";

try {
    $mail = new PHPMailer(true);
    
    // Configuración SMTP
    $mail->isSMTP();
    $mail->Host = MAIL_HOST;
    $mail->SMTPAuth = true;
    $mail->Username = MAIL_USERNAME;
    $mail->Password = MAIL_PASSWORD;
    $mail->SMTPSecure = MAIL_ENCRYPTION;
    $mail->Port = MAIL_PORT;
    $mail->Timeout = 30;
    $mail->SMTPDebug = 2; // Ver detalles completos
    
    // Configurar para capturar el output del debug
    $mail->Debugoutput = function($str, $level) {
        echo "<div style='background: #f0f0f0; padding: 5px; margin: 2px; font-family: monospace;'>Debug $level: $str</div>";
    };

    // Remitente y destinatario
    $mail->setFrom(MAIL_FROM_EMAIL, MAIL_FROM_NAME);
    $mail->addAddress(MAIL_USERNAME, 'Usuario Prueba');
    
    // Contenido
    $mail->Subject = 'Prueba de correo - Sistema Postgrado - ' . date('Y-m-d H:i:s');
    $mail->Body = 'Este es un correo de prueba del Sistema de Postgrado Medicina UCV';
    $mail->AltBody = 'Este es un correo de prueba del Sistema de Postgrado Medicina UCV';
    
    echo "<p>📧 Intentando enviar correo...</p>";
    
    if ($mail->send()) {
        echo "<p style='color: green; font-weight: bold;'>✅ Correo enviado EXITOSAMENTE</p>";
    } else {
        echo "<p style='color: red; font-weight: bold;'>❌ Error al enviar correo</p>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red; font-weight: bold;'>❌ Excepción: " . $e->getMessage() . "</p>";
}

echo "<hr><h3>Información del servidor:</h3>";
echo "<p>PHP Version: " . phpversion() . "</p>";
echo "<p>Server: " . $_SERVER['SERVER_SOFTWARE'] . "</p>";
echo "<p>OpenSSL: " . (extension_loaded('openssl') ? '✅ Habilitado' : '❌ Deshabilitado') . "</p>";
?>