<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include '../includes/db.php';

// Verificar sesión
if (!isset($_SESSION['username'])) {
    die("No hay sesión activa. Redirigiendo al login...");
}

echo "<h2>DEBUG COMPLETO - Verificación de Retiro de Estudiantes</h2>";

// Verificar conexión a la base de datos
if ($conn->connect_error) {
    die("Error de conexión: " . $conn->connect_error);
} else {
    echo "<p style='color: green;'>✅ Conexión a la base de datos exitosa</p>";
}

// Verificar información del usuario
echo "<h3>Información del Usuario</h3>";
echo "<p>Usuario: " . $_SESSION['username'] . "</p>";
echo "<p>Rol: " . $_SESSION['rol'] . "</p>";
echo "<p>ID: " . $_SESSION['user_id'] . "</p>";

// Verificar tablas necesarias y su estructura
$tablas_necesarias = ['estudiantes', 'estudiante_postgrado', 'retiros_estudiantes'];
foreach ($tablas_necesarias as $tabla) {
    $result = $conn->query("SHOW TABLES LIKE '$tabla'");
    if ($result->num_rows > 0) {
        echo "<p style='color: green;'>✅ Tabla '$tabla' existe</p>";
        
        // Mostrar estructura de la tabla
        $result_columns = $conn->query("DESCRIBE $tabla");
        echo "<details><summary>Estructura de $tabla</summary><ul>";
        while ($columna = $result_columns->fetch_assoc()) {
            echo "<li>{$columna['Field']} - {$columna['Type']}";
            if ($columna['Key'] == 'PRI') echo " (PRIMARY KEY)";
            echo "</li>";
        }
        echo "</ul></details>";
        
        // Mostrar algunos datos de ejemplo
        if ($tabla == 'estudiante_postgrado') {
            $ejemplo = $conn->query("SELECT * FROM $tabla WHERE estado = 'activo' LIMIT 3");
            echo "<details><summary>Datos de ejemplo (activos)</summary><ul>";
            while ($fila = $ejemplo->fetch_assoc()) {
                echo "<li>ID: {$fila['id']}, Estudiante_ID: {$fila['estudiante_id']}, Postgrado_ID: {$fila['postgrado_id']}, Estado: {$fila['estado']}</li>";
            }
            echo "</ul></details>";
        }
    } else {
        echo "<p style='color: red;'>❌ Tabla '$tabla' NO existe</p>";
    }
}

// Probar consulta específica
echo "<h3>Prueba de Consulta de Estudiantes Activos</h3>";
$sql_test = "SELECT ep.id as ep_id, ep.estudiante_id, ep.postgrado_id, ep.estado, 
             e.cedula, e.nombres, e.apellidos, 
             p.nombre as postgrado_nombre
             FROM estudiante_postgrado ep
             JOIN estudiantes e ON ep.estudiante_id = e.id
             JOIN postgrados p ON ep.postgrado_id = p.id
             WHERE ep.estado = 'activo' LIMIT 5";
$result_test = $conn->query($sql_test);

if ($result_test) {
    echo "<p style='color: green;'>✅ Consulta exitosa</p>";
    echo "<table border='1'><tr><th>EP ID</th><th>Est ID</th><th>Post ID</th><th>Cédula</th><th>Nombre</th><th>Postgrado</th><th>Estado</th></tr>";
    while ($row = $result_test->fetch_assoc()) {
        echo "<tr>
                <td>{$row['ep_id']}</td>
                <td>{$row['estudiante_id']}</td>
                <td>{$row['postgrado_id']}</td>
                <td>{$row['cedula']}</td>
                <td>{$row['nombres']} {$row['apellidos']}</td>
                <td>{$row['postgrado_nombre']}</td>
                <td>{$row['estado']}</td>
              </tr>";
    }
    echo "</table>";
} else {
    echo "<p style='color: red;'>❌ Error en consulta: " . $conn->error . "</p>";
}

// Probar actualización directa
echo "<h3>Prueba de Actualización Directa</h3>";
$test_estudiante_id = 2; // Usar un ID que exista según la consulta anterior
$test_postgrado_id = 1; // Usar un ID que exista

// Primero verificar que existe
$sql_check = "SELECT * FROM estudiante_postgrado WHERE estudiante_id = $test_estudiante_id AND postgrado_id = $test_postgrado_id AND estado = 'activo'";
$result_check = $conn->query($sql_check);

if ($result_check->num_rows > 0) {
    echo "<p style='color: green;'>✅ Estudiante activo encontrado para prueba</p>";
    
    // Probar actualización
    $sql_update = "UPDATE estudiante_postgrado SET estado = 'retirado' WHERE estudiante_id = $test_estudiante_id AND postgrado_id = $test_postgrado_id";
    if ($conn->query($sql_update)) {
        echo "<p style='color: green;'>✅ Actualización exitosa - Estado cambiado a 'retirado'</p>";
        
        // Revertir el cambio para no afectar datos reales
        $conn->query("UPDATE estudiante_postgrado SET estado = 'activo' WHERE estudiante_id = $test_estudiante_id AND postgrado_id = $test_postgrado_id");
        echo "<p style='color: blue;'>ℹ️ Cambio revertido para mantener integridad de datos</p>";
    } else {
        echo "<p style='color: red;'>❌ Error en actualización: " . $conn->error . "</p>";
    }
} else {
    echo "<p style='color: orange;'>⚠️ No se encontró estudiante activo para probar la actualización</p>";
}

$conn->close();
?>