<?php
// reporte_preview.php - VERSIÓN FINAL CON ENCODING CORREGIDO

// Asegurarnos de que todas las variables necesarias estén definidas
if (!isset($año_lectivo_general)) {
    $año_lectivo_general = '2023-2024';
}

// Verificar que tenemos datos
if (empty($denominaciones)) {
    die("No hay asignaturas para mostrar");
}

if (empty($estudiantes)) {
    die("No hay estudiantes para mostrar");
}

// Función para corregir encoding
function corregirEncoding($texto) {
    // Intentar detectar y corregir problemas de encoding
    if (mb_detect_encoding($texto, 'UTF-8', true) === false) {
        return utf8_encode($texto);
    }
    return $texto;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Previsualización del Reporte</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .preview-container { max-width: 100%; overflow-x: auto; margin-bottom: 20px; }
        table { border-collapse: collapse; width: 100%; margin: 20px 0; }
        th, td { border: 1px solid #000000; padding: 8px; text-align: center; }
        th { background-color: #f2f2f2; font-weight: bold; }
        .titulo-principal { font-size: 18px; font-weight: bold; text-align: center; margin-bottom: 10px; }
        .titulo-secundario { font-size: 16px; text-align: center; margin-bottom: 20px; }
        .text-left { text-align: left; }
        .text-right { text-align: right; }
        .codigo-postgrado { font-weight: bold; }
        .actions { margin: 20px 0; text-align: center; }
        .btn { padding: 10px 15px; margin: 0 10px; background-color: #4CAF50; color: white; border: none; cursor: pointer; text-decoration: none; display: inline-block; }
        .btn:hover { background-color: #45a049; }
        .btn-download { background-color: #2196F3; }
        .btn-download:hover { background-color: #0b7dda; }
    </style>
</head>
<body>
    <div class="titulo-principal">
        <?= htmlspecialchars(corregirEncoding($postgrado['nombre']), ENT_QUOTES, 'UTF-8') ?>
    </div>
    
    <div class="titulo-secundario">
        PROMOCIÓN: <?= htmlspecialchars(corregirEncoding($postgrado['promocion_nombre'] ?? ''), ENT_QUOTES, 'UTF-8') ?><br>
        AÑO LECTIVO: <?= htmlspecialchars(corregirEncoding($año_lectivo_general), ENT_QUOTES, 'UTF-8') ?><br>
        PLAN: <?= htmlspecialchars(corregirEncoding($postgrado['plan_nombre'] ?? ''), ENT_QUOTES, 'UTF-8') ?>
    </div>
    
    <div class="preview-container">
        <table>
            <!-- Encabezados de columnas -->
            <tr>
                <th rowspan="2" class="codigo-postgrado"><?= htmlspecialchars(corregirEncoding($postgrado['plan_nombre'] ?? ''), ENT_QUOTES, 'UTF-8') ?></th>
                <th rowspan="2">ASIGNATURAS</th>
                <th rowspan="2">CRED</th>
                <th rowspan="2">PER</th>
                <th rowspan="2">AÑO</th>
                <?php foreach($estudiantes as $est): ?>
                <th colspan="1"><?= htmlspecialchars(corregirEncoding(mb_strtoupper($est['apellidos'])), ENT_QUOTES, 'UTF-8') ?><br><?= htmlspecialchars(corregirEncoding(mb_strtoupper($est['nombres'])), ENT_QUOTES, 'UTF-8') ?></th>
                <?php endforeach; ?>
            </tr>
            <tr>
                <?php foreach($estudiantes as $est): ?>
                <th><?= htmlspecialchars(corregirEncoding($est['cedula']), ENT_QUOTES, 'UTF-8') ?></th>
                <?php endforeach; ?>
            </tr>
            
            <!-- Datos de asignaturas -->
            <?php foreach($denominaciones as $den): ?>
            <tr>
                <td class="text-right"><?= htmlspecialchars(corregirEncoding($den['codigo']), ENT_QUOTES, 'UTF-8') ?></td>
                <td class="text-left"><?= htmlspecialchars(corregirEncoding($den['nombre']), ENT_QUOTES, 'UTF-8') ?></td>
                <td><?= htmlspecialchars(corregirEncoding($den['credito']), ENT_QUOTES, 'UTF-8') ?></td>
                <td><?= htmlspecialchars(corregirEncoding($den['periodo']), ENT_QUOTES, 'UTF-8') ?></td>
                <td>
                    <?php 
                    // Buscar el año lectivo para esta asignatura
                    $año_lectivo_asignatura = $año_lectivo_general;
                    
                    foreach($estudiantes as $est) {
                        if(isset($notas[$est['id']])) {
                            foreach($notas[$est['id']] as $nota) {
                                if($nota['denominacion_id'] == $den['id'] && !empty($nota['año_lectivo'])) {
                                    $año_lectivo_asignatura = $nota['año_lectivo'];
                                    break 2;
                                }
                            }
                        }
                    }
                    echo htmlspecialchars(corregirEncoding($año_lectivo_asignatura), ENT_QUOTES, 'UTF-8');
                    ?>
                </td>
                
                <?php foreach($estudiantes as $est): 
                    $nota = 'N/A';
                    
                    if(isset($notas[$est['id']])) {
                        foreach($notas[$est['id']] as $n) {
                            if($n['denominacion_id'] == $den['id']) {
                                $nota = is_numeric($n['nota_definitiva']) ? number_format($n['nota_definitiva'], 0) : $n['nota_definitiva'];
                                if(isset($den['tipo']) && $den['tipo'] == 'Aprobado_Reprobado') {
                                    $nota = ($nota == 'Aprobado') ? 'APROBADO' : $nota;
                                }
                                break;
                            }
                        }
                    }
                ?>
                <td><?= htmlspecialchars(corregirEncoding($nota), ENT_QUOTES, 'UTF-8') ?></td>
                <?php endforeach; ?>
            </tr>
            <?php endforeach; ?>
            
            <!-- Totales y promedios -->
            <tr>
                <td colspan="2" class="text-left"><strong>TOTAL ASIGNATURAS</strong></td>
                <td><?= count($denominaciones) ?></td>
                <td colspan="2">prom. S</td>
                <?php foreach($estudiantes as $est): ?>
                <td><?= isset($promedios[$est['id']]['simple']) ? number_format($promedios[$est['id']]['simple'], 2) : 'N/A' ?></td>
                <?php endforeach; ?>
            </tr>
            
            <tr>
                <td colspan="2" class="text-left"><strong>TOTAL CRÉDITOS</strong></td>
                <td><?= array_sum(array_column($denominaciones, 'credito')) ?></td>
                <td colspan="2">prom. P</td>
                <?php foreach($estudiantes as $est): ?>
                <td><?= isset($promedios[$est['id']]['ponderado']) ? number_format($promedios[$est['id']]['ponderado'], 2) : 'N/A' ?></td>
                <?php endforeach; ?>
            </tr>
        </table>
    </div>
    
    <div class="actions">
        <a href="generar_reporte.php?postgrado_id=<?= $postgrado_id ?>&promocion_id=<?= $promocion_id ?>" class="btn btn-download">Descargar Excel</a>
        <button onclick="window.history.back()" class="btn">Volver</button>
    </div>
</body>
</html>
<?php
// NO cerrar la conexión aquí
?>