<?php
session_start();

if (!isset($_SESSION['username']) || $_SESSION['rol'] != 'administrador') {
    header("Location: ../login.php");
    exit();
}

include '../includes/db.php';
$conn->set_charset("utf8mb4");

// Definir cuatrimestres del sistema
$cuatrimestres = [
    '01C' => '1º Cuatrimestre',
    '02C' => '2º Cuatrimestre', 
    '03C' => '3º Cuatrimestre',
    'TODOS' => 'Todos los Cuatrimestres'
];

// Obtener parámetros de filtro
$escolaridad_id = isset($_GET['escolaridad_id']) ? intval($_GET['escolaridad_id']) : 0;
$postgrado_id = isset($_GET['postgrado_id']) ? intval($_GET['postgrado_id']) : 0;
$usuario_id = isset($_GET['usuario_id']) ? intval($_GET['usuario_id']) : 0;
$cuatrimestre = isset($_GET['cuatrimestre']) ? $_GET['cuatrimestre'] : '';
$anio_lectivo = isset($_GET['anio_lectivo']) ? $_GET['anio_lectivo'] : '';

// Obtener años lectivos disponibles
$sql_anios = "SELECT DISTINCT nombre FROM anios_lectivos ORDER BY nombre DESC";
$anios_lectivos = $conn->query($sql_anios);

// Obtener listas para filtros
$sql_escolaridades = "SELECT id, nombre FROM escolaridades ORDER BY nombre";
$escolaridades = $conn->query($sql_escolaridades);

$sql_postgrados = "SELECT id, nombre FROM postgrados ORDER BY nombre";
$postgrados = $conn->query($sql_postgrados);

$sql_usuarios = "SELECT id, nombres, apellidos, rol FROM usuarios 
                 WHERE rol IN ('coordinador1', 'coordinador2') 
                 ORDER BY nombres";
$usuarios = $conn->query($sql_usuarios);

// Consulta para notas pendientes
$sql_pendientes = "SELECT 
                    e.nombres as estudiante_nombre,
                    e.apellidos as estudiante_apellido,
                    d.codigo as asignatura_codigo,
                    d.nombre as asignatura_nombre,
                    p.nombre as postgrado_nombre,
                    esc.nombre as escolaridad_nombre,
                    al.nombre as año_lectivo,
                    u.nombres as responsable_nombre,
                    u.apellidos as responsable_apellido,
                    u.rol as responsable_rol
                    FROM inscripciones i
                    JOIN estudiantes e ON i.estudiante_id = e.id
                    JOIN denominaciones d ON i.denominacion_id = d.id
                    JOIN postgrados p ON d.postgrado_id = p.id
                    JOIN escolaridades esc ON i.escolaridad_id = esc.id
                    LEFT JOIN años_lectivos al ON i.año_lectivo_id = al.id
                    LEFT JOIN usuarios u ON i.usuario_modificacion = u.id
                    WHERE i.nota_definitiva IS NULL";

$conditions = [];
$params = [];
$types = "";

if ($escolaridad_id > 0) {
    $conditions[] = " i.escolaridad_id = ?";
    $params[] = $escolaridad_id;
    $types .= "i";
}

if ($postgrado_id > 0) {
    $conditions[] = " p.id = ?";
    $params[] = $postgrado_id;
    $types .= "i";
}

if ($usuario_id > 0) {
    $conditions[] = " i.usuario_modificacion = ?";
    $params[] = $usuario_id;
    $types .= "i";
}

// Filtro por año lectivo
if (!empty($anio_lectivo)) {
    $conditions[] = " al.nombre LIKE ?";
    $params[] = $anio_lectivo . '%';
    $types .= "s";
}

// Filtro por cuatrimestre
if (!empty($cuatrimestre) && $cuatrimestre != 'TODOS') {
    $conditions[] = " al.nombre LIKE ?";
    $params[] = '%' . $cuatrimestre;
    $types .= "s";
}

if (!empty($conditions)) {
    $sql_pendientes .= " AND " . implode(" AND ", $conditions);
}

$sql_pendientes .= " ORDER BY p.nombre, esc.nombre, e.apellidos";

$stmt_pendientes = $conn->prepare($sql_pendientes);
if (!empty($params)) {
    $stmt_pendientes->bind_param($types, ...$params);
}
$stmt_pendientes->execute();
$pendientes = $stmt_pendientes->get_result()->fetch_all(MYSQLI_ASSOC);

$page_title = "Reporte de Notas Pendientes";
include '../includes/header.php';
?>

<div class="container-fluid">
    <div class="mb-3">
        <a href="monitoreo_cargas.php" class="btn btn-secondary btn-sm">
            <i class="bi bi-arrow-left"></i> Volver al Monitoreo
        </a>
    </div>

    <div class="card mb-4">
        <div class="card-header bg-warning text-dark">
            <h4 class="mb-0"><i class="bi bi-exclamation-triangle"></i> Reporte de Notas Pendientes</h4>
        </div>
        <div class="card-body">
            <form method="get" class="row g-3">
                <div class="col-md-2">
                    <label class="form-label">Escolaridad:</label>
                    <select name="escolaridad_id" class="form-select">
                        <option value="0">Todas las escolaridades</option>
                        <?php while ($esc = $escolaridades->fetch_assoc()): ?>
                            <option value="<?= $esc['id'] ?>" <?= $escolaridad_id == $esc['id'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($esc['nombre']) ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
                
                <div class="col-md-2">
                    <label class="form-label">Postgrado:</label>
                    <select name="postgrado_id" class="form-select">
                        <option value="0">Todos los postgrados</option>
                        <?php while ($post = $postgrados->fetch_assoc()): ?>
                            <option value="<?= $post['id'] ?>" <?= $postgrado_id == $post['id'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($post['nombre']) ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
                
                <div class="col-md-2">
                    <label class="form-label">Responsable:</label>
                    <select name="usuario_id" class="form-select">
                        <option value="0">Todos los responsables</option>
                        <?php while ($user = $usuarios->fetch_assoc()): ?>
                            <option value="<?= $user['id'] ?>" <?= $usuario_id == $user['id'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($user['nombres'] . ' ' . $user['apellidos'] . ' (' . $user['rol'] . ')') ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
                
                <div class="col-md-2">
                    <label class="form-label">Año Lectivo:</label>
                    <select name="anio_lectivo" class="form-select">
                        <option value="">Todos los años</option>
                        <?php while ($anio = $anios_lectivos->fetch_assoc()): ?>
                            <option value="<?= htmlspecialchars($anio['nombre']) ?>" <?= $anio_lectivo == $anio['nombre'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($anio['nombre']) ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
                
                <div class="col-md-2">
                    <label class="form-label">Cuatrimestre:</label>
                    <select name="cuatrimestre" class="form-select">
                        <?php foreach ($cuatrimestres as $key => $value): ?>
                            <option value="<?= $key ?>" <?= $cuatrimestre == $key ? 'selected' : '' ?>>
                                <?= htmlspecialchars($value) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="col-md-2 d-flex align-items-end">
                    <button type="submit" class="btn btn-warning w-100">Filtrar Pendientes</button>
                </div>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-header bg-danger text-white">
            <h5 class="mb-0">
                <i class="bi bi-list"></i> 
                Notas Pendientes de Cargar: <?= count($pendientes) ?> registro(s)
            </h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-hover">
                    <thead>
                        <tr>
                            <th>Estudiante</th>
                            <th>Asignatura</th>
                            <th>Postgrado</th>
                            <th>Escolaridad</th>
                            <th>Año/Cuatrimestre</th>
                            <th>Responsable</th>
                            <th>Estado</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($pendientes as $pendiente): ?>
                            <tr>
                                <td>
                                    <strong><?= htmlspecialchars($pendiente['estudiante_nombre'] . ' ' . $pendiente['estudiante_apellido']) ?></strong>
                                </td>
                                <td>
                                    <small class="text-muted"><?= htmlspecialchars($pendiente['asignatura_codigo']) ?></small><br>
                                    <?= htmlspecialchars($pendiente['asignatura_nombre']) ?>
                                </td>
                                <td><?= htmlspecialchars($pendiente['postgrado_nombre']) ?></td>
                                <td>
                                    <span class="badge bg-info"><?= htmlspecialchars($pendiente['escolaridad_nombre']) ?></span>
                                </td>
                                <td><?= htmlspecialchars($pendiente['año_lectivo']) ?></td>
                                <td>
                                    <?php if (!empty($pendiente['responsable_nombre'])): ?>
                                        <small><?= htmlspecialchars($pendiente['responsable_nombre'] . ' ' . $pendiente['responsable_apellido']) ?></small>
                                        <br><span class="badge bg-secondary"><?= htmlspecialchars($pendiente['responsable_rol']) ?></span>
                                    <?php else: ?>
                                        <span class="text-muted">No asignado</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <span class="badge bg-danger">PENDIENTE</span>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            
            <?php if (empty($pendientes)): ?>
                <div class="alert alert-success text-center">
                    <i class="bi bi-check-circle"></i> ¡Excelente! No hay notas pendientes con los filtros aplicados.
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php
include '../includes/footer.php';
$conn->close();
?>