<?php
// reporte_excel.php - VERSIÓN COMPLETAMENTE CORREGIDA
// Configurar headers para Excel
header('Content-Type: application/vnd.ms-excel; charset=utf-8');
header('Content-Disposition: attachment; filename="reporte_'.mb_substr($postgrado['nombre'], 0, 20).'_'.date('Y-m-d').'.xls"');
header('Cache-Control: max-age=0');
header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
header('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
header('Cache-Control: cache, must-revalidate');
header('Pragma: public');

// Asegurarse de que todas las variables necesarias estén definidas
if (!isset($año_lectivo_general)) {
    $año_lectivo_general = '2023-2024';
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <!--[if gte mso 9]>
    <xml>
        <x:ExcelWorkbook>
            <x:ExcelWorksheets>
                <x:ExcelWorksheet>
                    <x:Name>Reporte Postgrado</x:Name>
                    <x:WorksheetOptions>
                        <x:DisplayGridlines/>
                    </x:WorksheetOptions>
                </x:ExcelWorksheet>
            </x:ExcelWorksheets>
        </x:ExcelWorkbook>
    </xml>
    <![endif]-->
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; }
        table { border-collapse: collapse; width: 100%; margin: 0 auto; }
        th, td { border: 1px solid #000000; padding: 5px; text-align: center; vertical-align: middle; }
        th { background-color: #F2F2F2; font-weight: bold; }
        .titulo-principal { font-size: 16px; font-weight: bold; text-align: center; color: #333333; }
        .titulo-secundario { font-size: 14px; font-weight: bold; text-align: center; color: #555555; }
        .text-left { text-align: left; }
        .text-right { text-align: right; }
        .codigo-postgrado { font-weight: bold; }
    </style>
</head>
<body>
<table>
    <!-- Encabezado principal -->
    <tr>
        <th colspan="<?= 5 + count($estudiantes) ?>" class="titulo-principal">
            <?= htmlspecialchars($postgrado['nombre'], ENT_QUOTES, 'UTF-8') ?>
        </th>
    </tr>
    <tr>
        <th colspan="<?= 5 + count($estudiantes) ?>" class="titulo-secundario">
            PROMOCIÓN: <?= htmlspecialchars($postgrado['promocion_nombre'] ?? '', ENT_QUOTES, 'UTF-8') ?><br>
            AÑO LECTIVO: <?= htmlspecialchars($año_lectivo_general, ENT_QUOTES, 'UTF-8') ?><br>
            PLAN: <?= htmlspecialchars($postgrado['plan_nombre'] ?? '', ENT_QUOTES, 'UTF-8') ?>
        </th>
    </tr>
    
    <!-- Encabezados de columnas -->
    <tr>
        <th rowspan="2" class="codigo-postgrado"><?= htmlspecialchars($postgrado['plan_nombre'] ?? '', ENT_QUOTES, 'UTF-8') ?></th>
        <th rowspan="2">ASIGNATURAS</th>
        <th rowspan="2">CRED</th>
        <th rowspan="2">PER</th>
        <th rowspan="2">AÑO</th>
        <?php foreach($estudiantes as $est): ?>
        <th colspan="1"><?= htmlspecialchars(mb_strtoupper($est['apellidos']), ENT_QUOTES, 'UTF-8') ?><br><?= htmlspecialchars(mb_strtoupper($est['nombres']), ENT_QUOTES, 'UTF-8') ?></th>
        <?php endforeach; ?>
    </tr>
    <tr>
        <?php foreach($estudiantes as $est): ?>
        <th><?= htmlspecialchars($est['cedula'], ENT_QUOTES, 'UTF-8') ?></th>
        <?php endforeach; ?>
    </tr>
    
    <!-- Datos de asignaturas -->
    <?php foreach($denominaciones as $den): ?>
    <tr>
        <td class="text-right"><?= htmlspecialchars($den['codigo'], ENT_QUOTES, 'UTF-8') ?></td>
        <td class="text-left"><?= htmlspecialchars($den['nombre'], ENT_QUOTES, 'UTF-8') ?></td>
        <td><?= htmlspecialchars($den['credito'], ENT_QUOTES, 'UTF-8') ?></td>
        <td><?= htmlspecialchars($den['periodo'], ENT_QUOTES, 'UTF-8') ?></td>
        <td>
            <?php 
            // Buscar el año lectivo para esta asignatura
            $año_lectivo_asignatura = $año_lectivo_general;
            
            // Buscar en las notas de todos los estudiantes
            $encontrado = false;
            foreach($estudiantes as $est) {
                if(isset($notas[$est['id']])) {
                    foreach($notas[$est['id']] as $nota) {
                        if($nota['denominacion_id'] == $den['id'] && !empty($nota['año_lectivo'])) {
                            $año_lectivo_asignatura = $nota['año_lectivo'];
                            $encontrado = true;
                            break 2;
                        }
                    }
                }
            }
            
            echo htmlspecialchars($año_lectivo_asignatura, ENT_QUOTES, 'UTF-8');
            ?>
        </td>
        
        <?php foreach($estudiantes as $est): 
            $nota = 'N/A';
            
            if(isset($notas[$est['id']])) {
                foreach($notas[$est['id']] as $n) {
                    if($n['denominacion_id'] == $den['id']) {
                        $nota_valor = $n['nota_definitiva'];
                        
                        if(is_numeric($nota_valor)) {
                            $nota = number_format($nota_valor, 0);
                        } else {
                            $nota = $nota_valor;
                        }
                        
                        if(isset($den['tipo']) && $den['tipo'] == 'Aprobado_Reprobado') {
                            $nota = ($nota_valor >= 70 || $nota_valor == 'Aprobado') ? 'APROBADO' : 'REPROBADO';
                        }
                        break;
                    }
                }
            }
        ?>
        <td><?= htmlspecialchars($nota, ENT_QUOTES, 'UTF-8') ?></td>
        <?php endforeach; ?>
    </tr>
    <?php endforeach; ?>
    
    <!-- Totales y promedios -->
    <tr>
        <td colspan="2" class="text-left"><strong>TOTAL ASIGNATURAS</strong></td>
        <td><?= count($denominaciones) ?></td>
        <td colspan="2">prom. S</td>
        <?php foreach($estudiantes as $est): ?>
        <td><?= isset($promedios[$est['id']]['simple']) ? number_format($promedios[$est['id']]['simple'], 2) : 'N/A' ?></td>
        <?php endforeach; ?>
    </tr>
    
    <tr>
        <td colspan="2" class="text-left"><strong>TOTAL CRÉDITOS</strong></td>
        <td><?= array_sum(array_column($denominaciones, 'credito')) ?></td>
        <td colspan="2">prom. P</td>
        <?php foreach($estudiantes as $est): ?>
        <td><?= isset($promedios[$est['id']]['ponderado']) ? number_format($promedios[$est['id']]['ponderado'], 2) : 'N/A' ?></td>
        <?php endforeach; ?>
    </tr>
</table>
</body>
</html>