<?php
// includes/document_helper.php

function buscarUsuarioPorDocumento($conn, $documento) {
    $sql = "SELECT u.*, 
                   e.nombres as nombres_estudiante, 
                   e.apellidos as apellidos_estudiante,
                   e.correo as correo_estudiante
            FROM usuarios u 
            LEFT JOIN estudiantes e ON u.estudiante_id = e.id 
            WHERE u.cedula_venezolana = ? 
               OR u.cedula_extranjera = ? 
               OR u.pasaporte = ? 
               OR u.username = ?";
    
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        error_log("Error en la consulta de búsqueda por documento: " . $conn->error);
        return false;
    }
    
    $stmt->bind_param('ssss', $documento, $documento, $documento, $documento);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $usuario = $result->fetch_assoc();
        $stmt->close();
        return $usuario;
    }
    
    $stmt->close();
    return false;
}

function obtenerEmailUsuario($usuario) {
    // Para estudiantes, usar correo de la tabla estudiantes
    if (!empty($usuario['estudiante_id']) && !empty($usuario['correo_estudiante'])) {
        return $usuario['correo_estudiante'];
    }
    // Para administrativos, usar email de la tabla usuarios
    return $usuario['email'] ?? null;
}

function obtenerNombreCompletoUsuario($usuario) {
    // Para estudiantes, usar nombres de la tabla estudiantes
    if (!empty($usuario['estudiante_id']) && !empty($usuario['nombres_estudiante'])) {
        return $usuario['nombres_estudiante'] . ' ' . $usuario['apellidos_estudiante'];
    }
    // Para administrativos, usar nombres de la tabla usuarios
    $nombre = trim(($usuario['nombres'] ?? '') . ' ' . ($usuario['apellidos'] ?? ''));
    return !empty($nombre) ? $nombre : $usuario['username'];
}
?>