<?php
/**
 * auth_check.php - CORREGIDO
 */
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// 1. Cargar configuración PRIMERO
require_once __DIR__ . '/session_config.php';

// 2. Verificar si el usuario está logueado
if (!isset($_SESSION['user_id'])) {
    $_SESSION['redirect_url'] = $_SERVER['REQUEST_URI'];
    header("Location: " . BASE_URL . "/login.php?error=session_required");
    exit();
}

// 3. Lógica de expiración de sesión por inactividad
$session_duration = $_SESSION['app_settings']['session_duration'] ?? 3600;
$session_never_expire = $_SESSION['app_settings']['session_never_expire'] ?? '0';

// VERIFICACIÓN MEJORADA - respetar "nunca expira"
if ($session_never_expire !== '1' && isset($_SESSION['LAST_ACTIVITY'])) {
    if ((time() - $_SESSION['LAST_ACTIVITY']) > $session_duration) {
        session_unset();
        session_destroy();
        header("Location: " . BASE_URL . "/login.php?error=session_expired");
        exit();
    }
}

// Actualizar tiempo de última actividad
$_SESSION['LAST_ACTIVITY'] = time();

// 4. Verificar si se requiere un rol específico
if (isset($allowed_roles) && is_array($allowed_roles)) {
    $user_rol = $_SESSION['rol'] ?? null;
    if (!in_array($user_rol, $allowed_roles)) {
        http_response_code(403);
        $page_title = "Acceso Denegado";
        include __DIR__ . '/header.php';
        echo '<div class="container mt-5">';
        echo '<div class="alert alert-danger text-center">';
        echo '<h4><i class="fas fa-exclamation-triangle"></i> Acceso Denegado</h4>';
        echo '<p>No tienes los permisos necesarios para acceder a esta página.</p>';
        echo '<a href="' . BASE_URL . '/index.php" class="btn btn-primary">Volver al Inicio</a>';
        echo '</div>';
        echo '</div>';
        include __DIR__ . '/footer.php';
        exit();
    }
}
?>