<?php
session_start();
include '../includes/db.php';

// Verificar sesión y rol
if (!isset($_SESSION['username']) || $_SESSION['rol'] != 'coordinador2') {
    header("Location: ../login.php");
    exit();
}

// Verificar conexión a la base de datos
if ($conn->connect_error) {
    die("Error de conexión: " . $conn->connect_error);
}

$page_title = "Registrar Nuevo Estudiante";

// Procesar formulario de registro
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $cedula = trim($_POST['cedula']);
    $nombres = trim($_POST['nombres']);
    $apellidos = trim($_POST['apellidos']);
    $correo = trim($_POST['correo']);
    $telefono = trim($_POST['telefono']);
    $celular = trim($_POST['celular']);
    $direccion = trim($_POST['direccion']);

    // Validar datos
    $errors = [];
    
    if (empty($cedula)) {
        $errors[] = "La cédula es obligatoria";
    } elseif (!preg_match('/^[0-9]+$/', $cedula)) {
        $errors[] = "La cédula solo debe contener números";
    } else {
        // Verificar si la cédula ya existe
        $sql_verificar = "SELECT id FROM estudiantes WHERE cedula = ?";
        $stmt_verificar = $conn->prepare($sql_verificar);
        $stmt_verificar->bind_param("s", $cedula);
        $stmt_verificar->execute();
        $result_verificar = $stmt_verificar->get_result();
        
        if ($result_verificar->num_rows > 0) {
            $errors[] = "Ya existe un estudiante con esta cédula";
        }
    }

    if (empty($nombres)) {
        $errors[] = "Los nombres son obligatorios";
    }

    if (empty($apellidos)) {
        $errors[] = "Los apellidos son obligatorios";
    }

    if (!empty($correo) && !filter_var($correo, FILTER_VALIDATE_EMAIL)) {
        $errors[] = "El correo electrónico no es válido";
    }

    // Si no hay errores, insertar el estudiante
    if (empty($errors)) {
        $sql_insert = "INSERT INTO estudiantes (cedula, nombres, apellidos, correo, telefono, celular, direccion) 
                      VALUES (?, ?, ?, ?, ?, ?, ?)";
        $stmt_insert = $conn->prepare($sql_insert);
        $stmt_insert->bind_param("sssssss", $cedula, $nombres, $apellidos, $correo, $telefono, $celular, $direccion);
        
        if ($stmt_insert->execute()) {
            $estudiante_id = $stmt_insert->insert_id;
            
            // Redirigir a la página de inscripción con el ID del nuevo estudiante
            $_SESSION['success'] = "Estudiante registrado exitosamente";
            header("Location: inscripcion.php?estudiante_id=" . $estudiante_id);
            exit();
        } else {
            $errors[] = "Error al registrar el estudiante: " . $conn->error;
        }
    }
}

include '../includes/header.php';
?>

<div class="container">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Registrar Nuevo Estudiante</h2>
        <div>
            <a href="inscripcion.php" class="btn btn-secondary">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-left" viewBox="0 0 16 16">
                    <path fill-rule="evenodd" d="M15 8a.5.5 0 0 0-.5-.5H2.707l3.147-3.146a.5.5 0 1 0-.708-.708l-4 4a.5.5 0 0 0 0 .708l4 4a.5.5 0 0 0 .708-.708L2.707 8.5H14.5A.5.5 0 0 0 15 8z"/>
                </svg>
                Volver
            </a>
        </div>
    </div>

    <?php if (!empty($errors)): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php foreach ($errors as $error): ?>
                    <li><?= htmlspecialchars($error) ?></li>
                <?php endforeach; ?>
            </ul>
        </div>
    <?php endif; ?>

    <div class="card">
        <div class="card-header">
            <h3 class="mb-0">Datos del Estudiante</h3>
        </div>
        <div class="card-body">
            <form method="post" action="registrar_estudiante.php">
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="cedula" class="form-label">Cédula <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="cedula" name="cedula" 
                               value="<?= isset($_POST['cedula']) ? htmlspecialchars($_POST['cedula']) : '' ?>" 
                               required>
                    </div>
                    <div class="col-md-6">
                        <label for="correo" class="form-label">Correo Electrónico</label>
                        <input type="email" class="form-control" id="correo" name="correo" 
                               value="<?= isset($_POST['correo']) ? htmlspecialchars($_POST['correo']) : '' ?>">
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="nombres" class="form-label">Nombres <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="nombres" name="nombres" 
                               value="<?= isset($_POST['nombres']) ? htmlspecialchars($_POST['nombres']) : '' ?>" 
                               required>
                    </div>
                    <div class="col-md-6">
                        <label for="apellidos" class="form-label">Apellidos <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="apellidos" name="apellidos" 
                               value="<?= isset($_POST['apellidos']) ? htmlspecialchars($_POST['apellidos']) : '' ?>" 
                               required>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="telefono" class="form-label">Teléfono</label>
                        <input type="text" class="form-control" id="telefono" name="telefono" 
                               value="<?= isset($_POST['telefono']) ? htmlspecialchars($_POST['telefono']) : '' ?>">
                    </div>
                    <div class="col-md-6">
                        <label for="celular" class="form-label">Celular</label>
                        <input type="text" class="form-control" id="celular" name="celular" 
                               value="<?= isset($_POST['celular']) ? htmlspecialchars($_POST['celular']) : '' ?>">
                    </div>
                </div>

                <div class="mb-3">
                    <label for="direccion" class="form-label">Dirección</label>
                    <textarea class="form-control" id="direccion" name="direccion" rows="2"><?= isset($_POST['direccion']) ? htmlspecialchars($_POST['direccion']) : '' ?></textarea>
                </div>

                <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                    <button type="submit" class="btn btn-primary">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-save" viewBox="0 0 16 16">
                            <path d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1H9.5a1 1 0 0 0-1 1v7.293l2.646-2.647a.5.5 0 0 1 .708.708l-3.5 3.5a.5.5 0 0 1-.708 0l-3.5-3.5a.5.5 0 1 1 .708-.708L7.5 9.293V2a2 2 0 0 1 2-2H14a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h2.5a.5.5 0 0 1 0 1H2z"/>
                        </svg>
                        Registrar Estudiante
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php
include '../includes/footer.php';
$conn->close();
?>