<?php
// config/mail_config.php

/**
 * CONFIGURACIÓN DE CORREO ELECTRÓNICO
 */

// ==================== CONFIGURACIÓN SMTP ====================
define('MAIL_HOST', 'postgradomedicinaucv.com');
define('MAIL_USERNAME', 'no-responder@postgradomedicinaucv.com');
define('MAIL_PASSWORD', '-I-mgZK7TW#H');

// CONFIGURACIÓN CORREGIDA - Puerto 465 usa SSL
define('MAIL_PORT', 465);
define('MAIL_ENCRYPTION', 'ssl');

// ==================== CONFIGURACIÓN DEL REMITENTE ====================
define('MAIL_FROM_EMAIL', 'no-responder@postgradomedicinaucv.com');
define('MAIL_FROM_NAME', 'Sistema de Postgrado - Medicina UCV');

// ==================== CONFIGURACIÓN DE TIMEOUT Y RENDIMIENTO ====================
define('MAIL_DEBUG', 0);
define('MAIL_TIMEOUT', 30);
define('MAIL_SMTP_AUTH', true);
define('MAIL_SMTP_KEEPALIVE', false);

// ==================== CONFIGURACIÓN DE LA APLICACIÓN ====================
define('SITE_URL', 'https://postgradomedicinaucv.com/cepmed');
define('SUPPORT_EMAIL', 'no-responder@postgradomedicinaucv.com');

// ==================== CONFIGURACIÓN ALTERNATIVA SI FALLA SSL ====================
define('MAIL_ALT_PORT', 587);
define('MAIL_ALT_ENCRYPTION', 'tls');

// Verificar que la configuración esté completa
function verificar_configuracion_correo() {
    $configs_requeridas = [
        'MAIL_HOST', 'MAIL_USERNAME', 'MAIL_PASSWORD', 
        'MAIL_PORT', 'MAIL_ENCRYPTION', 'MAIL_FROM_EMAIL'
    ];
    
    foreach ($configs_requeridas as $config) {
        if (empty(constant($config))) {
            error_log("Error de configuración: $config no está definido");
            return false;
        }
    }
    return true;
}

// Función para obtener la configuración como array
function obtener_configuracion_correo() {
    return [
        'host' => MAIL_HOST,
        'username' => MAIL_USERNAME,
        'password' => MAIL_PASSWORD,
        'port' => MAIL_PORT,
        'encryption' => MAIL_ENCRYPTION,
        'from_email' => MAIL_FROM_EMAIL,
        'from_name' => MAIL_FROM_NAME,
        'debug' => MAIL_DEBUG,
        'timeout' => MAIL_TIMEOUT,
        'smtp_auth' => MAIL_SMTP_AUTH,
        'smtp_keepalive' => MAIL_SMTP_KEEPALIVE,
        'site_url' => SITE_URL,
        'support_email' => SUPPORT_EMAIL,
        'alt_port' => MAIL_ALT_PORT,
        'alt_encryption' => MAIL_ALT_ENCRYPTION
    ];
}
?>