<?php
// 1. CONFIGURACIÓN DE ENTORNO PARA PRODUCCIÓN
error_reporting(E_ALL & ~E_DEPRECATED & ~E_STRICT);
ini_set('display_errors', 0); // DESACTIVADO en producción
ini_set('log_errors', 1);
ini_set('error_log', dirname(__DIR__) . '/logs/php_errors.log');

// 2. CODIFICACIÓN DE CARACTERES
ini_set('default_charset', 'UTF-8');
mb_internal_encoding('UTF-8');
header('Content-Type: text/html; charset=utf-8');

// 3. CONFIGURACIÓN DE SESIÓN SEGURA
ini_set('session.cookie_httponly', 1);
ini_set('session.cookie_secure', 1); // Solo si usas HTTPS
ini_set('session.use_strict_mode', 1);

// 4. RUTA RAÍZ DEL PROYECTO (ROOT_PATH)
if (!defined('ROOT_PATH')) {
    define('ROOT_PATH', dirname(__DIR__));
}

// 5. URL BASE DINÁMICA (BASE_URL) - CORREGIDO
if (!defined('BASE_URL')) {
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
    $host = $_SERVER['HTTP_HOST'];
    
    // DOMINIO CORRECTO - ACTUALIZA ESTO
    $correct_domain = 'postgradomedicinaucv.com';
    $subdirectory = '/cepmed'; // Cambia esto si renombras la carpeta
    
    // Si estamos en el dominio incorrecto, redirigir al correcto
    if ($host !== $correct_domain && $host !== 'localhost' && $host !== '127.0.0.1') {
        $current_path = $_SERVER['REQUEST_URI'];
        // Remover /v22 duplicado si existe
        $current_path = str_replace('/cepmed', '/cepmed', $current_path);
        header("Location: " . $protocol . $correct_domain . $subdirectory . $current_path);
        exit();
    }
    
    // Calcular BASE_URL correctamente
    $script_path = dirname($_SERVER['SCRIPT_NAME']);
    $base_url = rtrim($script_path, '/');
    
    // Si está en subdirectorio, asegurarse de que no se duplique
    if ($base_url === $subdirectory) {
        $base_url = $subdirectory;
    }
    
    define('BASE_URL', $base_url);
}

// 6. INICIAR SESIÓN
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// 7. VERIFICACIÓN DE DOMINIO CORRECTO EN SESIONES EXISTENTES
if (isset($_SESSION['user_domain']) && $_SESSION['user_domain'] !== $_SERVER['HTTP_HOST']) {
    // Sesión de dominio diferente, destruir y redirigir
    session_destroy();
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
    $correct_domain = 'postgradomedicinaucv.com';
    $subdirectory = '/cepmed';
    header("Location: " . $protocol . $correct_domain . $subdirectory . "/login.php");
    exit();
}

// Guardar dominio actual en sesión
$_SESSION['user_domain'] = $_SERVER['HTTP_HOST'];

// 8. CONFIGURACIÓN DE LA BASE DE DATOS CON MANEJO DE ERRORES
try {
    if (!isset($conn)) {
        require_once ROOT_PATH . '/includes/db.php';
    }
    
    // Verificar si la conexión se estableció correctamente
    if (isset($conn) && $conn instanceof mysqli && !$conn->connect_error) {
        $sql_session = "SELECT setting_key, setting_value FROM app_settings WHERE setting_key IN ('session_duration', 'session_never_expire')";
        $result_session = $conn->query($sql_session);

        $_SESSION['app_settings'] = [];
        if ($result_session && $result_session->num_rows > 0) {
            while ($row = $result_session->fetch_assoc()) {
                $_SESSION['app_settings'][$row['setting_key']] = $row['setting_value'];
            }
        } else {
            // Valores por defecto si no hay configuración en la BD
            $_SESSION['app_settings'] = [
                'session_duration' => '3600',
                'session_never_expire' => '0'
            ];
        }
        
        // Configurar duración de sesión
        if ($_SESSION['app_settings']['session_never_expire'] == '1') {
            ini_set('session.gc_maxlifetime', 86400 * 30); // 30 días
        } else {
            $session_duration = intval($_SESSION['app_settings']['session_duration']) ?: 3600;
            ini_set('session.gc_maxlifetime', $session_duration);
        }
        
    }
} catch (Exception $e) {
    // En producción, no mostrar errores de BD al usuario
    error_log("Error en session_config: " . $e->getMessage());
    
    // Valores por defecto seguros
    $_SESSION['app_settings'] = [
        'session_duration' => '3600',
        'session_never_expire' => '0'
    ];
}

// 9. VERIFICACIÓN DE SESIÓN ACTIVA PARA PÁGINAS SEGURAS
function checkSession() {
    if (!isset($_SESSION['username']) || empty($_SESSION['username'])) {
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
        $current_domain = $_SESSION['user_domain'] ?? $_SERVER['HTTP_HOST'];
        $base_url = defined('BASE_URL') ? BASE_URL : '/cepmed';
        header("Location: " . $protocol . $current_domain . $base_url . "/login.php");
        exit();
    }
}

// 10. FUNCIÓN PARA REDIRECCIONES SEGURAS
function safeRedirect($path) {
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
    $current_domain = $_SESSION['user_domain'] ?? $_SERVER['HTTP_HOST'];
    $base_url = defined('BASE_URL') ? BASE_URL : '/cepmed';
    
    // Asegurar que el path no duplique el base_url
    $clean_path = $path;
    if (strpos($path, $base_url) === 0) {
        $clean_path = substr($path, strlen($base_url));
    }
    
    header("Location: " . $protocol . $current_domain . $base_url . $clean_path);
    exit();
}

// 11. FUNCIÓN PARA OBTENER URL COMPLETA
function getFullUrl($path = '') {
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
    $current_domain = $_SESSION['user_domain'] ?? $_SERVER['HTTP_HOST'];
    $base_url = defined('BASE_URL') ? BASE_URL : '/cepmed';
    
    // Limpiar path para evitar duplicados
    $clean_path = $path;
    if (strpos($path, $base_url) === 0) {
        $clean_path = substr($path, strlen($base_url));
    }
    
    return $protocol . $current_domain . $base_url . $clean_path;
}
?>