<?php
session_start();
require_once __DIR__ . '/../includes/db.php';

// Configurar conexión para usar UTF-8
$conn->set_charset("utf8mb4");
$conn->query("SET NAMES 'utf8mb4'");
$conn->query("SET CHARACTER SET utf8mb4");
$conn->query("SET COLLATION_CONNECTION = 'utf8mb4_unicode_ci'");

header('Content-Type: application/json');

if (!isset($_SESSION['username']) || !in_array($_SESSION['rol'], ['administrador', 'coordinador1', 'coordinador2', 'secretaria'])) {
    echo json_encode(['error' => 'No autorizado']);
    exit();
}

$postgrado_id = isset($_GET['postgrado_id']) ? intval($_GET['postgrado_id']) : 0;
$tipo_postgrado = isset($_GET['tipo_postgrado']) ? $_GET['tipo_postgrado'] : '';

if ($postgrado_id <= 0) {
    echo json_encode(['error' => 'ID de postgrado inválido']);
    exit();
}

// Obtener información del postgrado
$sql_postgrado = "SELECT creditos_electivos FROM postgrados WHERE id = ?";
$stmt_postgrado = $conn->prepare($sql_postgrado);
$stmt_postgrado->bind_param("i", $postgrado_id);
$stmt_postgrado->execute();
$postgrado = $stmt_postgrado->get_result()->fetch_assoc();

if (!$postgrado) {
    echo json_encode(['error' => 'Postgrado no encontrado']);
    exit();
}

// Obtener denominaciones según el tipo de postgrado
if ($tipo_postgrado == 'tradicional') {
    $sql = "SELECT id, codigo, nombre, credito, periodo, tipo_denominacion 
            FROM denominaciones 
            WHERE postgrado_id = ? AND tipo_denominacion = 'obligatoria'
            ORDER BY periodo, codigo";
} else {
    $sql = "SELECT id, codigo, nombre, credito, periodo, tipo_denominacion 
            FROM denominaciones 
            WHERE postgrado_id = ? 
            ORDER BY tipo_denominacion, periodo, codigo";
}

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $postgrado_id);
$stmt->execute();
$result = $stmt->get_result();
$denominaciones = $result->fetch_all(MYSQLI_ASSOC);

echo json_encode([
    'denominaciones' => $denominaciones,
    'creditos_electivos' => $postgrado['creditos_electivos']
]);

$conn->close();
?>