<?php
session_start();

// Configurar encoding UTF-8
header('Content-Type: text/html; charset=utf-8');
mb_internal_encoding('UTF-8');

if (!isset($_SESSION['username'])) {
    header("Location: ../login.php");
    exit();
}

include '../includes/db.php';

// Configurar conexión para usar UTF-8
$conn->set_charset("utf8mb4");
$conn->query("SET NAMES 'utf8mb4'");
$conn->query("SET CHARACTER SET utf8mb4");
$conn->query("SET COLLATION_CONNECTION = 'utf8mb4_unicode_ci'");

if ($conn->connect_error) {
    die("Error de conexión: " . $conn->connect_error);
}

// Habilitar reportes de error para depuración
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

$inscripcion_id = isset($_GET['inscripcion_id']) ? intval($_GET['inscripcion_id']) : 0;
$estudiante_id = isset($_GET['estudiante_id']) ? intval($_GET['estudiante_id']) : 0;
$postgrado_id = isset($_GET['postgrado_id']) ? intval($_GET['postgrado_id']) : 0;

// Obtener información de la inscripción específica
$sql_inscripcion = "SELECT i.id, i.estudiante_id, i.denominacion_id, i.año_lectivo_id, 
                   i.nota_definitiva, i.estado,
                   d.nombre as denominacion_nombre, d.codigo, d.tipo,
                   al.nombre as anio_lectivo_actual,
                   e.nombres, e.apellidos,
                   p.nombre as postgrado_nombre
                   FROM inscripciones i
                   JOIN denominaciones d ON i.denominacion_id = d.id
                   JOIN anios_lectivos al ON i.año_lectivo_id = al.id
                   JOIN estudiantes e ON i.estudiante_id = e.id
                   JOIN postgrados p ON d.postgrado_id = p.id
                   WHERE i.id = ?";
$stmt_inscripcion = $conn->prepare($sql_inscripcion);
$stmt_inscripcion->bind_param("i", $inscripcion_id);
$stmt_inscripcion->execute();
$inscripcion = $stmt_inscripcion->get_result()->fetch_assoc();

if (!$inscripcion) {
    $_SESSION['error'] = "No se encontró la inscripción especificada.";
    header("Location: cargar_notas_estudiante.php?estudiante_id=$estudiante_id&postgrado_id=$postgrado_id");
    exit();
}

// Obtener todos los años lectivos disponibles
$sql_anios_lectivos = "SELECT id, nombre FROM anios_lectivos ORDER BY nombre DESC";
$result_anios_lectivos = $conn->query($sql_anios_lectivos);
$anios_lectivos = $result_anios_lectivos->fetch_all(MYSQLI_ASSOC);

// Procesar actualización del año lectivo
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['actualizar_anio_lectivo'])) {
    $nuevo_anio_lectivo_id = intval($_POST['anio_lectivo_id']);
    $fecha_actual = date('Y-m-d H:i:s');
    
    // Validar que el año lectivo exista
    $sql_verificar_anio = "SELECT COUNT(*) as count FROM anios_lectivos WHERE id = ?";
    $stmt_verificar = $conn->prepare($sql_verificar_anio);
    $stmt_verificar->bind_param("i", $nuevo_anio_lectivo_id);
    $stmt_verificar->execute();
    $result_verificar = $stmt_verificar->get_result()->fetch_assoc();
    
    if ($result_verificar['count'] == 0) {
        $_SESSION['error'] = "El año lectivo seleccionado no existe.";
    } else {
        // Actualizar el año lectivo de la inscripción
        $sql_update = "UPDATE inscripciones SET 
                      año_lectivo_id = ?, 
                      fecha_modificacion = ?, 
                      usuario_modificacion = ?
                      WHERE id = ?";
        $stmt_update = $conn->prepare($sql_update);
        $stmt_update->bind_param("isii", $nuevo_anio_lectivo_id, $fecha_actual, $_SESSION['user_id'], $inscripcion_id);
        
        if ($stmt_update->execute()) {
            $_SESSION['success'] = "Año lectivo actualizado correctamente para la denominación: " . $inscripcion['denominacion_nombre'];
            header("Location: cargar_notas_estudiante.php?estudiante_id=$estudiante_id&postgrado_id=$postgrado_id");
            exit();
        } else {
            $_SESSION['error'] = "Error al actualizar el año lectivo: " . $conn->error;
        }
    }
}

$page_title = "Modificar Año Lectivo";
include '../includes/header.php';
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        .card {
            box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
            border: 1px solid rgba(0, 0, 0, 0.125);
        }
        .btn-secondary {
            background-color: #6c757d;
            border-color: #6c757d;
        }
        .btn-primary {
            background-color: #0d6efd;
            border-color: #0d6efd;
        }
        .alert {
            border-radius: 0.375rem;
        }
    </style>
</head>
<body>
    <div class="container mt-4">
        <div class="mb-4">
            <a href="cargar_notas_estudiante.php?estudiante_id=<?php echo $estudiante_id; ?>&postgrado_id=<?php echo $postgrado_id; ?>" class="btn btn-secondary">
                <i class="bi bi-arrow-left"></i> Volver a las notas del estudiante
            </a>
        </div>

        <?php if (isset($_SESSION['error'])): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?= $_SESSION['error'] ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php unset($_SESSION['error']); ?>
        <?php endif; ?>

        <div class="card">
            <div class="card-header bg-primary text-white">
                <h3 class="mb-0"><i class="bi bi-calendar-check"></i> Modificar Año Lectivo</h3>
            </div>
            <div class="card-body">
                <div class="row mb-4">
                    <div class="col-md-6">
                        <p><strong>Estudiante:</strong> <?php echo htmlspecialchars($inscripcion['nombres'] . ' ' . $inscripcion['apellidos']); ?></p>
                        <p><strong>Postgrado:</strong> <?php echo htmlspecialchars($inscripcion['postgrado_nombre']); ?></p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>Denominación:</strong> <?php echo htmlspecialchars($inscripcion['denominacion_nombre'] . ' (' . $inscripcion['codigo'] . ')'); ?></p>
                        <p><strong>Tipo:</strong> <?php echo htmlspecialchars($inscripcion['tipo']); ?></p>
                        <p><strong>Estado actual:</strong> 
                            <span class="badge bg-<?= $inscripcion['estado'] == 'finalizada' ? 'success' : 'warning' ?>">
                                <?= ucfirst($inscripcion['estado']) ?>
                            </span>
                        </p>
                    </div>
                </div>

                <form method="post">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="anio_lectivo_actual" class="form-label">Año Lectivo Actual:</label>
                                <input type="text" class="form-control" id="anio_lectivo_actual" 
                                       value="<?php echo htmlspecialchars($inscripcion['anio_lectivo_actual']); ?>" readonly>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="anio_lectivo_id" class="form-label">Nuevo Año Lectivo:</label>
                                <select class="form-select" id="anio_lectivo_id" name="anio_lectivo_id" required>
                                    <option value="">Seleccionar año lectivo</option>
                                    <?php foreach ($anios_lectivos as $anio): ?>
                                        <option value="<?= $anio['id'] ?>" <?= $anio['id'] == $inscripcion['año_lectivo_id'] ? 'selected' : '' ?>>
                                            <?= htmlspecialchars($anio['nombre']) ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <?php if (!empty($inscripcion['nota_definitiva'])): ?>
                        <div class="alert alert-info">
                            <strong><i class="bi bi-info-circle"></i> Nota actual:</strong> <?php echo htmlspecialchars($inscripcion['nota_definitiva']); ?>
                        </div>
                    <?php endif; ?>
                    
                    <div class="alert alert-warning">
                        <strong><i class="bi bi-exclamation-triangle"></i> Nota:</strong> 
                        Esta acción solo modifica el año lectivo de esta denominación específica. 
                        No afecta a otras asignaturas del estudiante.
                    </div>
                    
                    <button type="submit" name="actualizar_anio_lectivo" class="btn btn-primary">
                        <i class="bi bi-calendar-check"></i> Actualizar Año Lectivo
                    </button>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

<?php
$conn->close();
?>