<?php
// 97 GESTI07N DE POSTGRADOS - P09GINA PROTEGIDA

// 1. SIEMPRE PRIMERO - configuracin de sesin
require_once __DIR__ . '/../includes/session_config.php';

// 2. SIEMPRE SEGUNDO - verificacin de auth
$allowed_roles = ['administrador'];
require_once __DIR__ . '/../includes/auth_check.php';

// 3. DB Connection
require_once __DIR__ . '/../includes/db.php';

// Configurar conexin para usar UTF-8
$conn->set_charset("utf8mb4");
$conn->query("SET NAMES 'utf8mb4'");
$conn->query("SET CHARACTER SET utf8mb4");
$conn->query("SET COLLATION_CONNECTION = 'utf8mb4_unicode_ci'");

// Variables para bsqueda y paginacin
$busqueda = isset($_GET['busqueda']) ? trim($_GET['busqueda']) : '';
$pagina_actual = isset($_GET['pagina']) ? intval($_GET['pagina']) : 1;
$registros_por_pagina = 25;

// Procesar eliminacin de postgrado
if (isset($_GET['eliminar'])) {
    $id_eliminar = intval($_GET['eliminar']);
    
    // Verificar si el postgrado tiene historial
    $sql_verificar = "SELECT 
        (SELECT COUNT(*) FROM estudiante_postgrado WHERE postgrado_id = ?) as total_estudiantes,
        (SELECT COUNT(*) FROM inscripciones i 
         JOIN denominaciones d ON i.denominacion_id = d.id 
         WHERE d.postgrado_id = ?) as total_inscripciones,
        (SELECT COUNT(*) FROM cambios_postgrado WHERE postgrado_anterior = ? OR postgrado_nuevo = ?) as total_cambios";
    
    $stmt_verificar = $conn->prepare($sql_verificar);
    $stmt_verificar->bind_param("iiii", $id_eliminar, $id_eliminar, $id_eliminar, $id_eliminar);
    $stmt_verificar->execute();
    $result_verificar = $stmt_verificar->get_result();
    $verificacion = $result_verificar->fetch_assoc();
    
    $tiene_historial = ($verificacion['total_estudiantes'] > 0 || $verificacion['total_inscripciones'] > 0 || $verificacion['total_cambios'] > 0);
    
    if (!$tiene_historial) {
        // Eliminar denominaciones primero
        $sql_eliminar_denominaciones = "DELETE FROM denominaciones WHERE postgrado_id = ?";
        $stmt_denominaciones = $conn->prepare($sql_eliminar_denominaciones);
        $stmt_denominaciones->bind_param("i", $id_eliminar);
        $stmt_denominaciones->execute();
        
        // Luego eliminar el postgrado
        $sql_eliminar = "DELETE FROM postgrados WHERE id = ?";
        $stmt_eliminar = $conn->prepare($sql_eliminar);
        $stmt_eliminar->bind_param("i", $id_eliminar);
        
        if ($stmt_eliminar->execute()) {
            $_SESSION['success'] = "Postgrado eliminado correctamente";
        } else {
            $_SESSION['error'] = "Error al eliminar el postgrado";
        }
    } else {
        $_SESSION['error'] = "No se puede eliminar el postgrado porque tiene historial academico registrado";
    }
    
    header("Location: gestion_postgrados.php" . ($busqueda ? "?busqueda=" . urlencode($busqueda) : ""));
    exit();
}

// Agregar postgrado con plan
if (isset($_POST['agregar_postgrado'])) {
    $nombre_postgrado = trim($_POST['nombre_postgrado']);
    $nombre_plan = trim($_POST['nombre_plan']);
    $tipo_postgrado = $_POST['tipo_postgrado'];
    $creditos_totales = intval($_POST['creditos_totales']);
    $creditos_obligatorios = intval($_POST['creditos_obligatorios']);
    $creditos_electivos = intval($_POST['creditos_electivos']);
    
    // Validar que los creditos coincidan
    if ($tipo_postgrado == 'tradicional') {
        $creditos_obligatorios = $creditos_totales;
        $creditos_electivos = 0;
    } elseif ($tipo_postgrado == 'electivo') {
        $creditos_obligatorios = 0;
        $creditos_electivos = $creditos_totales;
    } else { // mixto
        if ($creditos_obligatorios + $creditos_electivos != $creditos_totales) {
            $_SESSION['error'] = "La suma de creditos obligatorios y electivos debe ser igual a los creditos totales.";
            header("Location: gestion_postgrados.php");
            exit();
        }
    }
    
    if (!empty($nombre_postgrado) && !empty($nombre_plan)) {
        $conn->begin_transaction();
        try {
            // Verificar si el plan ya existe
            $sql_check_plan = "SELECT id FROM planes WHERE nombre = ?";
            $stmt_check_plan = $conn->prepare($sql_check_plan);
            $stmt_check_plan->bind_param("s", $nombre_plan);
            $stmt_check_plan->execute();
            $result_check_plan = $stmt_check_plan->get_result();
            
            if ($result_check_plan->num_rows > 0) {
                $plan_id = $result_check_plan->fetch_assoc()['id'];
            } else {
                // Crear nuevo plan
                $sql_plan = "INSERT INTO planes (nombre) VALUES (?)";
                $stmt_plan = $conn->prepare($sql_plan);
                $stmt_plan->bind_param("s", $nombre_plan);
                $stmt_plan->execute();
                $plan_id = $conn->insert_id;
            }
            
            // Verificar si el postgrado ya existe
            $sql_check_postgrado = "SELECT id FROM postgrados WHERE nombre = ? AND plan_id = ?";
            $stmt_check_postgrado = $conn->prepare($sql_check_postgrado);
            $stmt_check_postgrado->bind_param("si", $nombre_postgrado, $plan_id);
            $stmt_check_postgrado->execute();
            $result_check_postgrado = $stmt_check_postgrado->get_result();
            
            if ($result_check_postgrado->num_rows > 0) {
                throw new Exception("Este postgrado ya existe con el mismo plan");
            }
            
            // Crear el postgrado
            $sql_postgrado = "INSERT INTO postgrados (nombre, plan_id, tipo_postgrado, creditos_totales, creditos_obligatorios, creditos_electivos) VALUES (?, ?, ?, ?, ?, ?)";
            $stmt_postgrado = $conn->prepare($sql_postgrado);
            $stmt_postgrado->bind_param("sisiii", $nombre_postgrado, $plan_id, $tipo_postgrado, $creditos_totales, $creditos_obligatorios, $creditos_electivos);
            $stmt_postgrado->execute();
            
            $conn->commit();
            $_SESSION['success'] = "Postgrado creado correctamente";
        } catch (Exception $e) {
            $conn->rollback();
            $_SESSION['error'] = "Error: " . $e->getMessage();
        }
    } else {
        $_SESSION['error'] = "Todos los campos son obligatorios";
    }
    header("Location: gestion_postgrados.php");
    exit();
}

// Obtener total de registros para paginacin
$sql_count = "SELECT COUNT(*) as total 
              FROM postgrados p 
              JOIN planes pl ON p.plan_id = pl.id 
              WHERE p.nombre LIKE ? OR pl.nombre LIKE ? OR p.tipo_postgrado LIKE ?";
$stmt_count = $conn->prepare($sql_count);
$param_busqueda = "%$busqueda%";
$stmt_count->bind_param("sss", $param_busqueda, $param_busqueda, $param_busqueda);
$stmt_count->execute();
$result_count = $stmt_count->get_result();
$total_registros = $result_count->fetch_assoc()['total'];
$total_paginas = ceil($total_registros / $registros_por_pagina);

// Ajustar pgina actual si es necesario
if ($pagina_actual < 1) $pagina_actual = 1;
if ($pagina_actual > $total_paginas) $pagina_actual = $total_paginas;
$offset = ($pagina_actual - 1) * $registros_por_pagina;

// Obtener postgrados con paginacin
$sql = "SELECT p.id, p.nombre as postgrado_nombre, p.estado, p.tipo_postgrado, p.creditos_totales, p.creditos_obligatorios, p.creditos_electivos, pl.nombre as plan_nombre,
       (SELECT COUNT(*) FROM estudiante_postgrado ep WHERE ep.postgrado_id = p.id) as total_estudiantes,
       (SELECT COUNT(*) FROM estudiante_postgrado ep WHERE ep.postgrado_id = p.id AND ep.estado = 'activo') as estudiantes_activos,
       (SELECT COUNT(*) FROM inscripciones i 
        JOIN denominaciones d ON i.denominacion_id = d.id 
        WHERE d.postgrado_id = p.id) as total_inscripciones,
       (SELECT COUNT(*) FROM cambios_postgrado cp WHERE cp.postgrado_anterior = p.id OR cp.postgrado_nuevo = p.id) as total_cambios
        FROM postgrados p 
        JOIN planes pl ON p.plan_id = pl.id 
        WHERE p.nombre LIKE ? OR pl.nombre LIKE ? OR p.tipo_postgrado LIKE ?
        ORDER BY p.nombre
        LIMIT ? OFFSET ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("sssii", $param_busqueda, $param_busqueda, $param_busqueda, $registros_por_pagina, $offset);
$stmt->execute();
$result = $stmt->get_result();
$postgrados = $result->fetch_all(MYSQLI_ASSOC);

// 4. Configurar ttulo de pgina
$page_title = "Gestion de Postgrados";

// 5. Incluir header
include '../includes/header.php';
?>

<div class="container mt-4">
    <!-- Botn para volver al panel -->
    <div class="mb-4">
        <a href="index.php" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Volver al Panel
        </a>
    </div>

    <?php if (isset($_SESSION['success'])): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <i class="bi bi-check-circle-fill"></i> <?php echo htmlspecialchars($_SESSION['success']); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
        <?php unset($_SESSION['success']); ?>
    <?php endif; ?>
    
    <?php if (isset($_SESSION['error'])): ?>
        <div class="alert alert-danger alert-dismissible fade show">
            <i class="bi bi-exclamation-triangle-fill"></i> <?php echo htmlspecialchars($_SESSION['error']); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
        <?php unset($_SESSION['error']); ?>
    <?php endif; ?>

    <!-- Resumen General -->
    <div class="card mb-4">
        <div class="card-header bg-info text-white">
            <h5 class="mb-0"><i class="bi bi-graph-up"></i> Resumen General de Postgrados</h5>
        </div>
        <div class="card-body">
            <div class="row text-center">
                <div class="col-md-3">
                    <div class="card bg-primary text-white">
                        <div class="card-body">
                            <h4><?php echo $total_registros; ?></h4>
                            <p class="mb-0">Total Postgrados</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-success text-white">
                        <div class="card-body">
                            <h4>
                                <?php 
                                $sql_abiertos = "SELECT COUNT(*) as total FROM postgrados WHERE estado = 'abierto'";
                                $result_abiertos = $conn->query($sql_abiertos);
                                echo $result_abiertos->fetch_assoc()['total'];
                                ?>
                            </h4>
                            <p class="mb-0">Postgrados Abiertos</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-warning text-dark">
                        <div class="card-body">
                            <h4>
                                <?php 
                                $sql_activos = "SELECT COUNT(DISTINCT estudiante_id) as total FROM estudiante_postgrado WHERE estado = 'activo'";
                                $result_activos = $conn->query($sql_activos);
                                echo $result_activos->fetch_assoc()['total'];
                                ?>
                            </h4>
                            <p class="mb-0">Estudiantes Activos</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-secondary text-white">
                        <div class="card-body">
                            <h4>
                                <?php 
                                $sql_planes = "SELECT COUNT(DISTINCT plan_id) as total FROM postgrados";
                                $result_planes = $conn->query($sql_planes);
                                echo $result_planes->fetch_assoc()['total'];
                                ?>
                            </h4>
                            <p class="mb-0">Planes Diferentes</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card mb-4">
        <div class="card-header bg-primary text-white">
            <h3 class="mb-0"><i class="bi bi-plus-circle"></i> Agregar Nuevo Postgrado</h3>
        </div>
        <div class="card-body">
            <form action="gestion_postgrados.php" method="post" id="form-nuevo-postgrado">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="nombre_postgrado" class="form-label">Nombre del Postgrado:</label>
                        <input type="text" class="form-control" id="nombre_postgrado" name="nombre_postgrado" placeholder="Nombre del Postgrado" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="nombre_plan" class="form-label">Plan:</label>
                        <input type="text" class="form-control" id="nombre_plan" name="nombre_plan" placeholder="Nombre del Plan" required>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4 mb-3">
                        <label for="tipo_postgrado" class="form-label">Tipo de Postgrado:</label>
                        <select class="form-select" id="tipo_postgrado" name="tipo_postgrado" required>
                            <option value="tradicional">Tradicional (Todas obligatorias)</option>
                            <option value="mixto">Mixto (Obligatorias y Electivas)</option>
                            <option value="electivo">Electivo (Todas electivas)</option>
                        </select>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label for="creditos_totales" class="form-label">Creditos Totales:</label>
                        <input type="number" class="form-control" id="creditos_totales" name="creditos_totales" min="0" value="0" required>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label for="creditos_obligatorios" class="form-label">Creditos Obligatorios:</label>
                        <input type="number" class="form-control" id="creditos_obligatorios" name="creditos_obligatorios" min="0" value="0" required>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label for="creditos_electivos" class="form-label">Creditos Electivos:</label>
                        <input type="number" class="form-control" id="creditos_electivos" name="creditos_electivos" min="0" value="0" required>
                    </div>
                </div>

                <!-- Resumen de Creditos en tiempo real -->
                <div class="row mt-3">
                    <div class="col-12">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h6 class="card-title"><i class="bi bi-graph-up"></i> Resumen de Creditos</h6>
                                <div class="row">
                                    <div class="col-md-4">
                                        <strong>Creditos Totales:</strong> 
                                        <span id="resumen_totales" class="badge bg-primary">0</span>
                                    </div>
                                    <div class="col-md-4">
                                        <strong>Creditos Obligatorios:</strong> 
                                        <span id="resumen_obligatorios" class="badge bg-warning text-dark">0</span>
                                    </div>
                                    <div class="col-md-4">
                                        <strong>Creditos Electivos:</strong> 
                                        <span id="resumen_electivos" class="badge bg-info">0</span>
                                    </div>
                                </div>
                                <div class="mt-2" id="validacion_creditos">
                                    <span class="text-muted">Complete los campos para ver la validacion</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <button type="submit" name="agregar_postgrado" class="btn btn-primary mt-3" id="btn-crear-postgrado">
                    <i class="bi bi-save"></i> Crear Postgrado
                </button>
            </form>
        </div>
    </div>

    <!-- Buscador - MOVIDO DESPU07S DEL FORMULARIO DE AGREGAR -->
    <div class="card mb-4">
        <div class="card-header bg-success text-white">
            <h5 class="mb-0"><i class="bi bi-search"></i> Buscar Postgrados</h5>
        </div>
        <div class="card-body">
            <form method="get" class="row g-3">
                <div class="col-md-8">
                    <input type="text" class="form-control" name="busqueda" value="<?php echo htmlspecialchars($busqueda); ?>" 
                           placeholder="Buscar por nombre de postgrado, plan o tipo...">
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-success w-100">
                        <i class="bi bi-search"></i> Buscar
                    </button>
                </div>
                <div class="col-md-2">
                    <a href="gestion_postgrados.php" class="btn btn-secondary w-100">
                        <i class="bi bi-x-circle"></i> Limpiar
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Informacin de paginacin -->
    <div class="d-flex justify-content-between align-items-center mb-3">
        <div>
            <span class="text-muted">
                Mostrando <?php echo count($postgrados); ?> de <?php echo $total_registros; ?> postgrados
                <?php echo $busqueda ? "para: '" . htmlspecialchars($busqueda) . "'" : ""; ?>
            </span>
        </div>
        <div>
            <span class="badge bg-primary">Pagina <?php echo $pagina_actual; ?> de <?php echo $total_paginas; ?></span>
        </div>
    </div>

    <div class="card">
        <div class="card-header bg-info text-white">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="mb-0"><i class="bi bi-list-ul"></i> Listado de Postgrados</h3>
                <span class="badge bg-light text-dark">Total: <?php echo $total_registros; ?></span>
            </div>
        </div>
        <div class="card-body">
            <?php if (empty($postgrados)): ?>
                <div class="alert alert-info text-center">
                    <i class="bi bi-info-circle"></i> No se encontraron postgrados <?php echo $busqueda ? "que coincidan con la busqueda" : ""; ?>
                </div>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead class="table-dark">
                            <tr>
                                <th>ID</th>
                                <th>Nombre</th>
                                <th>Plan</th>
                                <th>Tipo</th>
                                <th>Creditos</th>
                                <th>Estado</th>
                                <th>Total Estudiantes</th>
                                <th>Estudiantes Activos</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($postgrados as $postgrado): 
                                $tiene_historial = ($postgrado['total_estudiantes'] > 0 || $postgrado['total_inscripciones'] > 0 || $postgrado['total_cambios'] > 0);
                            ?>
                                <tr>
                                    <td><?php echo $postgrado['id']; ?></td>
                                    <td>
                                        <strong><?php echo htmlspecialchars($postgrado['postgrado_nombre']); ?></strong>
                                    </td>
                                    <td><?php echo htmlspecialchars($postgrado['plan_nombre']); ?></td>
                                    <td>
                                        <span class="badge bg-<?php 
                                            echo $postgrado['tipo_postgrado'] == 'tradicional' ? 'primary' : 
                                                 ($postgrado['tipo_postgrado'] == 'mixto' ? 'warning' : 'info'); 
                                        ?>">
                                            <?php echo ucfirst($postgrado['tipo_postgrado']); ?>
                                        </span>
                                    </td>
                                    <td>
                                        <small>
                                            <strong>Total:</strong> <?php echo $postgrado['creditos_totales']; ?><br>
                                            <strong>Oblig:</strong> <?php echo $postgrado['creditos_obligatorios']; ?><br>
                                            <strong>Elect:</strong> <?php echo $postgrado['creditos_electivos']; ?>
                                        </small>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?php echo $postgrado['estado'] == 'abierto' ? 'success' : 'secondary'; ?>">
                                            <?php echo ucfirst($postgrado['estado']); ?>
                                        </span>
                                    </td>
                                    <td>
                                        <?php if ($postgrado['total_estudiantes'] > 0): ?>
                                            <span class="badge bg-info" data-bs-toggle="tooltip" 
                                                  title="<?php echo $postgrado['total_estudiantes']; ?> estudiante(s) en total">
                                                <?php echo $postgrado['total_estudiantes']; ?> total
                                            </span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary">0</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if ($postgrado['estudiantes_activos'] > 0): ?>
                                            <span class="badge bg-warning text-dark" data-bs-toggle="tooltip" 
                                                  title="<?php echo $postgrado['estudiantes_activos']; ?> estudiante(s) activo(s)">
                                                <?php echo $postgrado['estudiantes_activos']; ?> activo(s)
                                            </span>
                                        <?php else: ?>
                                            <span class="badge bg-light text-dark">0 activos</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="d-flex gap-1">
                                            <a href='editar_postgrado.php?id=<?php echo $postgrado['id']; ?>' 
                                               class="btn btn-sm btn-primary" title="Editar postgrado">
                                                <i class="bi bi-pencil"></i> Editar
                                            </a>
                                            <?php if (!$tiene_historial): ?>
                                                <a href='gestion_postgrados.php?eliminar=<?php echo $postgrado['id']; echo $busqueda ? "&busqueda=" . urlencode($busqueda) : ""; ?>' 
                                                   class="btn btn-sm btn-danger" 
                                                   onclick='return confirm("07Estas seguro de eliminar este postgrado?")'
                                                   title="Eliminar postgrado">
                                                    <i class="bi bi-trash"></i> Eliminar
                                                </a>
                                            <?php else: ?>
                                                <button class="btn btn-sm btn-danger" disabled data-bs-toggle="tooltip" 
                                                        title="No se puede eliminar. Tiene historial academico">
                                                    <i class="bi bi-trash"></i> Eliminar
                                                </button>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Paginacin -->
                <?php if ($total_paginas > 1): ?>
                    <nav aria-label="Paginacin de postgrados">
                        <ul class="pagination justify-content-center mt-4">
                            <!-- Botn Anterior -->
                            <?php if ($pagina_actual > 1): ?>
                                <li class="page-item">
                                    <a class="page-link" href="?pagina=<?php echo $pagina_actual - 1; ?><?php echo $busqueda ? '&busqueda=' . urlencode($busqueda) : ''; ?>">
                                        <i class="bi bi-chevron-left"></i> Anterior
                                    </a>
                                </li>
                            <?php else: ?>
                                <li class="page-item disabled">
                                    <span class="page-link"><i class="bi bi-chevron-left"></i> Anterior</span>
                                </li>
                            <?php endif; ?>

                            <!-- Pginas -->
                            <?php 
                            $inicio = max(1, $pagina_actual - 2);
                            $fin = min($total_paginas, $pagina_actual + 2);
                            
                            for ($i = $inicio; $i <= $fin; $i++): ?>
                                <li class="page-item <?php echo $i == $pagina_actual ? 'active' : ''; ?>">
                                    <a class="page-link" href="?pagina=<?php echo $i; ?><?php echo $busqueda ? '&busqueda=' . urlencode($busqueda) : ''; ?>">
                                        <?php echo $i; ?>
                                    </a>
                                </li>
                            <?php endfor; ?>

                            <!-- Botn Siguiente -->
                            <?php if ($pagina_actual < $total_paginas): ?>
                                <li class="page-item">
                                    <a class="page-link" href="?pagina=<?php echo $pagina_actual + 1; ?><?php echo $busqueda ? '&busqueda=' . urlencode($busqueda) : ''; ?>">
                                        Siguiente <i class="bi bi-chevron-right"></i>
                                    </a>
                                </li>
                            <?php else: ?>
                                <li class="page-item disabled">
                                    <span class="page-link">Siguiente <i class="bi bi-chevron-right"></i></span>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </nav>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>

    <!-- Poltica de eliminacin - CORREGIDOS LOS CARACTERES ESPECIALES -->
    <div class="card mt-4">
        <div class="card-header bg-warning text-dark">
            <h5 class="mb-0"><i class="bi bi-exclamation-triangle"></i> Politica de Eliminacion de Postgrados</h5>
        </div>
        <div class="card-body">
            <ul class="mb-0">
                <li><strong>No se pueden eliminar postgrados que tengan historial academico registrado.</strong></li>
                <li>Un postgrado tiene historial si ha tenido estudiantes (activos, graduados o retirados), inscripciones o cambios relacionados.</li>
                <li>Esta politica garantiza la preservacion del historial academico completo del sistema.</li>
                <li>Los postgrados sin ningun registro pueden ser eliminados normalmente.</li>
                <li>Para desactivar un postgrado sin eliminarlo, cambiele el estado a "cerrado" en la opcion de edicion.</li>
            </ul>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Inicializar tooltips
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl)
    });

    // Elementos del formulario de nuevo postgrado
    const tipoPostgrado = document.getElementById('tipo_postgrado');
    const creditosTotales = document.getElementById('creditos_totales');
    const creditosObligatorios = document.getElementById('creditos_obligatorios');
    const creditosElectivos = document.getElementById('creditos_electivos');
    const btnCrearPostgrado = document.getElementById('btn-crear-postgrado');
    
    // Elementos del resumen
    const resumenTotales = document.getElementById('resumen_totales');
    const resumenObligatorios = document.getElementById('resumen_obligatorios');
    const resumenElectivos = document.getElementById('resumen_electivos');
    const validacionCreditos = document.getElementById('validacion_creditos');

    function actualizarResumen() {
        const totales = parseInt(creditosTotales.value) || 0;
        const obligatorios = parseInt(creditosObligatorios.value) || 0;
        const electivos = parseInt(creditosElectivos.value) || 0;
        
        resumenTotales.textContent = totales;
        resumenObligatorios.textContent = obligatorios;
        resumenElectivos.textContent = electivos;
        
        // Validar segun el tipo de postgrado
        const tipo = tipoPostgrado.value;
        let mensaje = '';
        let esValido = true;
        
        if (tipo === 'tradicional') {
            if (obligatorios !== totales) {
                mensaje = '<span class="text-danger"><i class="bi bi-exclamation-triangle"></i> Para postgrados tradicionales, los creditos obligatorios deben ser iguales a los creditos totales.</span>';
                esValido = false;
            } else {
                mensaje = '<span class="text-success"><i class="bi bi-check-circle"></i> Configuracion valida para postgrado tradicional.</span>';
            }
        } else if (tipo === 'electivo') {
            if (electivos !== totales) {
                mensaje = '<span class="text-danger"><i class="bi bi-exclamation-triangle"></i> Para postgrados electivos, los creditos electivos deben ser iguales a los creditos totales.</span>';
                esValido = false;
            } else {
                mensaje = '<span class="text-success"><i class="bi bi-check-circle"></i> Configuracion valida para postgrado electivo.</span>';
            }
        } else { // mixto
            if (obligatorios + electivos !== totales) {
                mensaje = '<span class="text-danger"><i class="bi bi-exclamation-triangle"></i> Para postgrados mixtos, la suma de creditos obligatorios y electivos debe ser igual a los creditos totales.</span>';
                esValido = false;
            } else {
                mensaje = '<span class="text-success"><i class="bi bi-check-circle"></i> Configuracion valida para postgrado mixto.</span>';
            }
        }
        
        validacionCreditos.innerHTML = mensaje;
        btnCrearPostgrado.disabled = !esValido;
    }

    function manejarTipoPostgrado() {
        const tipo = tipoPostgrado.value;
        
        if (tipo === 'tradicional') {
            creditosObligatorios.value = creditosTotales.value;
            creditosElectivos.value = 0;
            creditosObligatorios.readOnly = true;
            creditosElectivos.readOnly = true;
        } else if (tipo === 'electivo') {
            creditosObligatorios.value = 0;
            creditosElectivos.value = creditosTotales.value;
            creditosObligatorios.readOnly = true;
            creditosElectivos.readOnly = true;
        } else { // mixto
            creditosObligatorios.readOnly = false;
            creditosElectivos.readOnly = false;
        }
        
        actualizarResumen();
    }

    // Event listeners para el formulario de nuevo postgrado
    tipoPostgrado.addEventListener('change', manejarTipoPostgrado);
    creditosTotales.addEventListener('input', function() {
        if (tipoPostgrado.value === 'tradicional') {
            creditosObligatorios.value = this.value;
        } else if (tipoPostgrado.value === 'electivo') {
            creditosElectivos.value = this.value;
        }
        actualizarResumen();
    });
    
    creditosObligatorios.addEventListener('input', actualizarResumen);
    creditosElectivos.addEventListener('input', actualizarResumen);

    // Inicializar el formulario
    manejarTipoPostgrado();
    
    // Validacin del formulario antes de enviar
    document.getElementById('form-nuevo-postgrado').addEventListener('submit', function(e) {
        const tipo = tipoPostgrado.value;
        const totales = parseInt(creditosTotales.value);
        const obligatorios = parseInt(creditosObligatorios.value);
        const electivos = parseInt(creditosElectivos.value);
        
        let esValido = true;
        let mensaje = '';
        
        if (tipo === 'tradicional' && obligatorios !== totales) {
            esValido = false;
            mensaje = 'Para postgrados tradicionales, los creditos obligatorios deben ser iguales a los creditos totales.';
        } else if (tipo === 'electivo' && electivos !== totales) {
            esValido = false;
            mensaje = 'Para postgrados electivos, los creditos electivos deben ser iguales a los creditos totales.';
        } else if (tipo === 'mixto' && (obligatorios + electivos) !== totales) {
            esValido = false;
            mensaje = 'Para postgrados mixtos, la suma de creditos obligatorios y electivos debe ser igual a los creditos totales.';
        }
        
        if (!esValido) {
            e.preventDefault();
            alert('Error en la configuracion de creditos: ' + mensaje);
        }
    });
});
</script>

<?php
// 6. Incluir footer
include '../includes/footer.php';
?>