<?php
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../login.php");
    exit();
}
include '../includes/db.php';
include '../includes/header.php';

// Procesar el formulario si se envía
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $registro_habilitado = isset($_POST['registro_habilitado']) ? '1' : '0';
    $registro_verificado_solo = isset($_POST['registro_verificado_solo']) ? '1' : '0';

    $conn->begin_transaction();
    try {
        $stmt1 = $conn->prepare("UPDATE configuracion SET valor = ? WHERE nombre_config = 'registro_habilitado'");
        $stmt1->bind_param('s', $registro_habilitado);
        $stmt1->execute();

        $stmt2 = $conn->prepare("UPDATE configuracion SET valor = ? WHERE nombre_config = 'registro_verificado_solo'");
        $stmt2->bind_param('s', $registro_verificado_solo);
        $stmt2->execute();

        $conn->commit();
        $success_message = "Configuración actualizada correctamente.";
    } catch (Exception $e) {
        $conn->rollback();
        $error_message = "Error al actualizar la configuración: " . $e->getMessage();
    }
}

// Obtener la configuración actual
$sql = "SELECT nombre_config, valor FROM configuracion WHERE nombre_config IN ('registro_habilitado', 'registro_verificado_solo')";
$result = $conn->query($sql);
$config = [];
while ($row = $result->fetch_assoc()) {
    $config[$row['nombre_config']] = $row['valor'];
}

$registro_habilitado_checked = (isset($config['registro_habilitado']) && $config['registro_habilitado'] == '1') ? 'checked' : '';
$registro_verificado_solo_checked = (isset($config['registro_verificado_solo']) && $config['registro_verificado_solo'] == '1') ? 'checked' : '';
?>

<div class="container mt-5">
    <h2>Gestionar Registro de Estudiantes</h2>
    <p>Aquí puedes habilitar o deshabilitar el registro de nuevos estudiantes y configurar las reglas de registro.</p>

    <?php if (isset($success_message)): ?>
        <div class="alert alert-success"><?php echo $success_message; ?></div>
    <?php endif; ?>
    <?php if (isset($error_message)): ?>
        <div class="alert alert-danger"><?php echo $error_message; ?></div>
    <?php endif; ?>

    <div class="card">
        <div class="card-body">
            <form method="POST" action="">
                <div class="form-check form-switch mb-3">
                    <input class="form-check-input" type="checkbox" id="registro_habilitado" name="registro_habilitado" <?php echo $registro_habilitado_checked; ?>>
                    <label class="form-check-label" for="registro_habilitado">
                        <strong>Habilitar Registro de Estudiantes</strong>
                        <small class="form-text text-muted d-block">Si está habilitado, el enlace "Registrarse como estudiante" aparecerá en la página de login.</small>
                    </label>
                </div>

                <hr>

                <div class="form-check form-switch mb-3">
                    <input class="form-check-input" type="checkbox" id="registro_verificado_solo" name="registro_verificado_solo" <?php echo $registro_verificado_solo_checked; ?>>
                    <label class="form-check-label" for="registro_verificado_solo">
                        <strong>Permitir solo registro de estudiantes verificados</strong>
                        <small class="form-text text-muted d-block">
                            - Si está <strong>habilitado</strong>, solo los estudiantes cuya cédula ya exista en el sistema podrán crear un usuario.<br>
                            - Si está <strong>deshabilitado</strong>, cualquier persona podrá registrarse llenando todos sus datos desde cero.
                        </small>
                    </label>
                </div>
                
                <button type="submit" class="btn btn-primary">Guardar Configuración</button>
            </form>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
