<?php
session_start();
include '../includes/db.php'; // Asumiendo que db.php está en el directorio includes

// Verificar sesión y rol de administrador
if (!isset($_SESSION['username']) || $_SESSION['rol'] != 'administrador') {
    header("Location: ../login.php");
    exit();
}

// Lógica de negocio para obtener estudiantes (simplificada, debe ser robusta)
$filtro_cedula = $_GET['cedula'] ?? '';
$filtro_postgrado = $_GET['postgrado'] ?? 0;

$sql = "SELECT i.id as inscripcion_id, e.id, e.cedula, e.nombres, e.apellidos, p.nombre as postgrado, d.nombre as denominacion, al.nombre as año_lectivo, i.nota_final, i.nota_definitiva, i.seccion, i.escolaridad, i.fecha_inscripcion, i.anio_lectivo_id as anio_id FROM inscripciones i JOIN estudiantes e ON i.estudiante_id = e.id JOIN denominaciones d ON i.denominacion_id = d.id JOIN postgrados p ON d.postgrado_id = p.id JOIN años_lectivos al ON i.anio_lectivo_id = al.id WHERE 1=1";

if (!empty($filtro_cedula)) {
    $sql .= " AND e.cedula LIKE '%" . $conn->real_escape_string($filtro_cedula) . "%'";
}
if (!empty($filtro_postgrado)) {
    $sql .= " AND p.id = " . intval($filtro_postgrado);
}

$result = $conn->query($sql);
$estudiantes = $result->fetch_all(MYSQLI_ASSOC);

// Lógica para manejar la edición
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['editar_inscripcion'])) {
    // ... (Aquí iría la lógica para actualizar la base de datos)
    // Por seguridad, esta parte debe ser bien validada.
    header("Location: " . $_SERVER['PHP_SELF']); // Recargar para ver cambios
    exit();
}

$page_title = "Gestión de Estudiantes";
include '../includes/header.php';
?>
<style>
    .student-card { transition: all 0.3s; }
    .nota-box { min-width: 100px; padding: 8px 12px; border-radius: 5px; }
    .bg-nota-final { background-color: #e3f2fd; }
    .bg-nota-definitiva { background-color: #e8f5e9; }
    .detalle-estudiante { border-left: 3px solid #0d6efd; }
</style>

<h2 class="mb-4">Gestión de Estudiantes</h2>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="get" class="row g-3">
            <div class="col-md-4">
                <input type="text" name="cedula" class="form-control" placeholder="Cédula" value="<?= htmlspecialchars($filtro_cedula) ?>">
            </div>
            <div class="col-md-4">
                <select name="postgrado" class="form-select">
                    <option value="0">Todos los postgrados</option>
                    <?php 
                    $postgrados_result = $conn->query("SELECT * FROM postgrados");
                    while($p = $postgrados_result->fetch_assoc()): ?>
                    <option value="<?= $p['id'] ?>" <?= ($filtro_postgrado == $p['id']) ? 'selected' : '' ?> >
                        <?= htmlspecialchars($p['nombre']) ?>
                    </option>
                    <?php endwhile; ?>
                </select>
            </div>
            <div class="col-md-4">
                <button type="submit" class="btn btn-primary w-100">Buscar</button>
            </div>
        </form>
    </div>
</div>

<!-- Listado de Estudiantes -->
<div class="card">
    <div class="card-body">
        <?php if (empty($estudiantes)): ?>
            <div class="alert alert-info">No se encontraron estudiantes con los filtros seleccionados.</div>
        <?php else: ?>
            <?php foreach($estudiantes as $est):
            // El contenido del student card se omitió para brevedad, pero debe ser incluido aquí.
            // Asegúrate de que las variables de $est se usen correctamente.
            // Ejemplo de cómo podría verse una parte:
            ?><div class="student-card mb-3 p-3 border rounded">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5><?= htmlspecialchars($est['apellidos']) ?>, <?= htmlspecialchars($est['nombres']) ?></h5>
                            <small class="text-muted">Cédula: <?= htmlspecialchars($est['cedula']) ?></small>
                        </div>
                        <button class="btn btn-sm btn-primary" 
                                data-bs-toggle="collapse" 
                                data-bs-target="#detalle<?= $est['id'] ?>">
                            Ver Detalles
                        </button>
                    </div>
                    
                    <!-- Detalles Colapsables -->
                    <div class="collapse mt-3 detalle-estudiante" id="detalle<?= $est['id'] ?>">
                        <div class="row">
                            <div class="col-md-6">
                                <h6>Información Académica</h6>
                                <ul class="list-unstyled">
                                    <li>Postgrado: <?= htmlspecialchars($est['postgrado']) ?></li>
                                    <li>Denominación: <?= htmlspecialchars($est['denominacion']) ?></li>
                                    <li>Año Lectivo: <?= htmlspecialchars($est['año_lectivo']) ?></li>
                                </ul>
                            </div>
                            <div class="col-md-6">
                                <h6>Calificaciones</h6>
                                <div class="d-flex gap-2">
                                    <div class="nota-box bg-nota-final">
                                        Final: <?= $est['nota_final'] ?? 'N/A' ?>
                                    </div>
                                    <div class="nota-box bg-nota-definitiva">
                                        Definitiva: <?= $est['nota_definitiva'] ?? 'Pendiente' ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Botón de Edición -->
                        <div class="mt-3">
                            <button class="btn btn-warning btn-sm edit-btn"
                                    data-bs-toggle="modal"
                                    data-bs-target="#editModal"
                                    data-inscripcion="<?= $est['inscripcion_id'] ?>"
                                    data-nota-final="<?= htmlspecialchars($est['nota_final'] ?? '') ?>"
                                    data-nota-definitiva="<?= htmlspecialchars($est['nota_definitiva'] ?? '') ?>"
                                    data-anio="<?= $est['anio_id'] ?>"
                                    data-seccion="<?= htmlspecialchars($est['seccion'] ?? '') ?>"
                                    data-escolaridad="<?= htmlspecialchars($est['escolaridad'] ?? '') ?>"
                                    data-fecha="<?= htmlspecialchars($est['fecha_inscripcion'] ?? '') ?>">
                                Editar Inscripción
                            </button>
                        </div>
                    </div>
                </div><?php 
            endforeach; 
        endif; ?>
    </div>
</div>

<!-- Modal de Edición -->
<div class="modal fade" id="editModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form method="post" id="editForm">
                <div class="modal-header">
                    <h5 class="modal-title">Editar Inscripción</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="id" id="editId">
                    
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label>Nota Final</label>
                            <input type="number" step="0.01" name="nota_final" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label>Nota Definitiva</label>
                            <input type="number" step="0.01" name="nota_definitiva" class="form-control" required>
                        </div>
                        <div class="col-md-4">
                            <label>Año Lectivo</label>
                            <select name="anio_lectivo" class="form-select" required>
                                <?php 
                                $anios = $conn->query("SELECT * FROM años_lectivos ORDER BY nombre DESC");
                                while($a = $anios->fetch_assoc()): ?>
                                <option value="<?= $a['id'] ?>"><?= htmlspecialchars($a['nombre']) ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label>Sección</label>
                            <input type="text" name="seccion" class="form-control" required>
                        </div>
                        <div class="col-md-4">
                            <label>Escolaridad</label>
                            <input type="text" name="escolaridad" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label>Fecha Inscripción</label>
                            <input type="date" name="fecha_inscripcion" class="form-control" required>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                    <button type="submit" name="editar_inscripcion" class="btn btn-primary">Guardar Cambios</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php
$custom_scripts = "<script>
    document.addEventListener('DOMContentLoaded', () => {
        const editModal = new bootstrap.Modal(document.getElementById('editModal'));
        const editForm = document.getElementById('editForm');

        document.querySelectorAll('.edit-btn').forEach(btn => {
            btn.addEventListener('click', () => {
                editForm.querySelector('#editId').value = btn.dataset.inscripcion;
                editForm.querySelector('[name=\"nota_final\"]').value = btn.dataset.notaFinal || '';
                editForm.querySelector('[name=\"nota_definitiva\"]').value = btn.dataset.notaDefinitiva || '';
                editForm.querySelector('[name=\"anio_lectivo\"]').value = btn.dataset.anio || '';
                editForm.querySelector('[name=\"seccion\"]').value = btn.dataset.seccion || '';
                editForm.querySelector('[name=\"escolaridad\"]').value = btn.dataset.escolaridad || '';
                editForm.querySelector('[name=\"fecha_inscripcion\"]').value = btn.dataset.fecha || '';
                editModal.show();
            });
        });

        editForm.addEventListener('submit', function(e) {
            e.preventDefault();
            const formData = new FormData(this);
            fetch(window.location.href, {
                method: 'POST',
                body: formData
            })
            .then(response => {
                if(response.ok) {
                    window.location.reload();
                } else {
                    alert('Hubo un error al guardar los cambios.');
                }
            })
            .catch(error => console.error('Error:', error));
        });
    });
</script>";

include '../includes/footer.php';
?>
