<?php
// Centralized authentication and session check
$allowed_roles = ['administrador'];
require_once __DIR__ . '/../includes/auth_check.php';

// DB Connection
require_once __DIR__ . '/../includes/db.php';

// Configurar conexión para usar UTF-8
$conn->set_charset("utf8mb4");
$conn->query("SET NAMES 'utf8mb4'");
$conn->query("SET CHARACTER SET utf8mb4");
$conn->query("SET COLLATION_CONNECTION = 'utf8mb4_unicode_ci'");

// Procesar formulario si se envió
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Validar y sanitizar datos
    $id = isset($_POST['id']) ? intval($_POST['id']) : 0;
    $nombre = isset($_POST['nombre']) ? trim($conn->real_escape_string($_POST['nombre'])) : '';
    $cargo = isset($_POST['cargo']) ? trim($conn->real_escape_string($_POST['cargo'])) : '';
    $rev_por = isset($_POST['rev_por']) ? trim($conn->real_escape_string($_POST['rev_por'])) : '';
    
    // Determinar si es inserción o actualización
    if ($id > 0) {
        // Actualizar registro existente
        $stmt = $conn->prepare("UPDATE firmas_constancia_secretaria SET nombre = ?, cargo = ?, rev_por = ? WHERE id = ?");
        $stmt->bind_param("sssi", $nombre, $cargo, $rev_por, $id);
        $stmt->execute();
    } else {
        // Insertar nuevo registro
        $stmt = $conn->prepare("INSERT INTO firmas_constancia_secretaria (nombre, cargo, rev_por) VALUES (?, ?, ?)");
        $stmt->bind_param("sss", $nombre, $cargo, $rev_por);
        $stmt->execute();
    }
    
    // Redirigir para evitar reenvío del formulario
    header("Location: configurar_firmas_secretaria.php");
    exit();
}

// Procesar eliminación si se solicitó
if (isset($_GET['eliminar'])) {
    $id = intval($_GET['eliminar']);
    $conn->query("DELETE FROM firmas_constancia_secretaria WHERE id = $id");
    
    header("Location: configurar_firmas_secretaria.php");
    exit();
}

// Obtener todos los registros de firmas
$result = $conn->query("SELECT * FROM firmas_constancia_secretaria ORDER BY id");
$firmas = $result->fetch_all(MYSQLI_ASSOC);

// Obtener un registro específico para edición (si se solicitó)
$editar_firma = null;
if (isset($_GET['editar'])) {
    $id = intval($_GET['editar']);
    $result = $conn->query("SELECT * FROM firmas_constancia_secretaria WHERE id = $id");
    $editar_firma = $result->fetch_assoc();
}

$page_title = "Configurar Firmas - Secretaría";
include '../includes/header.php';
?>
    <div class="container mt-4">
        <!-- Botón para volver -->
        <div class="mb-4">
            <a href="../admin/index.php" class="btn btn-secondary">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-left" viewBox="0 0 16 16">
                    <path fill-rule="evenodd" d="M15 8a.5.5 0 0 0-.5-.5H2.707l3.147-3.146a.5.5 0 1 0-.708-.708l-4 4a.5.5 0 0 0 0 .708l4 4a.5.5 0 0 0 .708-.708L2.707 8.5H14.5A.5.5 0 0 0 15 8z"/>
                </svg>
                Volver al Menú
            </a>
        </div>

        <?php if (isset($_SESSION['success'])): ?>
            <div class="alert alert-success"><?= $_SESSION['success'] ?></div>
            <?php unset($_SESSION['success']); ?>
        <?php endif; ?>

        <div class="card">
            <div class="card-header bg-primary text-white">
                <h3 class="mb-0">Configurar Firmas para Constancias de Secretaría</h3>
            </div>
            <div class="card-body">
                <form method="post">
                    <?php if (isset($editar_firma)): ?>
                        <input type="hidden" name="id" value="<?php echo $editar_firma['id']; ?>">
                    <?php endif; ?>
                    
                    <div class="row g-3">
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="nombre" class="form-label"><strong>Nombre</strong></label>
                                <input type="text" class="form-control" id="nombre" 
                                       name="nombre" value="<?= htmlspecialchars($editar_firma['nombre'] ?? '') ?>" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="cargo" class="form-label"><strong>Cargo</strong></label>
                                <input type="text" class="form-control" id="cargo" 
                                       name="cargo" value="<?= htmlspecialchars($editar_firma['cargo'] ?? '') ?>" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="rev_por" class="form-label"><strong>Revisado por</strong></label>
                                <input type="text" class="form-control" id="rev_por" 
                                       name="rev_por" value="<?= htmlspecialchars($editar_firma['rev_por'] ?? '') ?>">
                            </div>
                        </div>
                    </div>
                    
                    <div class="mt-4">
                        <button type="submit" class="btn btn-primary">
                            <?php echo isset($editar_firma) ? 'Actualizar' : 'Guardar'; ?>
                        </button>
                        
                        <?php if (isset($editar_firma)): ?>
                            <a href="configurar_firmas_secretaria.php" class="btn btn-secondary">Cancelar</a>
                        <?php endif; ?>
                    </div>
                </form>
            </div>
        </div>
        
        <div class="card mt-4">
            <div class="card-header">
                <h3>Lista de Firmas Configuradas</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Nombre</th>
                                <th>Cargo</th>
                                <th>Revisado por</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($firmas as $firma): ?>
                                <tr>
                                    <td><?php echo $firma['id']; ?></td>
                                    <td><?php echo htmlspecialchars($firma['nombre']); ?></td>
                                    <td><?php echo htmlspecialchars($firma['cargo']); ?></td>
                                    <td><?php echo htmlspecialchars($firma['rev_por']); ?></td>
                                    <td class="actions">
                                        <a href="configurar_firmas_secretaria.php?editar=<?php echo $firma['id']; ?>" 
                                           class="btn btn-success btn-sm">
                                            <i class="fas fa-edit"></i> Editar
                                        </a>
                                        <a href="configurar_firmas_secretaria.php?eliminar=<?php echo $firma['id']; ?>" 
                                           class="btn btn-danger btn-sm" 
                                           onclick="return confirm('¿Estás seguro de eliminar este registro?');">
                                            <i class="fas fa-trash-alt"></i> Eliminar
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <?php include '../includes/footer.php'; ?>