<?php
session_start();
// Verificar si el usuario está logueado y es administrador (o el propio coordinador si es necesario)
if (!isset($_SESSION['username']) || $_SESSION['rol'] != 'administrador') {
    http_response_code(403);
    echo json_encode(['error' => 'Acceso no autorizado.']);
    exit();
}

include '../../includes/db.php'; // RUTA CORREGIDA AQUÍ

$coordinador_id = filter_input(INPUT_GET, 'coordinador_id', FILTER_VALIDATE_INT);

$postgrados = [];

if ($coordinador_id) {
    // Consulta para obtener los postgrados asignados al coordinador1
    $sql = "SELECT p.id, p.nombre 
            FROM postgrados p
            JOIN coordinador_postgrado cp ON p.id = cp.postgrado_id
            WHERE cp.coordinador_id = ?
            ORDER BY p.nombre";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $coordinador_id);
    $stmt->execute();
    $result = $stmt->get_result();
    while ($row = $result->fetch_assoc()) {
        $postgrados[] = $row;
    }
    $stmt->close();
}

header('Content-Type: application/json');
echo json_encode($postgrados);

$conn->close();
?>