<?php
session_start();
header('Content-Type: application/json');

// Habilitar reporte de errores para depuración
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Verificar si el usuario está logueado y es administrador
if (!isset($_SESSION['username']) || $_SESSION['rol'] != 'administrador') {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Acceso no autorizado.']);
    exit();
}

// Verificar método de solicitud
if ($_SERVER['REQUEST_METHOD'] != 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Método no permitido.']);
    exit();
}

// Obtener parámetros de manera segura
$coordinador_id = isset($_POST['coordinador_id']) ? intval($_POST['coordinador_id']) : 0;
$postgrado_id = isset($_POST['postgrado_id']) ? intval($_POST['postgrado_id']) : 0;
$escolaridad_id = isset($_POST['escolaridad_id']) ? intval($_POST['escolaridad_id']) : 0;

// Validar parámetros
if ($coordinador_id <= 0 || $postgrado_id <= 0 || $escolaridad_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'Datos insuficientes o inválidos para eliminar la asignación.']);
    exit();
}

// Incluir archivo de conexión a la base de datos
$ruta_db = __DIR__ . '/../../includes/db.php';
if (!file_exists($ruta_db)) {
    echo json_encode(['success' => false, 'message' => 'Error de configuración: No se encuentra el archivo de base de datos.']);
    exit();
}

include $ruta_db;

// Verificar conexión a la base de datos
if ($conn->connect_error) {
    echo json_encode(['success' => false, 'message' => 'Error de conexión a la base de datos: ' . $conn->connect_error]);
    exit();
}

// Preparar y ejecutar consulta
$sql = "DELETE FROM coordinador_postgrado_escolaridad WHERE coordinador_id = ? AND postgrado_id = ? AND escolaridad_id = ?";
$stmt = $conn->prepare($sql);

if (!$stmt) {
    echo json_encode(['success' => false, 'message' => 'Error al preparar la consulta: ' . $conn->error]);
    $conn->close();
    exit();
}

$stmt->bind_param("iii", $coordinador_id, $postgrado_id, $escolaridad_id);

if ($stmt->execute()) {
    if ($stmt->affected_rows > 0) {
        echo json_encode(['success' => true, 'message' => 'Asignación eliminada correctamente.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'No se encontró la asignación para eliminar.']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Error al ejecutar la consulta: ' . $stmt->error]);
}

$stmt->close();
$conn->close();
?>