<?php
session_start();

// Configurar encoding UTF-8
header('Content-Type: text/html; charset=utf-8');
mb_internal_encoding('UTF-8');

if (!isset($_SESSION['username']) || $_SESSION['rol'] != 'administrador') {
    header("Location: ../login.php");
    exit();
}

include '../includes/db.php';

// Configurar conexión para usar UTF-8
$conn->set_charset("utf8mb4");
$conn->query("SET NAMES 'utf8mb4'");
$conn->query("SET CHARACTER SET utf8mb4");
$conn->query("SET COLLATION_CONNECTION = 'utf8mb4_unicode_ci'");

// Variables para almacenar los datos del estudiante y mensajes
$estudiante = null;
$success = '';

// Verificar si se ha enviado el formulario de búsqueda
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['buscar_estudiante'])) {
    $cedula = trim($_POST['cedula']);

    // BUSQUEDA ACTUALIZADA - Buscar en todos los campos de documentos
    $query = "SELECT id, cedula, nombres, apellidos, tipo_documento, cedula_venezolana, cedula_extranjera, pasaporte 
              FROM estudiantes 
              WHERE cedula = ? 
              OR cedula_venezolana = ? 
              OR cedula_extranjera = ? 
              OR pasaporte = ?";
    $stmt = $conn->prepare($query);

    if ($stmt) {
        $stmt->bind_param("ssss", $cedula, $cedula, $cedula, $cedula);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $estudiante = $result->fetch_assoc();
        } else {
            $_SESSION['error'] = "No se encontró ningún estudiante con el documento proporcionado.";
        }
        $stmt->close();
    } else {
        $_SESSION['error'] = "Error al preparar la consulta: " . $conn->error;
    }
}

// Verificar si se ha enviado el formulario de agregar suspensión
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['agregar_suspension'])) {
    $estudiante_id = intval($_POST['estudiante_id']);
    $fecha_inicio = $_POST['fecha_inicio'];
    $fecha_fin = $_POST['fecha_fin'];
    $motivo = trim($_POST['motivo']);

    // Validar que la fecha de fin sea mayor o igual a la fecha de inicio
    if ($fecha_fin < $fecha_inicio) {
        $_SESSION['error'] = "Error: La fecha de fin debe ser mayor o igual a la fecha de inicio.";
    } else {
        // Insertar la suspensión en la base de datos
        $query = "INSERT INTO suspensiones (estudiante_id, fecha_inicio, fecha_fin, motivo) VALUES (?, ?, ?, ?)";
        $stmt = $conn->prepare($query);

        if ($stmt) {
            $stmt->bind_param("isss", $estudiante_id, $fecha_inicio, $fecha_fin, $motivo);

            if ($stmt->execute()) {
                $_SESSION['success'] = "Suspensión agregada correctamente.";
                $estudiante = null;
            } else {
                $_SESSION['error'] = "Error al agregar la suspensión: " . $stmt->error;
            }
            $stmt->close();
        } else {
            $_SESSION['error'] = "Error al preparar la consulta: " . $conn->error;
        }
    }
    header("Location: agregar_suspension.php");
    exit();
}

// Verificar si se ha solicitado quitar una suspensión
if (isset($_GET['quitar_suspension'])) {
    $suspension_id = intval($_GET['quitar_suspension']);

    // Eliminar la suspensión
    $query = "DELETE FROM suspensiones WHERE id = ?";
    $stmt = $conn->prepare($query);

    if ($stmt) {
        $stmt->bind_param("i", $suspension_id);

        if ($stmt->execute()) {
            $_SESSION['success'] = "Suspensión eliminada correctamente.";
        } else {
            $_SESSION['error'] = "Error al eliminar la suspensión: " . $stmt->error;
        }
        $stmt->close();
    } else {
        $_SESSION['error'] = "Error al preparar la consulta: " . $conn->error;
    }
    header("Location: agregar_suspension.php");
    exit();
}

// Obtener la lista de estudiantes suspendidos - CONSULTA ACTUALIZADA
$sql_suspendidos = "SELECT s.id AS suspension_id, e.id AS estudiante_id, e.nombres, e.apellidos, e.cedula,
                   e.tipo_documento, e.cedula_venezolana, e.cedula_extranjera, e.pasaporte,
                   s.fecha_inicio, s.fecha_fin, s.motivo 
                   FROM suspensiones s
                   JOIN estudiantes e ON s.estudiante_id = e.id
                   WHERE s.fecha_fin >= CURDATE()
                   ORDER BY s.fecha_inicio DESC";
$result_suspendidos = $conn->query($sql_suspendidos);

$page_title = "Gestión de Suspensiones";
include '../includes/header.php';
?>

<div class="container">
    <!-- Botón para volver al panel -->
    <div class="mb-4">
        <a href="index.php" class="btn btn-secondary">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-left" viewBox="0 0 16 16">
                <path fill-rule="evenodd" d="M15 8a.5.5 0 0 0-.5-.5H2.707l3.147-3.146a.5.5 0 1 0-.708-.708l-4 4a.5.5 0 0 0 0 .708l4 4a.5.5 0 0 0 .708-.708L2.707 8.5H14.5A.5.5 0 0 0 15 8z"/>
            </svg>
            Volver al Panel
        </a>
    </div>

    <?php if (isset($_SESSION['error'])): ?>
        <div class="alert alert-danger"><?= $_SESSION['error'] ?></div>
        <?php unset($_SESSION['error']); ?>
    <?php endif; ?>
    
    <?php if (isset($_SESSION['success'])): ?>
        <div class="alert alert-success"><?= $_SESSION['success'] ?></div>
        <?php unset($_SESSION['success']); ?>
    <?php endif; ?>

    <!-- Formulario para buscar estudiante por documento -->
    <div class="card mb-4">
        <div class="card-header bg-primary text-white">
            <h3 class="mb-0">Buscar Estudiante</h3>
        </div>
        <div class="card-body">
            <form method="post">
                <div class="row g-3">
                    <div class="col-md-8">
                        <label for="cedula" class="form-label">Documento del Estudiante:</label>
                        <input type="text" class="form-control" id="cedula" name="cedula" placeholder="Cédula Venezolana, Extranjera o Pasaporte" required>
                        <div class="form-text">Puede buscar por cédula venezolana, cédula extranjera o pasaporte</div>
                    </div>
                    <div class="col-md-4 d-flex align-items-end">
                        <button type="submit" name="buscar_estudiante" class="btn btn-primary w-100">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-search" viewBox="0 0 16 16">
                                <path d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z"/>
                            </svg>
                            Buscar Estudiante
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Mostrar datos del estudiante si se encontró -->
    <?php if ($estudiante): ?>
        <div class="card mb-4">
            <div class="card-header bg-info text-white">
                <h3 class="mb-0">Agregar Suspensión</h3>
            </div>
            <div class="card-body">
                <div class="mb-4">
                    <h5>Estudiante encontrado:</h5>
                    <p><strong>Nombre:</strong> <?= htmlspecialchars($estudiante['nombres'] . ' ' . $estudiante['apellidos']) ?></p>
                    <p><strong>ID:</strong> <?= htmlspecialchars($estudiante['id']) ?></p>
                    <p><strong>Documento:</strong> 
                        <?php 
                        // Mostrar el tipo de documento y el número correspondiente
                        switch($estudiante['tipo_documento']) {
                            case 'V':
                                echo 'Cédula Venezolana: ' . htmlspecialchars($estudiante['cedula_venezolana']);
                                break;
                            case 'E':
                                echo 'Cédula Extranjera: ' . htmlspecialchars($estudiante['cedula_extranjera']);
                                break;
                            case 'P':
                                echo 'Pasaporte: ' . htmlspecialchars($estudiante['pasaporte']);
                                break;
                            default:
                                echo 'Cédula: ' . htmlspecialchars($estudiante['cedula']);
                        }
                        ?>
                    </p>
                </div>

                <form method="post">
                    <input type="hidden" name="estudiante_id" value="<?= htmlspecialchars($estudiante['id']) ?>">

                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="fecha_inicio" class="form-label">Fecha de Inicio:</label>
                            <input type="date" class="form-control" id="fecha_inicio" name="fecha_inicio" required>
                        </div>
                        
                        <div class="col-md-6">
                            <label for="fecha_fin" class="form-label">Fecha de Fin:</label>
                            <input type="date" class="form-control" id="fecha_fin" name="fecha_fin" required>
                        </div>
                        
                        <div class="col-12">
                            <label for="motivo" class="form-label">Motivo:</label>
                            <textarea class="form-control" id="motivo" name="motivo" rows="3" required></textarea>
                        </div>
                        
                        <div class="col-12">
                            <button type="submit" name="agregar_suspension" class="btn btn-success">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-save" viewBox="0 0 16 16">
                                    <path d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1H9.5a1 1 0 0 0-1 1v7.293l2.646-2.647a.5.5 0 0 1 .708.708l-3.5 3.5a.5.5 0 0 1-.708 0l-3.5-3.5a.5.5 0 1 1 .708-.708L7.5 9.293V2a2 2 0 0 1 2-2H14a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h2.5a.5.5 0 0 1 0 1H2z"/>
                                </svg>
                                Agregar Suspensión
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    <?php endif; ?>

    <!-- Lista de estudiantes suspendidos -->
    <div class="card">
        <div class="card-header bg-warning text-dark">
            <h3 class="mb-0">Estudiantes Suspendidos</h3>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Nombre</th>
                            <th>Documento</th>
                            <th>Fecha Inicio</th>
                            <th>Fecha Fin</th>
                            <th>Motivo</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($result_suspendidos->num_rows > 0): ?>
                            <?php while ($row = $result_suspendidos->fetch_assoc()): ?>
                                <tr>
                                    <td><?= htmlspecialchars($row['estudiante_id']) ?></td>
                                    <td><?= htmlspecialchars($row['nombres'] . ' ' . $row['apellidos']) ?></td>
                                    <td>
                                        <?php 
                                        // Mostrar el documento según el tipo
                                        switch($row['tipo_documento']) {
                                            case 'V':
                                                echo 'V-' . htmlspecialchars($row['cedula_venezolana']);
                                                break;
                                            case 'E':
                                                echo 'E-' . htmlspecialchars($row['cedula_extranjera']);
                                                break;
                                            case 'P':
                                                echo 'P-' . htmlspecialchars($row['pasaporte']);
                                                break;
                                            default:
                                                echo htmlspecialchars($row['cedula']);
                                        }
                                        ?>
                                    </td>
                                    <td><?= htmlspecialchars($row['fecha_inicio']) ?></td>
                                    <td><?= htmlspecialchars($row['fecha_fin']) ?></td>
                                    <td><?= htmlspecialchars($row['motivo']) ?></td>
                                    <td>
                                        <a href="agregar_suspension.php?quitar_suspension=<?= $row['suspension_id'] ?>" 
                                           class="btn btn-sm btn-danger" 
                                           onclick="return confirm('¿Estás seguro de quitar esta suspensión?');">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">
                                                <path d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6z"/>
                                                <path fill-rule="evenodd" d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1v1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4H4.118zM2.5 3V2h11v1h-11z"/>
                                            </svg>
                                            Quitar Suspensión
                                        </a>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" class="text-center">No hay estudiantes suspendidos actualmente.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php
include '../includes/footer.php';
$conn->close();
?>