<?php
// Definir la ruta base
define('BASE_PATH', dirname(__FILE__));

session_start();
include BASE_PATH . '/includes/db.php';

$mensaje = '';
$tipo_mensaje = 'info';

if (isset($_GET['token'])) {
    $token = trim($_GET['token']);
    
    if (empty($token)) {
        $mensaje = "Token no válido.";
        $tipo_mensaje = 'danger';
    } else {
        // Buscar usuario con el token y que no haya expirado
        $sql = "SELECT * FROM usuarios WHERE token_activacion = ? AND token_expiracion > NOW()";
        $stmt = $conn->prepare($sql);
        
        if ($stmt === false) {
            $mensaje = "Error en la consulta de base de datos.";
            $tipo_mensaje = 'danger';
        } else {
            $stmt->bind_param('s', $token);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if ($result->num_rows > 0) {
                $usuario = $result->fetch_assoc();
                
                // Activar cuenta
                $sql_update = "UPDATE usuarios SET estado_cuenta = 'activo', token_activacion = NULL, token_expiracion = NULL, fecha_activacion = NOW() WHERE id = ?";
                $stmt_update = $conn->prepare($sql_update);
                
                if ($stmt_update === false) {
                    $mensaje = "Error en la actualización de la cuenta.";
                    $tipo_mensaje = 'danger';
                } else {
                    $stmt_update->bind_param('i', $usuario['id']);
                    
                    if ($stmt_update->execute()) {
                        $mensaje = "¡Cuenta activada exitosamente! Ya puedes iniciar sesión en el sistema.";
                        $tipo_mensaje = 'success';
                        
                        // Registrar la activación en log
                        error_log("Cuenta activada para usuario: " . $usuario['username']);
                    } else {
                        $mensaje = "Error al activar la cuenta. Por favor, contacta al administrador.";
                        $tipo_mensaje = 'danger';
                    }
                    $stmt_update->close();
                }
            } else {
                $mensaje = "Token inválido o expirado. Si necesitas ayuda, contacta al administrador.";
                $tipo_mensaje = 'danger';
            }
            $stmt->close();
        }
    }
} else {
    $mensaje = "Token no proporcionado.";
    $tipo_mensaje = 'danger';
}

// Mostrar mensaje
include BASE_PATH . '/includes/header.php';
?>
<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h4 class="mb-0">Activación de Cuenta</h4>
                </div>
                <div class="card-body text-center">
                    <?php if ($tipo_mensaje == 'success'): ?>
                        <div class="alert alert-success">
                            <i class="fas fa-check-circle fa-3x mb-3"></i>
                            <h4>¡Activación Exitosa!</h4>
                            <p class="mb-3"><?php echo $mensaje; ?></p>
                            <a href="login.php" class="btn btn-success btn-lg">
                                <i class="fas fa-sign-in-alt"></i> Iniciar Sesión
                            </a>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-<?php echo $tipo_mensaje; ?>">
                            <i class="fas fa-exclamation-triangle fa-3x mb-3"></i>
                            <h4>Problema con la Activación</h4>
                            <p class="mb-3"><?php echo $mensaje; ?></p>
                            <div class="d-grid gap-2 d-md-block">
                                <a href="registro_estudiante.php" class="btn btn-primary">
                                    <i class="fas fa-user-plus"></i> Intentar Registro Nuevamente
                                </a>
                                <a href="contacto.php" class="btn btn-outline-secondary">
                                    <i class="fas fa-envelope"></i> Contactar Soporte
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <?php if ($tipo_mensaje == 'danger'): ?>
                        <div class="mt-4 p-3 bg-light rounded">
                            <h5>¿Necesitas ayuda?</h5>
                            <p class="mb-2">Si continúas teniendo problemas para activar tu cuenta:</p>
                            <ul class="list-unstyled">
                                <li><i class="fas fa-envelope me-2"></i> Contacta al administrador: 
                                    <a href="mailto:no-responder@postgradomedicinaucv.com">no-responder@postgradomedicinaucv.com</a>
                                </li>
                            </ul>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php
include BASE_PATH . '/includes/footer.php';
?>